/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.mgmt;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXInvalidResponseException;
import tuwien.auto.calimero.KNXRemoteException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.cemi.CEMIDevMgmt;
import tuwien.auto.calimero.mgmt.LocalDeviceManagement;
import tuwien.auto.calimero.serial.KNXPortClosedException;
import tuwien.auto.calimero.serial.usb.HidReport;
import tuwien.auto.calimero.serial.usb.TransferProtocolHeader;
import tuwien.auto.calimero.serial.usb.UsbConnection;

public class LocalDeviceManagementUsb
extends LocalDeviceManagement {
    private static final int cEmiServerObject = 8;
    private static final int pidCommMode = 52;
    private static final int responseTimeout = 1000;
    private final UsbConnection conn;

    public LocalDeviceManagementUsb(UsbConnection c, Consumer<CloseEvent> adapterClosed, boolean queryWriteEnable) throws KNXException, InterruptedException {
        super(c, adapterClosed, queryWriteEnable);
        this.conn = c;
        EnumSet<UsbConnection.EmiType> emiTypes = this.conn.getSupportedEmiTypes();
        this.conn.addConnectionListener(new LocalDeviceManagement.KNXListenerImpl());
        if (emiTypes.contains((Object)UsbConnection.EmiType.CEmi)) {
            this.conn.setActiveEmiType(UsbConnection.EmiType.CEmi);
            boolean objectInstance = true;
            this.setProperty(8, 1, 52, 1, 1, 0);
        }
        this.init();
    }

    public void setProperty(int objectType, int objectInstance, int propertyId, int start, int elements, byte ... data) throws KNXTimeoutException, KNXRemoteException, KNXPortClosedException, InterruptedException {
        CEMIDevMgmt req = new CEMIDevMgmt(246, objectType, objectInstance, propertyId, start, elements, data);
        this.send(req, null);
        this.findFrame(245, req);
    }

    public byte[] getProperty(int objectType, int objectInstance, int propertyId, int start, int elements) throws KNXTimeoutException, KNXRemoteException, KNXPortClosedException, InterruptedException {
        CEMIDevMgmt req = new CEMIDevMgmt(252, objectType, objectInstance, propertyId, start, elements);
        this.send(req, null);
        return this.findFrame(251, req);
    }

    @Override
    public String getName() {
        return "Local-DM " + this.conn.getName();
    }

    @Override
    protected void send(CEMIDevMgmt frame, Object mode) throws KNXTimeoutException, KNXPortClosedException {
        List<HidReport> reports = HidReport.create(TransferProtocolHeader.KnxTunnelEmi.CEmi, frame.toByteArray());
        for (HidReport r : reports) {
            this.conn.send(r, true);
        }
    }

    @Override
    protected byte[] findFrame(int messageCode, CEMIDevMgmt request) throws KNXRemoteException, InterruptedException {
        long remaining = 1000L;
        long end = System.currentTimeMillis() + remaining;
        while (remaining > 0L) {
            try {
                return super.findFrame(messageCode, request);
            }
            catch (KNXInvalidResponseException kNXInvalidResponseException) {
                remaining = end - System.currentTimeMillis();
                Thread.sleep(10L);
            }
        }
        throw new KNXInvalidResponseException("expected service confirmation msg code 0x" + Integer.toHexString(messageCode));
    }
}

