/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.mgmt;

import java.time.Duration;
import java.util.List;
import java.util.function.BiConsumer;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXInvalidResponseException;
import tuwien.auto.calimero.KNXRemoteException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.KNXDisconnectException;

public interface ManagementClient
extends AutoCloseable {
    @Deprecated(forRemoval=true)
    default public void setResponseTimeout(int timeout) {
        this.responseTimeout(Duration.ofSeconds(timeout));
    }

    @Deprecated(forRemoval=true)
    default public int getResponseTimeout() {
        return (int)this.responseTimeout().toSeconds();
    }

    public Duration responseTimeout();

    public void responseTimeout(Duration var1);

    public void setPriority(Priority var1);

    public Priority getPriority();

    public Destination createDestination(IndividualAddress var1, boolean var2);

    public Destination createDestination(IndividualAddress var1, boolean var2, boolean var3, boolean var4);

    public void writeAddress(IndividualAddress var1) throws KNXTimeoutException, KNXLinkClosedException;

    public IndividualAddress[] readAddress(boolean var1) throws KNXException, InterruptedException;

    public void writeAddress(SerialNumber var1, IndividualAddress var2) throws KNXTimeoutException, KNXLinkClosedException;

    default public void writeAddress(byte[] serialNo, IndividualAddress newAddress) throws KNXTimeoutException, KNXLinkClosedException {
        this.writeAddress(SerialNumber.from(serialNo), newAddress);
    }

    public IndividualAddress readAddress(SerialNumber var1) throws KNXException, InterruptedException;

    default public IndividualAddress readAddress(byte[] serialNo) throws KNXException, InterruptedException {
        return this.readAddress(SerialNumber.from(serialNo));
    }

    public void writeDomainAddress(byte[] var1) throws KNXTimeoutException, KNXLinkClosedException;

    public void writeDomainAddress(SerialNumber var1, byte[] var2) throws KNXTimeoutException, KNXLinkClosedException;

    public List<byte[]> readDomainAddress(boolean var1) throws KNXException, InterruptedException;

    public void readDomainAddress(BiConsumer<IndividualAddress, byte[]> var1) throws KNXLinkClosedException, KNXInvalidResponseException, KNXTimeoutException, InterruptedException;

    public List<byte[]> readDomainAddress(byte[] var1, IndividualAddress var2, int var3) throws KNXException, InterruptedException;

    public List<byte[]> readNetworkParameter(IndividualAddress var1, int var2, int var3, byte ... var4) throws KNXException, InterruptedException;

    public void writeNetworkParameter(IndividualAddress var1, int var2, int var3, byte ... var4) throws KNXLinkClosedException, KNXTimeoutException;

    public List<byte[]> readSystemNetworkParameter(int var1, int var2, int var3, byte ... var4) throws KNXException, InterruptedException;

    public void writeSystemNetworkParameter(int var1, int var2, byte ... var3) throws KNXLinkClosedException, KNXTimeoutException;

    public byte[] readDeviceDesc(Destination var1, int var2) throws KNXException, InterruptedException;

    public void restart(Destination var1) throws KNXTimeoutException, KNXLinkClosedException, InterruptedException;

    public Duration restart(Destination var1, EraseCode var2, int var3) throws KNXTimeoutException, KNXRemoteException, KNXDisconnectException, KNXLinkClosedException, InterruptedException;

    default public int restart(Destination dst, int eraseCode, int channel) throws KNXTimeoutException, KNXRemoteException, KNXDisconnectException, KNXLinkClosedException, InterruptedException {
        return (int)this.restart(dst, EraseCode.of(eraseCode), channel).toSeconds();
    }

    public byte[] readProperty(Destination var1, int var2, int var3, int var4, int var5) throws KNXException, InterruptedException;

    public void writeProperty(Destination var1, int var2, int var3, int var4, int var5, byte[] var6) throws KNXException, InterruptedException;

    public void writeProperty(Destination var1, int var2, int var3, int var4, int var5, int var6, byte[] var7) throws KNXException, InterruptedException;

    public byte[] readPropertyDesc(Destination var1, int var2, int var3, int var4) throws KNXException, InterruptedException;

    public byte[] callFunctionProperty(Destination var1, int var2, int var3, int var4, int var5, byte ... var6) throws KNXException, InterruptedException;

    public byte[] readFunctionPropertyState(Destination var1, int var2, int var3, int var4, int var5, byte ... var6) throws KNXException, InterruptedException;

    public int readADC(Destination var1, int var2, int var3) throws KNXException, InterruptedException;

    public byte[] readMemory(Destination var1, int var2, int var3) throws KNXException, InterruptedException;

    public void writeMemory(Destination var1, int var2, byte[] var3) throws KNXException, InterruptedException;

    public int authorize(Destination var1, byte[] var2) throws KNXException, InterruptedException;

    public void writeKey(Destination var1, int var2, byte[] var3) throws KNXException, InterruptedException;

    public boolean isOpen();

    public KNXNetworkLink detach();

    @Override
    default public void close() {
        this.detach();
    }

    public static enum EraseCode {
        ConfirmedRestart,
        FactoryReset,
        ResetIndividualAddress,
        ResetApplicationProgram,
        ResetApplicationParameters,
        ResetLinks,
        FactoryResetWithoutIndividualAddress;


        public static EraseCode of(int eraseCode) {
            if (eraseCode > 0 && eraseCode <= EraseCode.values().length) {
                return EraseCode.values()[eraseCode - 1];
            }
            throw new KNXIllegalArgumentException("unsupported erase code " + eraseCode);
        }

        public int code() {
            return this.ordinal() + 1;
        }
    }
}

