/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.mgmt;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DetachEvent;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXInvalidResponseException;
import tuwien.auto.calimero.KNXRemoteException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.ReturnCode;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.dptxlator.PropertyTypes;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.mgmt.Description;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.KNXDisconnectException;
import tuwien.auto.calimero.mgmt.ManagementClient;
import tuwien.auto.calimero.mgmt.SecureManagement;
import tuwien.auto.calimero.mgmt.TransportLayer;
import tuwien.auto.calimero.mgmt.TransportLayerImpl;
import tuwien.auto.calimero.mgmt.TransportListener;
import tuwien.auto.calimero.secure.KnxSecureException;
import tuwien.auto.calimero.secure.Security;
import tuwien.auto.calimero.secure.SecurityControl;

public class ManagementClientImpl
implements ManagementClient {
    private static final int ADC_READ = 384;
    private static final int ADC_RESPONSE = 448;
    private static final int AUTHORIZE_READ = 977;
    private static final int AUTHORIZE_RESPONSE = 978;
    private static final int DOA_WRITE = 992;
    private static final int DOA_READ = 993;
    private static final int DOA_RESPONSE = 994;
    private static final int DOA_SELECTIVE_READ = 995;
    private static final int IND_ADDR_READ = 256;
    private static final int IND_ADDR_RESPONSE = 320;
    private static final int IND_ADDR_WRITE = 192;
    private static final int IND_ADDR_SN_READ = 988;
    private static final int IND_ADDR_SN_RESPONSE = 989;
    private static final int IND_ADDR_SN_WRITE = 990;
    private static final int DEVICE_DESC_READ = 768;
    private static final int DEVICE_DESC_RESPONSE = 832;
    private static final int KEY_WRITE = 979;
    private static final int KEY_RESPONSE = 980;
    private static final int MEMORY_READ = 512;
    private static final int MEMORY_RESPONSE = 576;
    private static final int MEMORY_WRITE = 640;
    private static final int PROPERTY_DESC_READ = 984;
    private static final int PROPERTY_DESC_RESPONSE = 985;
    private static final int PROPERTY_READ = 981;
    private static final int PROPERTY_RESPONSE = 982;
    private static final int PROPERTY_WRITE = 983;
    private static final int FunctionPropertyExtCommand = 468;
    private static final int FunctionPropertyExtStateRead = 469;
    private static final int FunctionPropertyExtStateResponse = 470;
    private static final int SystemNetworkParamRead = 456;
    private static final int SystemNetworkParamResponse = 457;
    private static final int SystemNetworkParamWrite = 458;
    private static final int NetworkParamRead = 986;
    private static final int NetworkParamResponse = 987;
    static final int NetworkParamWrite = 996;
    private static final int MemoryExtendedWrite = 507;
    private static final int MemoryExtendedWriteResponse = 508;
    private static final int MemoryExtendedRead = 509;
    private static final int MemoryExtendedReadResponse = 510;
    private static final int DomainAddressSerialNumberWrite = 1006;
    private static final int RESTART = 896;
    private static final boolean extMemoryServices = true;
    private final TransportLayer tl;
    private final TLListener tlListener = new TLListener();
    private final SecureManagement sal;
    private final boolean toolAccess = true;
    private final IndividualAddress src;
    private volatile Priority priority = Priority.LOW;
    private volatile Duration responseTimeout = Duration.ofSeconds(5L);
    private final Deque<FrameEvent> indications = new ArrayDeque<FrameEvent>();
    private final ConcurrentHashMap<Integer, Long> activeServiceResponses = new ConcurrentHashMap();
    private volatile boolean detachTransportLayer;
    private volatile boolean detached;
    private final Logger logger;
    private final EventListeners<Consumer<FrameEvent>> listeners;
    private static final int PropertyExtWrite = 462;
    private static final int PropertyExtWriteResponse = 463;
    private static final int PropertyExtDescRead = 466;
    private static final int PropertyExtDescResponse = 467;
    private static final boolean useExtPropertyServices = false;

    SecureManagement secureApplicationLayer() {
        return this.sal;
    }

    public ManagementClientImpl(KNXNetworkLink link) throws KNXLinkClosedException {
        this(link, new TransportLayerImpl(link));
        this.detachTransportLayer = true;
    }

    protected ManagementClientImpl(KNXNetworkLink link, TransportLayer transportLayer) {
        this.tl = transportLayer;
        this.logger = LogService.getLogger("calimero.mgmt.MC " + link.getName());
        this.src = link.getKNXMedium().getDeviceAddress();
        this.listeners = new EventListeners(this.logger);
        this.sal = new SecureManagement(this.tl, Security.defaultInstallation().deviceToolKeys());
        this.sal.addListener(this.tlListener);
    }

    public final void addEventListener(Consumer<FrameEvent> onEvent) {
        this.listeners.add(onEvent);
    }

    public final void removeEventListener(Consumer<FrameEvent> onEvent) {
        this.listeners.remove(onEvent);
    }

    @Override
    public Duration responseTimeout() {
        return this.responseTimeout;
    }

    @Override
    public void responseTimeout(Duration timeout) {
        if (timeout.isNegative() || timeout.isZero()) {
            throw new KNXIllegalArgumentException("timeout <= 0");
        }
        this.responseTimeout = timeout;
    }

    @Override
    public void setPriority(Priority p) {
        this.priority = p;
    }

    @Override
    public Priority getPriority() {
        return this.priority;
    }

    @Override
    public Destination createDestination(IndividualAddress remote, boolean connectionOriented) {
        return this.tl.createDestination(remote, connectionOriented);
    }

    @Override
    public Destination createDestination(IndividualAddress remote, boolean connectionOriented, boolean keepAlive, boolean verifyMode) {
        return this.tl.createDestination(remote, connectionOriented, keepAlive, verifyMode);
    }

    @Override
    public void writeAddress(IndividualAddress newAddress) throws KNXTimeoutException, KNXLinkClosedException {
        this.tl.broadcast(false, Priority.SYSTEM, DataUnitBuilder.createAPDU(192, newAddress.toByteArray()));
    }

    @Override
    public IndividualAddress[] readAddress(boolean oneAddressOnly) throws KNXTimeoutException, KNXRemoteException, KNXLinkClosedException, InterruptedException {
        long start = this.registerActiveService(320);
        this.tl.broadcast(false, Priority.SYSTEM, DataUnitBuilder.createLengthOptimizedAPDU(256, new byte[0]));
        ArrayList l = new ArrayList();
        this.waitForResponses(320, 0, 0, start, this.responseTimeout, (source, data) -> {
            l.add(source);
            return Optional.of(source.toByteArray());
        }, oneAddressOnly);
        return (IndividualAddress[])l.toArray(IndividualAddress[]::new);
    }

    @Override
    public void writeAddress(SerialNumber serialNo, IndividualAddress newAddress) throws KNXTimeoutException, KNXLinkClosedException {
        byte[] apdu = DataUnitBuilder.apdu(990).put(serialNo.array()).put(newAddress.toByteArray()).putShort(0).putShort(0).build();
        this.broadcast(serialNo, new IndividualAddress(0), false, Priority.SYSTEM, apdu, false);
    }

    @Override
    public IndividualAddress readAddress(SerialNumber serialNumber) throws KNXTimeoutException, KNXRemoteException, KNXLinkClosedException, InterruptedException {
        long start = this.registerActiveService(989);
        this.tl.broadcast(false, Priority.SYSTEM, DataUnitBuilder.createAPDU(988, serialNumber.array()));
        byte[] address = this.waitForResponses(989, 10, 10, start, this.responseTimeout, (source, apdu) -> Arrays.equals(serialNumber.array(), 0, 6, apdu, 2, 8) ? Optional.of(source.toByteArray()) : Optional.empty(), true).get(0);
        return new IndividualAddress(address);
    }

    @Override
    public void writeDomainAddress(byte[] domain) throws KNXTimeoutException, KNXLinkClosedException {
        if (domain.length != 2 && domain.length != 6) {
            throw new KNXIllegalArgumentException("invalid length of domain address");
        }
        this.broadcast(SerialNumber.Zero, new IndividualAddress(0), true, this.priority, DataUnitBuilder.createAPDU(992, domain), false);
    }

    @Override
    public void writeDomainAddress(SerialNumber serialNumber, byte[] domain) throws KNXTimeoutException, KNXLinkClosedException {
        if (domain.length != 2 && domain.length != 4 && domain.length != 6 && domain.length != 21) {
            throw new KNXIllegalArgumentException("domain address with invalid length " + domain.length);
        }
        byte[] apdu = DataUnitBuilder.apdu(1006).put(serialNumber.array()).put(domain).build();
        boolean requireSecure = domain.length == 21;
        this.broadcast(serialNumber, new IndividualAddress(0), true, this.priority, apdu, requireSecure);
    }

    private void broadcast(SerialNumber serialNumber, IndividualAddress dst, boolean systemBcast, Priority p, byte[] apdu, boolean requireSecure) throws KNXTimeoutException, KNXLinkClosedException {
        try {
            SecurityControl securityCtrl = systemBcast ? SecurityControl.SystemBroadcast : SecurityControl.of(SecurityControl.DataSecurity.AuthConf, true);
            byte[] tsdu = this.sal.secureBroadcastData(this.src, serialNumber, dst, apdu, securityCtrl).orElseGet(() -> {
                if (requireSecure) {
                    throw new KnxSecureException("broadcast requires data security");
                }
                return apdu;
            });
            this.tl.broadcast(systemBcast, p, tsdu);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public List<byte[]> readDomainAddress(boolean oneDomainOnly) throws KNXLinkClosedException, KNXInvalidResponseException, KNXTimeoutException, InterruptedException {
        return ManagementClientImpl.makeDOAs(this.readBroadcast(this.priority, DataUnitBuilder.createLengthOptimizedAPDU(993, new byte[0]), 994, 2, 6, oneDomainOnly));
    }

    @Override
    public void readDomainAddress(BiConsumer<IndividualAddress, byte[]> response) throws KNXLinkClosedException, KNXInvalidResponseException, KNXTimeoutException, InterruptedException {
        long start = this.registerActiveService(994);
        this.tl.broadcast(true, this.priority, DataUnitBuilder.createLengthOptimizedAPDU(993, new byte[0]));
        try {
            this.waitForResponses(994, 2, 6, start, this.responseTimeout, (source, apdu1) -> {
                response.accept((IndividualAddress)source, Arrays.copyOfRange(apdu1, 2, ((byte[])apdu1).length));
                return Optional.of(apdu1);
            }, false);
        }
        catch (KNXTimeoutException kNXTimeoutException) {
            // empty catch block
        }
    }

    @Override
    public List<byte[]> readDomainAddress(byte[] domain, IndividualAddress start, int range) throws KNXInvalidResponseException, KNXLinkClosedException, KNXTimeoutException, InterruptedException {
        if (domain.length != 2) {
            throw new KNXIllegalArgumentException("length of domain address not 2 bytes");
        }
        if (range < 0 || range > 255) {
            throw new KNXIllegalArgumentException("range out of range [0..255]");
        }
        byte[] apdu = DataUnitBuilder.apdu(995).put(domain).put(start.toByteArray()).put(range).build();
        return ManagementClientImpl.makeDOAs(this.readBroadcast(this.priority, apdu, 994, 2, 2, false));
    }

    @Override
    public List<byte[]> readNetworkParameter(IndividualAddress remote, int objectType, int pid, byte ... testInfo) throws KNXLinkClosedException, KNXTimeoutException, KNXInvalidResponseException, InterruptedException {
        long start = this.registerActiveService(987);
        this.sendNetworkParameter(986, remote, objectType, pid, testInfo);
        BiFunction<IndividualAddress, byte[], Optional<byte[]>> testResponse = (responder, apdu) -> {
            if (((byte[])apdu).length < 5) {
                return Optional.empty();
            }
            int receivedIot = (apdu[2] & 0xFF) << 8 | apdu[3] & 0xFF;
            int receivedPid = apdu[4] & 0xFF;
            if (((byte[])apdu).length == 5) {
                String s = receivedPid == 255 ? (receivedIot == 65535 ? "object type" : "PID") : "response";
                this.logger.info("network parameter read response from {} for interface object type {} PID {}: unsupported {}", new Object[]{responder, objectType, pid, s});
                return Optional.empty();
            }
            return receivedIot == objectType && receivedPid == pid ? Optional.of(apdu) : Optional.empty();
        };
        try {
            List<byte[]> responses = this.waitForResponses(987, 3, 14, start, this.responseTimeout, testResponse, false);
            int prefix = 5 + testInfo.length;
            return responses.stream().map(r -> Arrays.copyOfRange(r, prefix, ((byte[])r).length)).collect(Collectors.toList());
        }
        catch (KNXTimeoutException e) {
            return List.of();
        }
    }

    @Override
    public void writeNetworkParameter(IndividualAddress remote, int objectType, int pid, byte ... value) throws KNXLinkClosedException, KNXTimeoutException {
        this.sendNetworkParameter(996, remote, objectType, pid, value);
    }

    private void sendNetworkParameter(int apci, IndividualAddress remote, int objectType, int pid, byte[] value) throws KNXTimeoutException, KNXLinkClosedException {
        if (objectType < 0 || objectType > 65535 || pid < 0 || pid > 255) {
            throw new KNXIllegalArgumentException("IOT or PID argument out of range");
        }
        byte[] asdu = new byte[3 + value.length];
        asdu[0] = (byte)(objectType >> 8);
        asdu[1] = (byte)objectType;
        asdu[2] = (byte)pid;
        for (int i = 0; i < value.length; ++i) {
            asdu[3 + i] = value[i];
        }
        Priority p = Priority.SYSTEM;
        byte[] tsdu = DataUnitBuilder.createAPDU(apci, asdu);
        if (remote != null) {
            this.tl.sendData(remote, p, tsdu);
        } else {
            this.tl.broadcast(true, p, tsdu);
        }
    }

    @Override
    public List<byte[]> readSystemNetworkParameter(int objectType, int pid, int operand, byte ... additionalTestInfo) throws KNXException, InterruptedException {
        if (operand < 0 || operand > 254) {
            throw new KNXIllegalArgumentException("operand out of range");
        }
        byte[] testInfo = ByteBuffer.allocate(1 + additionalTestInfo.length).put((byte)operand).put(additionalTestInfo).array();
        long start = this.registerActiveService(457);
        this.sendSystemNetworkParameter(456, objectType, pid, testInfo);
        BiFunction<IndividualAddress, byte[], Optional<byte[]>> testParamType = (responder, apdu) -> {
            if (((byte[])apdu).length < 6) {
                return Optional.empty();
            }
            int receivedIot = (apdu[2] & 0xFF) << 8 | apdu[3] & 0xFF;
            int receivedPid = (apdu[4] & 0xFF) << 4 | (apdu[5] & 0xF0) >> 4;
            if (((byte[])apdu).length == 6) {
                String s = receivedPid == 255 ? (receivedIot == 65535 ? "object type" : "PID") : "response";
                this.logger.info("system network parameter read response from {} for interface object type {} PID {}: unsupported {}", new Object[]{responder, objectType, pid, s});
                return Optional.empty();
            }
            int receivedOperand = apdu[6] & 0xFF;
            return receivedIot == objectType && receivedPid == pid && receivedOperand == operand ? Optional.of(apdu) : Optional.empty();
        };
        Duration waitTime = Duration.ofSeconds(operand == 1 ? 1L : (operand == 2 || operand == 3 ? (long)(additionalTestInfo[0] & 0xFF) : this.responseTimeout().toSeconds())).plusMillis(500L);
        try {
            List<byte[]> responders = this.waitForResponses(457, 4, 12, start, waitTime, testParamType, false);
            int prefix = 7 + additionalTestInfo.length;
            return responders.stream().map(r -> Arrays.copyOfRange(r, prefix, ((byte[])r).length)).collect(Collectors.toList());
        }
        catch (KNXTimeoutException e) {
            return List.of();
        }
    }

    @Override
    public void writeSystemNetworkParameter(int objectType, int pid, byte ... value) throws KNXLinkClosedException, KNXTimeoutException {
        this.sendSystemNetworkParameter(458, objectType, pid, value);
    }

    private void sendSystemNetworkParameter(int apci, int objectType, int pid, byte[] value) throws KNXTimeoutException, KNXLinkClosedException {
        if (objectType < 0 || objectType > 65535 || pid < 0 || pid > 4095) {
            throw new KNXIllegalArgumentException("IOT or PID argument out of range");
        }
        byte[] asdu = ByteBuffer.allocate(4 + value.length).putShort((short)objectType).putShort((short)(pid << 4)).put(value).array();
        byte[] tsdu = DataUnitBuilder.createAPDU(apci, asdu);
        this.tl.broadcast(true, Priority.SYSTEM, tsdu);
    }

    @Override
    public byte[] readDeviceDesc(Destination dst, int descType) throws KNXInvalidResponseException, KNXDisconnectException, KNXTimeoutException, KNXLinkClosedException, InterruptedException {
        if (descType < 0 || descType > 63) {
            throw new KNXIllegalArgumentException("descriptor type out of range [0..63]");
        }
        byte[] apdu = this.sendWait2(dst, this.priority, DataUnitBuilder.createLengthOptimizedAPDU(768, (byte)descType), 832, 2, 14);
        byte[] dd = new byte[apdu.length - 2];
        for (int i = 0; i < apdu.length - 2; ++i) {
            dd[i] = apdu[2 + i];
        }
        return dd;
    }

    @Override
    public void restart(Destination dst) throws KNXTimeoutException, KNXLinkClosedException, InterruptedException {
        try {
            this.restart(true, dst, null, 0);
        }
        catch (KNXRemoteException | KNXDisconnectException kNXException) {
            // empty catch block
        }
    }

    @Override
    public Duration restart(Destination dst, ManagementClient.EraseCode eraseCode, int channel) throws KNXTimeoutException, KNXRemoteException, KNXDisconnectException, KNXLinkClosedException, InterruptedException {
        return this.restart(false, dst, eraseCode, channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Duration restart(boolean basic, final Destination dst, ManagementClient.EraseCode eraseCode, int channel) throws KNXTimeoutException, KNXRemoteException, KNXDisconnectException, KNXLinkClosedException, InterruptedException {
        int time = 0;
        if (basic) {
            this.send(dst, this.priority, DataUnitBuilder.createLengthOptimizedAPDU(896, new byte[0]), 0);
        } else {
            byte[] sdu = new byte[]{1, (byte)eraseCode.code(), (byte)channel};
            byte[] send = DataUnitBuilder.createLengthOptimizedAPDU(896, sdu);
            byte[] apdu = this.sendWait2(dst, this.priority, send, 896, 3, 3);
            if ((apdu[1] & 0x32) == 0) {
                throw new KNXInvalidResponseException("restart response bit not set");
            }
            String[] codes = new String[]{"Success", "Access Denied", "Unsupported Erase Code", "Invalid Channel Number", "Unknown Error"};
            int error = Math.min(apdu[2] & 0xFF, 4);
            if (error > 0) {
                throw new KNXRemoteException("master reset: " + codes[error]);
            }
            time = (apdu[3] & 0xFF) << 8 | apdu[4] & 0xFF;
        }
        if (dst.isConnectionOriented()) {
            final Object lock = new Object();
            TLListener l = new TLListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void disconnected(Destination d) {
                    if (d.equals(dst)) {
                        Object object = lock;
                        synchronized (object) {
                            lock.notify();
                        }
                    }
                }
            };
            this.tl.addTransportListener(l);
            try {
                Object object = lock;
                synchronized (object) {
                    while (dst.getState() != Destination.State.Disconnected) {
                        lock.wait();
                    }
                }
            }
            finally {
                this.tl.removeTransportListener(l);
            }
            this.tl.disconnect(dst);
        }
        return Duration.ofSeconds(time);
    }

    @Override
    public byte[] readProperty(Destination dst, int objIndex, int propertyId, int start, int elements) throws KNXTimeoutException, KNXRemoteException, KNXDisconnectException, KNXLinkClosedException, InterruptedException {
        return this.readProperty(dst, objIndex, propertyId, start, elements, true).get(0);
    }

    List<byte[]> readProperty(Destination dst, int objIndex, int propertyId, int start, int elements, boolean oneResponseOnly) throws KNXTimeoutException, KNXRemoteException, KNXDisconnectException, KNXLinkClosedException, InterruptedException {
        if (objIndex < 0 || objIndex > 255 || propertyId < 0 || propertyId > 255 || start < 0 || start > 4095 || elements < 0 || elements > 15) {
            throw new KNXIllegalArgumentException(String.format("argument value out of range: OI 0 < %d < 256, PID 0 < %d < 256, start 0 < %d < 256, elems 0 < %d < 16", objIndex, propertyId, start, elements));
        }
        int maxAsduLength = this.maxAsduLength(dst);
        int elemsInAsdu = elements;
        if (elements > 1) {
            byte[] data = this.readPropertyDesc(dst, objIndex, propertyId, 0);
            Description desc = new Description(0, data);
            int typeSize = Math.max(8, PropertyTypes.bitSize(desc.getPDT()).orElse(8)) / 8;
            elemsInAsdu = (maxAsduLength - 4) / typeSize;
        }
        ArrayList<byte[]> responses = new ArrayList<byte[]>();
        ArrayList exceptions = new ArrayList();
        for (int i = 0; i < elements; i += elemsInAsdu) {
            int queryElements = Math.min(elemsInAsdu, elements - i);
            byte[] send = DataUnitBuilder.apdu(981).put(objIndex).put(propertyId).put(queryElements << 4 | start + i >>> 8 & 0xF).put(start + i).build();
            long startSend = this.send(dst, this.priority, send, 982);
            this.waitForResponses(982, 4, maxAsduLength, startSend, this.responseTimeout, (source, apdu) -> {
                try {
                    if (source.equals(dst.getAddress())) {
                        responses.add(ManagementClientImpl.extractPropertyElements(apdu, objIndex, propertyId, queryElements));
                        return Optional.of(apdu);
                    }
                }
                catch (KNXInvalidResponseException e) {
                    this.logger.debug("skip invalid property read response: {}", (Object)e.getMessage());
                }
                catch (KNXRemoteException e) {
                    exceptions.add(e);
                    return Optional.of(new byte[0]);
                }
                return Optional.empty();
            }, oneResponseOnly);
        }
        if (responses.isEmpty()) {
            if (exceptions.size() == 1) {
                throw (KNXRemoteException)exceptions.get(0);
            }
            KNXRemoteException e = new KNXRemoteException("reading property " + dst.getAddress() + " OI " + objIndex + " PID " + propertyId + " failed");
            if (exceptions.size() > 0) {
                exceptions.forEach(e::addSuppressed);
            }
            throw e;
        }
        if (oneResponseOnly) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            responses.forEach(baos::writeBytes);
            return List.of(baos.toByteArray());
        }
        return responses;
    }

    @Override
    public void writeProperty(Destination dst, int objIndex, int propertyId, int start, int elements, byte[] data) throws KNXTimeoutException, KNXRemoteException, KNXDisconnectException, KNXLinkClosedException, InterruptedException {
        if (objIndex < 0 || objIndex > 255 || propertyId < 0 || propertyId > 255 || start < 0 || start > 4095 || data.length == 0 || elements < 0 || elements > 15) {
            throw new KNXIllegalArgumentException("argument value out of range");
        }
        byte[] asdu = new byte[4 + data.length];
        asdu[0] = (byte)objIndex;
        asdu[1] = (byte)propertyId;
        asdu[2] = (byte)(elements << 4 | start >>> 8 & 0xF);
        asdu[3] = (byte)start;
        for (int i = 0; i < data.length; ++i) {
            asdu[4 + i] = data[i];
        }
        byte[] send = DataUnitBuilder.createAPDU(983, asdu);
        byte[] apdu = this.sendWait2(dst, this.priority, send, 982, 4, this.maxAsduLength(dst));
        int elems = (apdu[4] & 0xFF) >> 4;
        if (elems == 0) {
            throw new KNXRemoteException("property write failed/forbidden");
        }
        if (elems != elements) {
            throw new KNXInvalidResponseException("number of elements differ");
        }
        if (data.length != apdu.length - 6) {
            throw new KNXInvalidResponseException("data lengths differ, bytes: " + data.length + " written, " + (apdu.length - 6) + " response");
        }
        for (int i = 4; i < asdu.length; ++i) {
            if (apdu[2 + i] == asdu[i]) continue;
            throw new KNXRemoteException("read back failed (erroneous property data)");
        }
    }

    @Override
    public void writeProperty(Destination dst, int objectType, int objectInstance, int propertyId, int start, int elements, byte[] data) throws KNXException, InterruptedException {
        BiFunction<IndividualAddress, byte[], Optional<byte[]>> responseFilter;
        long startSend = this.sendProperty(462, 463, dst, objectType, objectInstance, propertyId, start, elements, data);
        List<byte[]> response = this.waitForResponses(463, 9, 9, startSend, this.responseTimeout, responseFilter = (responder, apdu) -> {
            if (!responder.equals(dst.getAddress()) || ((byte[])apdu).length != 11) {
                return Optional.empty();
            }
            int receivedIot = (apdu[2] & 0xFF) << 8 | apdu[3] & 0xFF;
            int receivedObjInst = (apdu[4] & 0xFF) << 4 | (apdu[5] & 0xF0) >> 4;
            int receivedPid = (apdu[5] & 0xF) << 8 | apdu[6] & 0xFF;
            int receivedStart = (apdu[8] & 0xFF) << 8 | apdu[9] & 0xFF;
            return receivedIot == objectType && receivedObjInst == objectInstance && receivedPid == propertyId && receivedStart == start ? Optional.of(apdu) : Optional.empty();
        }, true);
        ReturnCode returnCode = ReturnCode.of(response.get(0)[8] & 0xFF);
        if (returnCode != ReturnCode.Success) {
            throw new KNXRemoteException(String.format("write property response for %d(%d)|%d: %s", objectType, objectInstance, propertyId, returnCode.friendly()));
        }
    }

    private long sendProperty(int svc, int svcRes, Destination dst, int objectType, int objectInstance, int propertyId, int start, int elements, byte[] data) throws KNXTimeoutException, KNXDisconnectException, KNXLinkClosedException, InterruptedException {
        if (objectType < 0 || objectType > 65535 || propertyId < 0 || propertyId > 4095 || start < 0 || start > 65535 || elements < 0 || elements > 255 || data.length == 0) {
            throw new KNXIllegalArgumentException("argument value out of range");
        }
        int securityObjectType = 17;
        int pidToolKey = 56;
        Map<IndividualAddress, byte[]> deviceToolKeys = this.sal.security().deviceToolKeys();
        byte[] updateToolKey = null;
        byte[] oldToolKey = null;
        if (objectType == 17 && objectInstance == 1 && propertyId == 56) {
            updateToolKey = (byte[])data.clone();
            oldToolKey = deviceToolKeys.get(dst.getAddress());
        }
        byte[] apdu = DataUnitBuilder.apdu(svc).putShort(objectType).putShort(objectInstance << 4 | propertyId >> 8).put(propertyId).put(elements).putShort(start).put(data).build();
        try {
            long s = this.send(dst, this.priority, apdu, svcRes, updateToolKey);
            updateToolKey = oldToolKey;
            long l = s;
            return l;
        }
        catch (InterruptedException | RuntimeException | KNXException e) {
            if (updateToolKey != null) {
                byte[] toolKey = oldToolKey;
                deviceToolKeys.compute(dst.getAddress(), (__, ___) -> toolKey);
            }
            throw e;
        }
        finally {
            if (updateToolKey != null) {
                Arrays.fill(updateToolKey, (byte)0);
            }
        }
    }

    private int[] getOrQueryInterfaceObjectList(Destination dst) throws KNXTimeoutException, KNXDisconnectException, KNXLinkClosedException, InterruptedException {
        Optional<int[]> opt = dst.interfaceObjectList();
        if (opt.isPresent()) {
            return opt.get();
        }
        int[] list = new int[]{};
        try {
            int elems = ManagementClientImpl.unsigned(this.readProperty(dst, 0, 71, 0, 1));
            list = new int[elems];
            for (int i = 0; i < list.length; ++i) {
                list[i] = ManagementClientImpl.unsigned(this.readProperty(dst, 0, 71, i + 1, 1));
            }
        }
        catch (KNXRemoteException e) {
            this.logger.debug("device {} does not support extended property services ({})", (Object)dst.getAddress(), (Object)e.toString());
        }
        dst.setInterfaceObjectList(list);
        return list;
    }

    private static int unsigned(byte[] data) {
        int i = 0;
        for (byte b : data) {
            i = i << 8 | b & 0xFF;
        }
        return i;
    }

    private Description readPropertyExtDescription(Destination dst, int objIndex, int propertyId, int propIndex) throws KNXTimeoutException, KNXRemoteException, KNXDisconnectException, KNXLinkClosedException, InterruptedException {
        if (objIndex < 0 || objIndex > 4095 || propertyId < 0 || propertyId > 4095 || propIndex < 0 || propIndex > 4095) {
            throw new KNXIllegalArgumentException("argument value out of range");
        }
        int[] ioList = this.getOrQueryInterfaceObjectList(dst);
        if (ioList.length <= objIndex) {
            return null;
        }
        int objType = ioList[objIndex];
        boolean objInstance = true;
        boolean propDescType = false;
        byte[] send = DataUnitBuilder.createAPDU(466, (byte)(objType >> 8), (byte)objType, 0, (byte)(0x10 | propertyId >> 8), (byte)propertyId, (byte)(0 | propIndex >> 8), (byte)(propertyId == 0 ? propIndex : 0));
        for (int i = 0; i < 2; ++i) {
            byte[] apdu = this.sendWait2(dst, this.priority, send, 467, 15, 15);
            int rcvPropertyId = (apdu[5] & 0xF) << 8 | apdu[6] & 0xFF;
            int rcvPropDescType = apdu[7] >> 4 & 0xF;
            int rcvPropertyIdx = (apdu[7] & 0xF) << 8 | apdu[8] & 0xFF;
            int rcvObjectType = (apdu[2] & 0xFF) << 8 | apdu[3] & 0xFF;
            boolean objTypeOk = objType == rcvObjectType;
            int rcvObjInstance = (apdu[4] & 0xFF) << 4 | (apdu[5] & 0xF0) >> 4;
            boolean oiOk = 1 == rcvObjInstance;
            boolean pidOk = propertyId == 0 || propertyId == rcvPropertyId;
            boolean pidxOk = propertyId != 0 || propIndex == rcvPropertyIdx;
            int dptMain = (apdu[9] & 0xFF) << 8 | apdu[10] & 0xFF;
            int dptSub = (apdu[11] & 0xFF) << 8 | apdu[12] & 0xFF;
            boolean writeable = (apdu[13] & 0x80) == 128;
            int pdt = apdu[13] & 0x2F;
            int maxElems = (apdu[14] & 0xFF) << 8 | apdu[15] & 0xFF;
            int readLevel = (apdu[16] & 0xF0) >> 4;
            int writeLevel = apdu[16] & 0xF;
            if (rcvPropDescType == 0 && dptMain == 0 && dptSub == 0 && !writeable && pdt == 0 && maxElems == 0 && readLevel == 0 && writeLevel == 0) {
                throw new KNXRemoteException("problem with property description request (IOT or PID non-existant?)");
            }
            if (rcvPropDescType != 0) {
                throw new KNXRemoteException("property description type " + rcvPropDescType + " not supported");
            }
            if (objTypeOk && oiOk && pidOk && pidxOk) {
                return Description.of(objIndex, Arrays.copyOfRange(apdu, 2, apdu.length));
            }
            this.logger.warn("wrong description response for OI {} PID {} prop idx {} (got {}({})|{} (idx {}))", new Object[]{objIndex, propertyId, propIndex, rcvObjectType, rcvObjInstance, rcvPropertyId, rcvPropertyIdx});
        }
        throw new KNXTimeoutException("timeout occurred while waiting for data response");
    }

    @Override
    public byte[] readPropertyDesc(Destination dst, int objIndex, int propertyId, int propIndex) throws KNXTimeoutException, KNXRemoteException, KNXDisconnectException, KNXLinkClosedException, InterruptedException {
        if (objIndex < 0 || objIndex > 255 || propertyId < 0 || propertyId > 255 || propIndex < 0 || propIndex > 255) {
            throw new KNXIllegalArgumentException("argument value out of range");
        }
        byte[] send = DataUnitBuilder.createAPDU(984, (byte)objIndex, (byte)propertyId, (byte)(propertyId == 0 ? propIndex : 0));
        for (int i = 0; i < 2; ++i) {
            boolean pidxOk;
            byte[] apdu = this.sendWait2(dst, this.priority, send, 985, 7, 7);
            boolean oiOk = objIndex == (apdu[2] & 0xFF);
            boolean pidOk = propertyId == 0 || propertyId == (apdu[3] & 0xFF);
            boolean bl = pidxOk = propertyId != 0 || propIndex == (apdu[4] & 0xFF);
            if (oiOk && pidOk && pidxOk) {
                if (apdu[6] == 0 && apdu[7] == 0) {
                    throw new KNXRemoteException("got no property description (object non-existant?)");
                }
                return new byte[]{apdu[2], apdu[3], apdu[4], apdu[5], apdu[6], apdu[7], apdu[8]};
            }
            this.logger.warn("wrong description response for OI {} PID {} prop idx {} (got {}|{} (idx {}))", new Object[]{objIndex, propertyId, propIndex, apdu[2] & 0xFF, apdu[3] & 0xFF, apdu[4] & 0xFF});
        }
        throw new KNXTimeoutException("timeout occurred while waiting for data response");
    }

    @Override
    public byte[] callFunctionProperty(Destination dst, int objectType, int objInstance, int propertyId, int serviceId, byte ... serviceInfo) throws KNXException, InterruptedException {
        return this.functionProperty(468, dst, objectType, objInstance, propertyId, serviceId, serviceInfo);
    }

    @Override
    public byte[] readFunctionPropertyState(Destination dst, int objectType, int objInstance, int propertyId, int serviceId, byte ... serviceInfo) throws KNXException, InterruptedException {
        return this.functionProperty(469, dst, objectType, objInstance, propertyId, serviceId, serviceInfo);
    }

    private byte[] functionProperty(int cmd, Destination dst, int objectType, int objInstance, int propertyId, int service, byte ... info) throws KNXLinkClosedException, KNXDisconnectException, KNXTimeoutException, KNXInvalidResponseException, KNXRemoteException, InterruptedException {
        if (objectType < 0 || objectType > 65535 || objInstance < 0 || objInstance > 4095 || propertyId < 0 || propertyId > 4095 || service < 0 || service > 255) {
            throw new KNXIllegalArgumentException("argument value out of range");
        }
        ByteBuffer asdu = ByteBuffer.allocate(7 + info.length).putShort((short)objectType).put((byte)(objInstance >> 4)).put((byte)((objInstance & 0xF) << 4 | propertyId >> 8)).put((byte)propertyId).put((byte)0).put((byte)service).put(info);
        long startSend = this.send(dst, this.priority, DataUnitBuilder.createAPDU(cmd, asdu.array()), 470);
        List<byte[]> responses = this.waitForResponses(470, 6, 252, startSend, this.responseTimeout, (source, apdu) -> {
            if (source.equals(dst.getAddress())) {
                return ManagementClientImpl.extractFunctionPropertyExtData(objectType, objInstance, propertyId, apdu);
            }
            return Optional.empty();
        }, true);
        byte[] response = responses.get(0);
        ReturnCode returnCode = ReturnCode.of(response[0] & 0xFF);
        if (returnCode != ReturnCode.Success) {
            throw new KNXRemoteException(String.format("function property response for %d(%d)|%d service %d: %s", objectType, objInstance, propertyId, service, returnCode.description()));
        }
        return response;
    }

    private static Optional<byte[]> extractFunctionPropertyExtData(int objectType, int oinstance, int propertyId, byte[] apdu) {
        int receivedIot = (apdu[2] & 0xFF) << 8 | apdu[3] & 0xFF;
        int receivedOinst = (apdu[4] & 0xFF) << 4 | (apdu[5] & 0xF0) >> 4;
        int receivedPid = (apdu[5] & 0xF) << 8 | apdu[6] & 0xFF;
        return receivedIot == objectType && receivedOinst == oinstance && receivedPid == propertyId ? Optional.of(Arrays.copyOfRange(apdu, 7, apdu.length)) : Optional.empty();
    }

    @Override
    public int readADC(Destination dst, int channel, int repeat) throws KNXTimeoutException, KNXDisconnectException, KNXRemoteException, KNXLinkClosedException, InterruptedException {
        if (channel < 0 || channel > 63 || repeat < 0 || repeat > 255) {
            throw new KNXIllegalArgumentException("ADC arguments out of range");
        }
        if (!dst.isConnectionOriented()) {
            throw new KNXIllegalArgumentException("read ADC requires connection-oriented mode: " + dst);
        }
        byte[] apdu = this.sendWait(dst, this.priority, DataUnitBuilder.createLengthOptimizedAPDU(384, (byte)channel, (byte)repeat), 448, 3, 3);
        if (apdu[2] == 0) {
            throw new KNXRemoteException("error reading value of A/D converter");
        }
        return (apdu[3] & 0xFF) << 8 | apdu[4] & 0xFF;
    }

    @Override
    public byte[] readMemory(Destination dst, int startAddr, int bytes) throws KNXTimeoutException, KNXDisconnectException, KNXRemoteException, KNXLinkClosedException, InterruptedException {
        int maxStartAddress = 0xFFFFFF;
        int maxBytes = 248;
        if (startAddr < 0 || startAddr > 0xFFFFFF || bytes < 1 || bytes > 248) {
            throw new KNXIllegalArgumentException("argument value out of range");
        }
        if (!dst.isConnectionOriented()) {
            throw new KNXIllegalArgumentException("read memory requires connection-oriented mode: " + dst);
        }
        if (startAddr > 65535) {
            byte[] send = DataUnitBuilder.createAPDU(509, (byte)bytes, (byte)(startAddr >>> 16), (byte)(startAddr >>> 8), (byte)startAddr);
            byte[] apdu = this.sendWait(dst, this.priority, send, 510, 4, 252);
            ReturnCode ret = ReturnCode.of(apdu[2] & 0xFF);
            if (ret != ReturnCode.Success) {
                throw new KNXRemoteException(String.format("read memory from %s 0x%x: %s", dst.getAddress(), startAddr, ret.description()));
            }
            return Arrays.copyOfRange(apdu, 6, apdu.length);
        }
        byte[] apdu = this.sendWait(dst, this.priority, DataUnitBuilder.createLengthOptimizedAPDU(512, (byte)bytes, (byte)(startAddr >>> 8), (byte)startAddr), 576, 2, 65);
        int no = apdu[1] & 0x3F;
        if (no == 0) {
            throw new KNXRemoteException("could not read memory from 0x" + Integer.toHexString(startAddr));
        }
        byte[] mem = new byte[no];
        while (--no >= 0) {
            mem[no] = apdu[4 + no];
        }
        return mem;
    }

    @Override
    public void writeMemory(Destination dst, int startAddr, byte[] data) throws KNXDisconnectException, KNXTimeoutException, KNXRemoteException, KNXLinkClosedException, InterruptedException {
        int maxStartAddress = 0xFFFFFF;
        int maxBytes = 250;
        if (startAddr < 0 || startAddr > 0xFFFFFF || data.length == 0 || data.length > 250) {
            throw new KNXIllegalArgumentException("argument value out of range");
        }
        if (!dst.isConnectionOriented()) {
            throw new KNXIllegalArgumentException("write memory requires connection-oriented mode: " + dst);
        }
        if (startAddr > 65535) {
            byte[] addrBytes = new byte[]{(byte)(startAddr >>> 16), (byte)(startAddr >>> 8), (byte)startAddr};
            byte[] asdu = ByteBuffer.allocate(4 + data.length).put((byte)data.length).put(addrBytes).put(data).array();
            byte[] send = DataUnitBuilder.createAPDU(507, asdu);
            byte[] apdu = this.sendWait(dst, this.priority, send, 508, 4, 252);
            ReturnCode ret = ReturnCode.of(apdu[2] & 0xFF);
            if (ret == ReturnCode.Success) {
                return;
            }
            String desc = ret.description();
            if (ret == ReturnCode.SuccessWithCrc) {
                int crc = (apdu[6] & 0xFF) << 8 | apdu[7] & 0xFF;
                if (ManagementClientImpl.crc16Ccitt(asdu) == crc) {
                    return;
                }
                desc = "data verification failed (crc mismatch)";
            }
            throw new KNXRemoteException(String.format("write memory to %s 0x%x: %s", dst.getAddress(), startAddr, desc));
        }
        byte[] asdu = new byte[data.length + 3];
        asdu[0] = (byte)data.length;
        asdu[1] = (byte)(startAddr >> 8);
        asdu[2] = (byte)startAddr;
        for (int i = 0; i < data.length; ++i) {
            asdu[3 + i] = data[i];
        }
        byte[] send = DataUnitBuilder.createLengthOptimizedAPDU(640, asdu);
        if (dst.isVerifyMode()) {
            byte[] apdu = this.sendWait(dst, this.priority, send, 576, 2, 65);
            if ((apdu[1] & 0x3F) == 0) {
                throw new KNXRemoteException("remote app. could not write memory");
            }
            if (apdu.length - 4 != data.length) {
                throw new KNXInvalidResponseException("number of memory bytes differ");
            }
            for (int i = 4; i < apdu.length; ++i) {
                if (apdu[i] == asdu[i - 1]) continue;
                throw new KNXRemoteException("verify failed (erroneous memory data)");
            }
        } else {
            this.tl.sendData(dst, this.priority, send);
        }
    }

    static int crc16Ccitt(byte[] input) {
        int polynom = 4129;
        byte[] padded = Arrays.copyOf(input, input.length + 2);
        int result = 65535;
        for (int i = 0; i < 8 * padded.length; ++i) {
            result <<= 1;
            int nextBit = padded[i / 8] >> 7 - i % 8 & 1;
            if (((result |= nextBit) & 0x10000) == 0) continue;
            result ^= 0x1021;
        }
        return result & 0xFFFF;
    }

    @Override
    public int authorize(Destination dst, byte[] key) throws KNXDisconnectException, KNXTimeoutException, KNXRemoteException, KNXLinkClosedException, InterruptedException {
        if (key.length != 4) {
            throw new KNXIllegalArgumentException("length of authorize key not 4 bytes");
        }
        if (!dst.isConnectionOriented()) {
            throw new KNXIllegalArgumentException("authorize requires connection-oriented mode: " + dst);
        }
        byte[] asdu = new byte[]{0, key[0], key[1], key[2], key[3]};
        byte[] apdu = this.sendWait(dst, this.priority, DataUnitBuilder.createAPDU(977, asdu), 978, 1, 1);
        int level = apdu[2] & 0xFF;
        if (level > 15) {
            throw new KNXInvalidResponseException("authorization level out of range [0..15]");
        }
        return level;
    }

    @Override
    public void writeKey(Destination dst, int level, byte[] key) throws KNXTimeoutException, KNXDisconnectException, KNXRemoteException, KNXLinkClosedException, InterruptedException {
        if (level < 0 || level > 254 || key.length != 4) {
            throw new KNXIllegalArgumentException("level out of range or key length not 4 bytes");
        }
        if (!dst.isConnectionOriented()) {
            throw new KNXIllegalArgumentException("write key requires connection-oriented mode: " + dst);
        }
        byte[] apdu = this.sendWait(dst, this.priority, DataUnitBuilder.createAPDU(979, (byte)level, key[0], key[1], key[2], key[3]), 980, 1, 1);
        if ((apdu[1] & 0xFF) == 255) {
            throw new KNXRemoteException("access denied: current access level > write level");
        }
    }

    @Override
    public boolean isOpen() {
        return !this.detached;
    }

    @Override
    public KNXNetworkLink detach() {
        KNXNetworkLink lnk;
        this.tl.removeTransportListener(this.tlListener);
        KNXNetworkLink kNXNetworkLink = lnk = this.detachTransportLayer ? this.tl.detach() : null;
        if (lnk != null) {
            this.logger.debug("detached from {}", (Object)lnk);
        }
        this.listeners.removeAll();
        this.sal.close();
        this.detached = true;
        return lnk;
    }

    private int maxApduLength(Destination dst) throws KNXLinkClosedException, InterruptedException {
        Optional<Integer> max = dst.maxApduLength();
        if (max.isPresent()) {
            return max.get();
        }
        KNXNetworkLink link = ((TransportLayerImpl)this.tl).link();
        int maxLinkApdu = link.getKNXMedium().maxApduLength();
        int maxDeviceApdu = 15;
        dst.maxApduLength(maxDeviceApdu);
        if (maxLinkApdu > maxDeviceApdu) {
            try {
                byte[] data = this.readProperty(dst, 0, 56, 1, 1);
                maxDeviceApdu = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
                dst.maxApduLength(Math.min(maxLinkApdu, maxDeviceApdu));
            }
            catch (KNXRemoteException | KNXTimeoutException | KNXDisconnectException e) {
                this.logger.debug("use max. APDU length of 15 bytes for {}", (Object)dst.getAddress());
            }
        }
        return dst.maxApduLength().get();
    }

    private int maxAsduLength(Destination dst) throws KNXLinkClosedException, InterruptedException {
        return this.maxApduLength(dst) - 1;
    }

    private long registerActiveService(int serviceType) {
        long now = System.nanoTime();
        this.activeServiceResponses.merge(serviceType, now + this.responseTimeout.toNanos(), (oldValue, value) -> oldValue < value ? value : oldValue);
        return now;
    }

    private boolean isActiveService(int serviceType, long timestamp) {
        return this.activeServiceResponses.computeIfPresent(serviceType, (__, activeUntil) -> activeUntil < timestamp ? null : activeUntil) != null;
    }

    private boolean isActiveService(FrameEvent e) {
        return this.isActiveService(DataUnitBuilder.getAPDUService(e.getFrame().getPayload()), e.id());
    }

    private long send(Destination d, Priority p, byte[] apdu, int response) throws KNXTimeoutException, KNXDisconnectException, KNXLinkClosedException, InterruptedException {
        return this.send(d, p, apdu, response, null);
    }

    private long send(Destination d, Priority p, byte[] apdu, int response, byte[] updateToolKey) throws KNXTimeoutException, KNXDisconnectException, KNXLinkClosedException, InterruptedException {
        long start = this.registerActiveService(response);
        SecurityControl secCtrl = SecurityControl.of(SecurityControl.DataSecurity.AuthConf, true);
        byte[] sapdu = this.sal.secureData(this.src, d.getAddress(), apdu, secCtrl).orElse(apdu);
        if (updateToolKey != null) {
            this.sal.security().deviceToolKeys().put(d.getAddress(), updateToolKey);
            this.logger.info("update device toolkey for {}", (Object)d.getAddress());
        }
        if (d.isConnectionOriented()) {
            this.tl.sendData(d, p, sapdu);
        } else {
            this.tl.sendData(d.getAddress(), p, sapdu);
        }
        return start;
    }

    private byte[] sendWait(Destination d, Priority p, byte[] apdu, int response, int minAsduLen, int maxAsduLen) throws KNXDisconnectException, KNXTimeoutException, KNXInvalidResponseException, KNXLinkClosedException, InterruptedException {
        long start = this.send(d, p, apdu, response);
        return this.waitForResponse(d.getAddress(), response, minAsduLen, maxAsduLen, start, this.responseTimeout);
    }

    private byte[] sendWait2(Destination d, Priority p, byte[] apdu, int response, int minAsduLen, int maxAsduLen) throws KNXDisconnectException, KNXTimeoutException, KNXInvalidResponseException, KNXLinkClosedException, InterruptedException {
        long start = this.send(d, p, apdu, response);
        return this.waitForResponse(d.getAddress(), response, minAsduLen, maxAsduLen, start, this.responseTimeout);
    }

    private byte[] waitForResponse(IndividualAddress from, int serviceType, int minAsduLen, int maxAsduLen, long start, Duration timeout) throws KNXInvalidResponseException, KNXTimeoutException, InterruptedException {
        return this.waitForResponses(serviceType, minAsduLen, maxAsduLen, start, timeout, (source, apdu) -> source.equals(from) ? Optional.of(apdu) : Optional.empty(), true).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<byte[]> waitForResponses(int serviceType, int minAsduLen, int maxAsduLen, long start, Duration timeout, BiFunction<IndividualAddress, byte[], Optional<byte[]>> responseFilter, boolean oneOnly) throws KNXInvalidResponseException, KNXTimeoutException, InterruptedException {
        long remaining = timeout.toMillis();
        long end = start / 1000000L + remaining;
        ArrayList<byte[]> responses = new ArrayList<byte[]>();
        Deque<FrameEvent> deque = this.indications;
        synchronized (deque) {
            while (remaining > 0L) {
                Iterator<FrameEvent> i = this.indications.iterator();
                while (i.hasNext()) {
                    CEMI frame;
                    byte[] apdu;
                    FrameEvent event = i.next();
                    if (start > event.id() + this.responseTimeout.toNanos()) {
                        i.remove();
                        continue;
                    }
                    if (start > event.id() || serviceType != DataUnitBuilder.getAPDUService(apdu = (frame = event.getFrame()).getPayload())) continue;
                    IndividualAddress source = ((CEMILData)frame).getSource();
                    if (apdu.length < minAsduLen + 2 || apdu.length > maxAsduLen + 2) {
                        String s = "invalid ASDU response length " + (apdu.length - 2) + " bytes, expected " + minAsduLen + " to " + maxAsduLen;
                        this.logger.warn("received response from " + source + " with " + s);
                        if (oneOnly) {
                            throw new KNXInvalidResponseException(s);
                        }
                    }
                    responseFilter.apply(source, apdu).ifPresent(response -> {
                        responses.add((byte[])response);
                        i.remove();
                    });
                    if (responses.isEmpty() || !oneOnly) continue;
                    return responses;
                }
                this.indications.wait(remaining);
                remaining = end - System.nanoTime() / 1000000L;
            }
        }
        if (responses.isEmpty()) {
            throw new KNXTimeoutException("timeout waiting for data response");
        }
        return responses;
    }

    private List<byte[]> readBroadcast(Priority p, byte[] apdu, int response, int minAsduLen, int maxAsduLen, boolean oneOnly) throws KNXLinkClosedException, KNXInvalidResponseException, KNXTimeoutException, InterruptedException {
        long start = this.registerActiveService(response);
        this.tl.broadcast(true, p, apdu);
        return this.waitForResponses(response, minAsduLen, maxAsduLen, start, this.responseTimeout, (source, apdu1) -> Optional.of(apdu1), oneOnly);
    }

    private static List<byte[]> makeDOAs(List<byte[]> l) {
        for (int i = 0; i < l.size(); ++i) {
            byte[] pdu = l.get(i);
            l.set(i, Arrays.copyOfRange(pdu, 2, pdu.length));
        }
        return l;
    }

    private static byte[] extractPropertyElements(byte[] apdu, int objIndex, int propertyId, int elements) throws KNXRemoteException {
        int oi = apdu[2] & 0xFF;
        int pid = apdu[3] & 0xFF;
        if (oi != objIndex || pid != propertyId) {
            throw new KNXInvalidResponseException(String.format("property response mismatch, expected OI %d PID %d (received %d|%d)", objIndex, propertyId, oi, pid));
        }
        int number = (apdu[4] & 0xFF) >>> 4;
        if (number == 0) {
            throw new KNXRemoteException("property access OI " + oi + " PID " + pid + " failed/forbidden");
        }
        if (number != elements) {
            throw new KNXInvalidResponseException(String.format("property access OI %d PID %d expected %d elements (received %d)", oi, pid, elements, number));
        }
        byte[] prop = new byte[apdu.length - 6];
        for (int i = 0; i < prop.length; ++i) {
            prop[i] = apdu[i + 6];
        }
        return prop;
    }

    private class TLListener
    implements TransportListener {
        TLListener() {
        }

        @Override
        public void broadcast(FrameEvent e) {
            this.checkResponse(e);
        }

        @Override
        public void dataConnected(FrameEvent e) {
            this.checkResponse(e);
        }

        @Override
        public void dataIndividual(FrameEvent e) {
            this.checkResponse(e);
        }

        @Override
        public void disconnected(Destination d) {
        }

        @Override
        public void group(FrameEvent e) {
        }

        @Override
        public void detached(DetachEvent e) {
        }

        @Override
        public void linkClosed(CloseEvent e) {
            ManagementClientImpl.this.logger.debug("attached link was closed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkResponse(FrameEvent e) {
            CEMILData ldata = (CEMILData)e.getFrame();
            try {
                if (ManagementClientImpl.this.isActiveService(e)) {
                    Deque<FrameEvent> deque = ManagementClientImpl.this.indications;
                    synchronized (deque) {
                        ManagementClientImpl.this.indications.add(e);
                        ManagementClientImpl.this.indications.notifyAll();
                    }
                }
                ManagementClientImpl.this.listeners.fire(c -> c.accept(e));
            }
            catch (RuntimeException rte) {
                ManagementClientImpl.this.logger.warn("on indication from {}", (Object)ldata.getDestination(), (Object)rte);
            }
        }
    }
}

