/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.mgmt;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.link.KNXLinkClosedException;

public interface ManagementProcedures
extends AutoCloseable {
    public IndividualAddress[] readAddress() throws KNXException, InterruptedException;

    public IndividualAddress readAddress(SerialNumber var1) throws KNXException, InterruptedException;

    default public IndividualAddress readAddress(byte[] serialNo) throws KNXException, InterruptedException {
        return this.readAddress(SerialNumber.from(serialNo));
    }

    public boolean writeAddress(IndividualAddress var1) throws KNXException, InterruptedException;

    public boolean writeAddress(SerialNumber var1, IndividualAddress var2) throws KNXException, InterruptedException;

    default public boolean writeAddress(byte[] serialNo, IndividualAddress newAddress) throws KNXException, InterruptedException {
        return this.writeAddress(SerialNumber.from(serialNo), newAddress);
    }

    public void resetAddress() throws KNXException, InterruptedException;

    public boolean isAddressOccupied(IndividualAddress var1) throws KNXException, InterruptedException;

    public void readDomainAddress(BiConsumer<IndividualAddress, byte[]> var1) throws KNXException, InterruptedException;

    public IndividualAddress[] scanNetworkRouters() throws KNXTimeoutException, KNXLinkClosedException, InterruptedException;

    public IndividualAddress[] scanNetworkDevices(int var1, int var2) throws KNXTimeoutException, KNXLinkClosedException, InterruptedException;

    default public void scanNetworkDevices(int area, int line, Consumer<IndividualAddress> device) throws KNXLinkClosedException, InterruptedException {
        this.scanNetworkDevices(area, line, device, (__, ___) -> {});
    }

    public void scanNetworkDevices(int var1, int var2, Consumer<IndividualAddress> var3, BiConsumer<IndividualAddress, DeviceDescriptor.DD0> var4) throws KNXLinkClosedException, InterruptedException;

    public List<byte[]> scanSerialNumbers(int var1) throws KNXException, InterruptedException;

    public void setProgrammingMode(IndividualAddress var1, boolean var2) throws KNXException, InterruptedException;

    public void writeMemory(IndividualAddress var1, long var2, byte[] var4, boolean var5, boolean var6) throws KNXException, InterruptedException;

    public byte[] readMemory(IndividualAddress var1, long var2, int var4) throws KNXException, InterruptedException;

    public void detach();

    @Override
    default public void close() {
        this.detach();
    }
}

