/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.mgmt;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DetachEvent;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXRemoteException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.KNXDisconnectException;
import tuwien.auto.calimero.mgmt.ManagementClient;
import tuwien.auto.calimero.mgmt.ManagementClientImpl;
import tuwien.auto.calimero.mgmt.ManagementProcedures;
import tuwien.auto.calimero.mgmt.SecureManagement;
import tuwien.auto.calimero.mgmt.TransportLayer;
import tuwien.auto.calimero.mgmt.TransportLayerImpl;
import tuwien.auto.calimero.mgmt.TransportListener;
import tuwien.auto.calimero.secure.SecureApplicationLayer;

public class ManagementProceduresImpl
implements ManagementProcedures {
    private static final int DEVICE_OBJECT_INDEX = 0;
    private static final int DEVICE_DESC_READ = 768;
    private static final int DEVICE_DESC_RESPONSE = 832;
    private static final int memAddrProgMode = 96;
    private static final int defaultApduLength = 15;
    private static final int disconnectTimeout = 6000;
    private final ManagementClient mc;
    private final TransportLayer tl;
    private final boolean detachMgmtAndTransportLayer;
    private static final Logger logger = LogService.getLogger("calimero.mgmt.MgmtProc");
    private static final int routerObjectType = 6;
    private static final int pidIpSbcControl = 120;

    public ManagementProceduresImpl(KNXNetworkLink link) throws KNXLinkClosedException {
        this.tl = new TransportLayerImpl(link);
        this.mc = new ManagementClientImpl(link, this.tl);
        this.detachMgmtAndTransportLayer = true;
    }

    protected ManagementProceduresImpl(ManagementClient mgmtClient, TransportLayer transportLayer) {
        this.mc = mgmtClient;
        if (!this.mc.isOpen()) {
            throw new IllegalStateException("management client not in open state");
        }
        this.tl = transportLayer;
        this.detachMgmtAndTransportLayer = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndividualAddress[] readAddress() throws KNXException, InterruptedException {
        ManagementClient managementClient = this.mc;
        synchronized (managementClient) {
            IndividualAddress[] individualAddressArray;
            Duration oldTimeout = this.mc.responseTimeout();
            this.mc.responseTimeout(Duration.ofSeconds(3L));
            try {
                individualAddressArray = this.mc.readAddress(false);
                this.mc.responseTimeout(oldTimeout);
            }
            catch (KNXTimeoutException e) {
                IndividualAddress[] individualAddressArray2;
                try {
                    individualAddressArray2 = new IndividualAddress[]{};
                    this.mc.responseTimeout(oldTimeout);
                }
                catch (Throwable throwable) {
                    this.mc.responseTimeout(oldTimeout);
                    throw throwable;
                }
                return individualAddressArray2;
            }
            return individualAddressArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDomainAddress(BiConsumer<IndividualAddress, byte[]> device) throws KNXException, InterruptedException {
        ManagementClient managementClient = this.mc;
        synchronized (managementClient) {
            Duration oldTimeout = this.mc.responseTimeout();
            this.mc.responseTimeout(Duration.ofSeconds(3L));
            try {
                this.mc.readDomainAddress(device);
            }
            catch (KNXTimeoutException kNXTimeoutException) {
            }
            finally {
                this.mc.responseTimeout(oldTimeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDomainAddress(SerialNumber serialNumber, byte[] domainAddress, List<IndividualAddress> knxipRouters) throws KNXException, InterruptedException {
        ArrayList<Destination> ipSbcEnabled = new ArrayList<Destination>();
        for (IndividualAddress router : knxipRouters) {
            Destination dst = this.getOrCreateDestination(router);
            try {
                this.mc.callFunctionProperty(dst, 6, 1, 120, 0, 1);
                ipSbcEnabled.add(dst);
            }
            catch (KNXRemoteException | KNXDisconnectException e) {
                logger.warn("failed to enable IP system broadcast on {}, {}", (Object)router, (Object)e.getMessage());
            }
        }
        try {
            for (int i = 0; i < 2; ++i) {
                this.mc.writeDomainAddress(serialNumber, domainAddress);
                Thread.sleep(1000L);
                if (domainAddress.length == 4 || domainAddress.length == 21) {
                    int maxRoutingTimerSync = 25700;
                    Thread.sleep(25700L);
                }
                try {
                    this.mc.readAddress(serialNumber);
                    break;
                }
                catch (KNXTimeoutException e) {
                    Thread.sleep(1000L);
                    continue;
                }
            }
        }
        catch (Throwable throwable) {
            for (Destination dst : ipSbcEnabled) {
                try {
                    this.mc.callFunctionProperty(dst, 6, 1, 120, 0, 0);
                }
                catch (KNXRemoteException | KNXDisconnectException kNXException) {}
            }
            throw throwable;
        }
        for (Destination dst : ipSbcEnabled) {
            try {
                this.mc.callFunctionProperty(dst, 6, 1, 120, 0, 0);
            }
            catch (KNXRemoteException | KNXDisconnectException kNXException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean writeAddress(IndividualAddress newAddress) throws KNXException, InterruptedException {
        boolean exists = false;
        try (Destination dst2 = this.getOrCreateDestination(newAddress);){
            this.mc.readDeviceDesc(dst2, 0);
            exists = true;
        }
        catch (KNXDisconnectException dst2) {
        }
        catch (KNXTimeoutException dst2) {
            // empty catch block
        }
        boolean setAddr = false;
        ManagementClient managementClient = this.mc;
        synchronized (managementClient) {
            Duration oldTimeout = this.mc.responseTimeout();
            try {
                Destination verify = this.mc.createDestination(newAddress, true);
                try {
                    this.mc.responseTimeout(Duration.ofSeconds(1L));
                    int attempts = 20;
                    int count = 0;
                    while (count != 1 && attempts-- > 0) {
                        block31: {
                            try {
                                IndividualAddress[] list = this.mc.readAddress(false);
                                count = list.length;
                                if (count == 1 && !list[0].equals(newAddress)) {
                                    setAddr = true;
                                }
                            }
                            catch (KNXException e) {
                                if (!exists) break block31;
                                logger.warn("device exists but is not in programming mode, cancel writing address");
                                boolean bl = false;
                                if (verify != null) {
                                    verify.close();
                                }
                                this.mc.responseTimeout(oldTimeout);
                                return bl;
                            }
                        }
                        logger.info("KNX devices in programming mode: " + count);
                    }
                    if (!setAddr) {
                        boolean bl = false;
                        return bl;
                    }
                    this.mc.writeAddress(newAddress);
                    this.mc.readDeviceDesc(verify, 0);
                    this.mc.restart(verify);
                }
                finally {
                    if (verify != null) {
                        try {
                            verify.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            finally {
                this.mc.responseTimeout(oldTimeout);
            }
            return true;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void resetAddress() throws KNXException, InterruptedException {
        def = new IndividualAddress(65535);
        dst = this.mc.createDestination(def, true);
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                this.mc.writeAddress(def);
                this.mc.restart(dst);
                try {
                    this.mc.readAddress(true);
                    continue;
                }
                catch (KNXTimeoutException e) {
                    if (dst != null) {
                        dst.close();
                    }
                }
                break;
            }
        }
        catch (Throwable var3_4) {
            if (dst != null) {
                try {
                    dst.close();
                }
                catch (Throwable var4_5) {
                    var3_4.addSuppressed(var4_5);
                }
            }
            throw var3_4;
        }
        {
            ** while (true)
        }
    }

    @Override
    public boolean isAddressOccupied(IndividualAddress devAddr) throws KNXException, InterruptedException {
        block9: {
            try (Destination dst = this.mc.createDestination(devAddr, true);){
                this.mc.readDeviceDesc(dst, 0);
            }
            catch (KNXTimeoutException e) {
                return false;
            }
            catch (KNXDisconnectException e) {
                if (e.getDestination().getDisconnectedBy() == 1) break block9;
                return false;
            }
        }
        return true;
    }

    @Override
    public IndividualAddress readAddress(SerialNumber serialNo) throws KNXException, InterruptedException {
        return this.mc.readAddress(serialNo);
    }

    @Override
    public boolean writeAddress(SerialNumber serialNo, IndividualAddress newAddress) throws KNXException, InterruptedException {
        this.mc.writeAddress(serialNo, newAddress);
        IndividualAddress chk = this.mc.readAddress(serialNo);
        boolean equals = chk.equals(newAddress);
        if (!equals) {
            logger.warn("write device address {}/{} reported back {}", new Object[]{serialNo, newAddress, chk});
        }
        return equals;
    }

    @Override
    public IndividualAddress[] scanNetworkRouters() throws KNXTimeoutException, KNXLinkClosedException, InterruptedException {
        ArrayList<IndividualAddress> addresses = new ArrayList<IndividualAddress>();
        for (int address = 0; address <= 65280; address += 256) {
            addresses.add(new IndividualAddress(address));
        }
        return this.scanAddresses(addresses, true);
    }

    @Override
    public IndividualAddress[] scanNetworkDevices(int area, int line) throws KNXTimeoutException, KNXLinkClosedException, InterruptedException {
        if (area < 0 || area > 15) {
            throw new KNXIllegalArgumentException("area out of range [0..0xf]");
        }
        if (line < 0 || line > 15) {
            throw new KNXIllegalArgumentException("line out of range [0..0xf]");
        }
        ArrayList<IndividualAddress> addresses = new ArrayList<IndividualAddress>();
        for (int device = 0; device <= 255; ++device) {
            IndividualAddress remote = new IndividualAddress(area, line, device);
            addresses.add(remote);
        }
        return this.scanAddresses(addresses, false);
    }

    @Override
    public void scanNetworkDevices(int area, int line, Consumer<IndividualAddress> device, BiConsumer<IndividualAddress, DeviceDescriptor.DD0> deviceWithDescriptor) throws KNXLinkClosedException, InterruptedException {
        if (area < 0 || area > 15) {
            throw new KNXIllegalArgumentException("area out of range [0..0xf]");
        }
        if (line < 0 || line > 15) {
            throw new KNXIllegalArgumentException("line out of range [0..0xf]");
        }
        List<IndividualAddress> addresses = IntStream.rangeClosed(0, 255).mapToObj(i -> new IndividualAddress(area, line, i)).collect(Collectors.toList());
        this.scanAddresses(addresses, false, device, deviceWithDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public List<byte[]> scanSerialNumbers(int medium) throws KNXException, InterruptedException {
        ManagementClient managementClient = this.mc;
        synchronized (managementClient) {
            Duration oldTimeout = this.mc.responseTimeout();
            Destination dst = this.mc.createDestination(new IndividualAddress(0, medium, 255), true);
            this.mc.responseTimeout(Duration.ofSeconds(7L));
            List<byte[]> list = ((ManagementClientImpl)this.mc).readProperty(dst, 0, 11, 1, 1, false);
            if (dst != null) {
                dst.close();
            }
            this.mc.responseTimeout(oldTimeout);
            return list;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            if (dst != null) {
                                try {
                                    dst.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (KNXTimeoutException kNXTimeoutException) {
                            this.mc.responseTimeout(oldTimeout);
                        }
                    }
                    catch (Throwable throwable3) {
                        this.mc.responseTimeout(oldTimeout);
                        throw throwable3;
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setProgrammingMode(IndividualAddress device, boolean programming) throws KNXException, InterruptedException {
        Destination d = this.getOrCreateDestination(device);
        try {
            this.mc.writeProperty(d, 0, 54, 1, 1, new byte[]{(byte)(programming ? 1 : 0)});
            return;
        }
        catch (KNXException e) {
            logger.warn("setting programming mode via property failed, (" + e + "), trying via memory");
            byte[] mem = this.mc.readMemory(d, 96, 1);
            int set = mem[0] & 0x7F;
            set = programming ? set | 1 : set & 0xFE;
            set = ManagementProceduresImpl.isOddParity(set) ? set | 0x80 : set;
            mem[0] = (byte)set;
            this.mc.writeMemory(d, 96, mem);
            return;
        }
    }

    @Override
    public void writeMemory(IndividualAddress device, long startAddress, byte[] data, boolean verifyWrite, boolean verifyByServer) throws KNXException, InterruptedException {
        if (startAddress < 0L || startAddress > 0xFFFFFFFFL) {
            throw new KNXIllegalArgumentException("start address is no 32 Bit address");
        }
        if (verifyWrite && verifyByServer) {
            throw new KNXIllegalArgumentException("verify write and verify by server not both applicable");
        }
        Destination d = this.getOrCreateDestination(device, false, verifyByServer);
        if (verifyByServer) {
            this.mc.readPropertyDesc(d, 0, 14, 0);
            byte[] ctrl = this.mc.readProperty(d, 0, 14, 1, 1);
            ctrl[0] = (byte)(ctrl[0] | 4);
            this.mc.writeProperty(d, 0, 14, 1, 1, ctrl);
        }
        boolean dataBlockStartAddress = false;
        int flags = 1;
        int n = verifyWrite ? 2 : 0;
        long endAddress = startAddress + (long)data.length;
        int offset = 14;
        byte[] write = new byte[14 + data.length];
        write[0] = 32;
        write[1] = (byte)(flags |= n);
        ManagementProceduresImpl.setAddress(write, 2, 0L);
        ManagementProceduresImpl.setAddress(write, 6, startAddress);
        ManagementProceduresImpl.setAddress(write, 10, endAddress);
        for (int i = 0; i < data.length; ++i) {
            write[14 + i] = data[i];
        }
        int asduLength = this.readMaxAsduLength(d);
        for (int i = 0; i < write.length; i += asduLength) {
            byte[] read;
            byte[] range = Arrays.copyOfRange(write, i, i + asduLength);
            this.mc.writeMemory(d, (int)startAddress + i, range);
            if (!verifyWrite || Arrays.equals(read = this.mc.readMemory(d, (int)startAddress + i, range.length), range)) continue;
            throw new KNXRemoteException("verify failed (memory data differs)");
        }
    }

    @Override
    public byte[] readMemory(IndividualAddress device, long startAddress, int bytes) throws KNXException, InterruptedException {
        if (startAddress < 0L || startAddress > 0xFFFFFFFFL) {
            throw new KNXIllegalArgumentException("start address is no 32 Bit address");
        }
        if (bytes < 0) {
            throw new KNXIllegalArgumentException("bytes to read require a positive number");
        }
        Destination d = this.getOrCreateDestination(device);
        byte[] read = new byte[bytes];
        int asduLength = this.readMaxAsduLength(d);
        for (int i = 0; i < read.length; i += asduLength) {
            int size = i + asduLength <= read.length ? asduLength : read.length - i;
            byte[] range = this.mc.readMemory(d, (int)startAddress + i, size);
            System.arraycopy(range, 0, read, i, range.length);
        }
        return read;
    }

    public void assignDomainAndDeviceAddress(byte[] domainAddress, IndividualAddress deviceAddress, byte[] fdsk, byte[] toolKey, Duration maxLookup) throws KNXException, InterruptedException {
        boolean openMedium;
        Instant deadline = Instant.now().plus(maxLookup);
        List<Object> list = List.of();
        while (Instant.now().isBefore(deadline) && list.isEmpty()) {
            list = this.mc.readSystemNetworkParameter(0, 11, 1, new byte[0]);
        }
        if (list.size() != 1) {
            throw new KNXRemoteException((Serializable)(list.isEmpty() ? "no" : Integer.valueOf(list.size())) + " devices in programming mode");
        }
        SerialNumber sno = SerialNumber.from((byte[])list.get(0));
        int medium = ((TransportLayerImpl)this.tl).link().getKNXMedium().getMedium();
        boolean sysBcast = openMedium = medium == 4 || medium == 16;
        SecureManagement sal = ((ManagementClientImpl)this.mc).secureApplicationLayer();
        Object[] result = this.broadacstSync(sal, sysBcast, sno, fdsk, toolKey);
        boolean usesFdsk = (Boolean)result[0];
        AutoCloseable removeableKey = (AutoCloseable)result[1];
        if (openMedium) {
            this.writeDomainAddress(sno, domainAddress, List.of());
        }
        this.writeAddress(sno, deviceAddress);
        try {
            removeableKey.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        sal.security().deviceToolKeys().put(deviceAddress, usesFdsk ? fdsk : toolKey);
        Destination dst = this.getOrCreateDestination(deviceAddress);
        int pidSecurityMode = 51;
        int securityObjectType = 17;
        this.mc.callFunctionProperty(dst, 17, 1, 51, 0, 1);
        if (usesFdsk) {
            int pidToolKey = 56;
            this.mc.writeProperty(dst, 17, 1, 56, 1, 1, toolKey);
        }
        this.mc.restart(dst, ManagementClient.EraseCode.ConfirmedRestart, 0);
    }

    private Object[] broadacstSync(SecureApplicationLayer sal, boolean systemBroadcast, SerialNumber serialNo, byte[] fdsk, byte[] toolKey) throws KNXException, InterruptedException {
        String errMsg;
        block6: {
            errMsg = String.format("sync.req with device S/N %s failed", serialNo);
            boolean toolAccess = true;
            if (fdsk.length != 0) {
                try {
                    CompletableFuture<AutoCloseable> request = sal.broadcastSyncRequest(serialNo, fdsk, true, systemBroadcast);
                    AutoCloseable broadcastKey = request.get();
                    return new Object[]{true, broadcastKey};
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof TimeoutException) break block6;
                    throw new KNXException(errMsg + ", device not using FDSK", e.getCause());
                }
            }
        }
        try {
            CompletableFuture<AutoCloseable> request = sal.broadcastSyncRequest(serialNo, toolKey, true, systemBroadcast);
            AutoCloseable broadcastKey = request.get();
            return new Object[]{false, broadcastKey};
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TimeoutException) {
                throw new KNXTimeoutException(errMsg + ", device with unknown key or in ex-factory state");
            }
            throw new KNXException(errMsg, e.getCause());
        }
    }

    @Override
    public void detach() {
        if (this.detachMgmtAndTransportLayer) {
            this.mc.detach();
            this.tl.detach();
        }
    }

    private Destination getOrCreateDestination(IndividualAddress device) {
        return this.getOrCreateDestination(device, false, false);
    }

    private Destination getOrCreateDestination(IndividualAddress device, boolean keepAlive, boolean verifyByServer) {
        Destination d = ((TransportLayerImpl)this.tl).getDestination(device);
        return d != null ? d : this.tl.createDestination(device, true, keepAlive, verifyByServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndividualAddress[] scanAddresses(List<IndividualAddress> addresses, boolean routers) throws KNXTimeoutException, KNXLinkClosedException, InterruptedException {
        HashSet<IndividualAddress> devices = new HashSet<IndividualAddress>();
        TLListener tll = new TLListener(devices, routers);
        this.tl.addTransportListener(tll);
        ArrayList<Destination> destinations = new ArrayList<Destination>();
        try {
            for (IndividualAddress remote : addresses) {
                Destination d = this.getOrCreateDestination(remote, true, false);
                destinations.add(d);
                this.tl.connect(d);
                ManagementProceduresImpl.waitFor(115);
            }
            ManagementProceduresImpl.waitFor(7100);
        }
        finally {
            this.tl.removeTransportListener(tll);
            for (Destination d : destinations) {
                this.tl.destroyDestination(d);
            }
        }
        IndividualAddress[] array = devices.toArray(new IndividualAddress[devices.size()]);
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanAddresses(List<IndividualAddress> addresses, boolean routers, Consumer<IndividualAddress> response, BiConsumer<IndividualAddress, DeviceDescriptor.DD0> deviceWithDescriptor) throws KNXLinkClosedException, InterruptedException {
        ConcurrentHashMap<IndividualAddress, Destination> connected = new ConcurrentHashMap<IndividualAddress, Destination>();
        ConcurrentLinkedQueue disconnectedByRemote = new ConcurrentLinkedQueue();
        Consumer<IndividualAddress> onDisconnect = remote -> {
            if (connected.remove(remote) != null) {
                disconnectedByRemote.add(remote);
                response.accept((IndividualAddress)remote);
            }
        };
        ConcurrentHashMap<IndividualAddress, Destination> dd0Requests = new ConcurrentHashMap<IndividualAddress, Destination>();
        BiConsumer<IndividualAddress, DeviceDescriptor.DD0> onDD0 = (remote, dd0) -> {
            Destination dst = (Destination)dd0Requests.remove(remote);
            if (dst != null) {
                dst.close();
                deviceWithDescriptor.accept((IndividualAddress)remote, (DeviceDescriptor.DD0)dd0);
            }
        };
        TLListener tll = new TLListener(onDisconnect, onDD0, routers);
        this.tl.addTransportListener(tll);
        try {
            for (IndividualAddress address : addresses) {
                Destination d = this.getOrCreateDestination(address, true, false);
                connected.put(address, d);
                try {
                    this.tl.connect(d);
                }
                catch (KNXTimeoutException e) {
                    logger.info("connect timeout during address scan for {}", (Object)d);
                }
                ManagementProceduresImpl.waitFor(115);
                while (!disconnectedByRemote.isEmpty()) {
                    IndividualAddress ia = (IndividualAddress)disconnectedByRemote.remove();
                    Destination dd0Req = this.getOrCreateDestination(ia);
                    dd0Requests.put(ia, dd0Req);
                    this.sendDD0Read(dd0Req);
                }
            }
            ManagementProceduresImpl.waitFor(7100);
        }
        finally {
            this.tl.removeTransportListener(tll);
            connected.values().forEach(Destination::destroy);
        }
    }

    private void sendDD0Read(Destination dst) throws KNXLinkClosedException {
        byte[] apdu = DataUnitBuilder.createLengthOptimizedAPDU(768, 0);
        try {
            this.tl.sendData(dst, Priority.LOW, apdu);
        }
        catch (KNXDisconnectException kNXDisconnectException) {
            // empty catch block
        }
    }

    private int readMaxAsduLength(Destination d) throws InterruptedException {
        try {
            byte[] data = this.mc.readProperty(d, 0, 56, 1, 1);
            return ManagementProceduresImpl.toUnsigned(data) - 3;
        }
        catch (KNXException e) {
            return 12;
        }
    }

    private static void waitFor(int ms) throws InterruptedException {
        Thread.sleep(ms);
    }

    private static int toUnsigned(byte[] data) {
        return (data[0] & 0xFF) << 8 | data[1] & 0xFF;
    }

    private static boolean isOddParity(int bite) {
        int parity = bite ^ bite >> 4;
        parity ^= parity >> 2;
        return ((parity ^= parity >> 1) & 1) != 0;
    }

    private static void setAddress(byte[] data, int from, long address) {
        for (int i = 0; i < 4; ++i) {
            data[from + i] = (byte)(address >> 3 - i & 0xFFL);
        }
    }

    private static final class TLListener
    implements TransportListener {
        private final Set<IndividualAddress> devices;
        private final Consumer<IndividualAddress> disconnect;
        private final BiConsumer<IndividualAddress, DeviceDescriptor.DD0> dd0;
        private final boolean routers;

        private TLListener(Set<IndividualAddress> scanResult, boolean scanRouters) {
            this.devices = scanResult;
            this.disconnect = null;
            this.dd0 = (__, ___) -> {};
            this.routers = scanRouters;
        }

        private TLListener(Consumer<IndividualAddress> onDisconnect, BiConsumer<IndividualAddress, DeviceDescriptor.DD0> onDD0, boolean scanRouters) {
            this.disconnect = onDisconnect;
            this.dd0 = onDD0;
            this.devices = null;
            this.routers = scanRouters;
        }

        @Override
        public void broadcast(FrameEvent e) {
        }

        @Override
        public void dataConnected(FrameEvent e) {
            CEMI frame = e.getFrame();
            if (frame instanceof CEMILData) {
                byte[] apdu = frame.getPayload();
                IndividualAddress source = ((CEMILData)frame).getSource();
                if (DataUnitBuilder.getAPDUService(apdu) == 832) {
                    try {
                        DeviceDescriptor.DD0 dd = DeviceDescriptor.DD0.from(Arrays.copyOfRange(apdu, 2, 4));
                        this.dd0.accept(source, dd);
                    }
                    catch (RuntimeException rte) {
                        logger.info("{} device descriptor 0 response", (Object)source, (Object)rte);
                    }
                }
            }
        }

        @Override
        public void dataIndividual(FrameEvent e) {
        }

        @Override
        public void disconnected(Destination d) {
            if (d.getDisconnectedBy() != 1) {
                return;
            }
            IndividualAddress addr = d.getAddress();
            if (this.routers && addr.getDevice() == 0) {
                this.accept(addr);
            } else if (!this.routers && addr.getDevice() != 0) {
                this.accept(addr);
            }
        }

        private void accept(IndividualAddress addr) {
            if (this.disconnect != null) {
                this.disconnect.accept(addr);
            } else {
                this.devices.add(addr);
            }
        }

        @Override
        public void group(FrameEvent e) {
        }

        @Override
        public void detached(DetachEvent e) {
        }

        @Override
        public void linkClosed(CloseEvent e) {
        }
    }
}

