/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.mgmt;

import java.util.Map;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DetachEvent;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.KNXDisconnectException;
import tuwien.auto.calimero.mgmt.TransportLayer;
import tuwien.auto.calimero.mgmt.TransportLayerImpl;
import tuwien.auto.calimero.mgmt.TransportListener;
import tuwien.auto.calimero.secure.SecureApplicationLayer;
import tuwien.auto.calimero.secure.Security;

public class SecureManagement
extends SecureApplicationLayer {
    private static final int DataConnected = 64;
    private final TransportLayerImpl transportLayer;
    private final EventListeners<TransportListener> listeners;
    private final TransportListener transportListener = new TransportListener(){

        @Override
        public void group(FrameEvent e) {
            SecureManagement.this.extract(e).ifPresent(e2 -> {
                SecureManagement.this.listeners.fire(tl -> tl.group((FrameEvent)e2));
                SecureManagement.this.dispatchLinkEvent(e2);
            });
        }

        @Override
        public void broadcast(FrameEvent e) {
            SecureManagement.this.extract(e).ifPresent(e2 -> SecureManagement.this.listeners.fire(tl -> tl.broadcast((FrameEvent)e2)));
        }

        @Override
        public void dataIndividual(FrameEvent e) {
            SecureManagement.this.extract(e).ifPresent(e2 -> SecureManagement.this.listeners.fire(tl -> tl.dataIndividual((FrameEvent)e2)));
        }

        @Override
        public void dataConnected(FrameEvent e) {
            SecureManagement.this.extract(e).ifPresent(e2 -> SecureManagement.this.listeners.fire(tl -> tl.dataConnected((FrameEvent)e2)));
        }

        @Override
        public void disconnected(Destination d) {
            SecureManagement.this.listeners.fire(tl -> tl.disconnected(d));
        }

        @Override
        public void detached(DetachEvent e) {
            SecureManagement.this.listeners.fire(tl -> tl.detached(e));
        }

        @Override
        public void linkClosed(CloseEvent e) {
            SecureManagement.this.listeners.fire(tl -> tl.linkClosed(e));
        }
    };

    protected SecureManagement(TransportLayerImpl transportLayer, SerialNumber serialNumber, long sequenceNumber, Map<IndividualAddress, byte[]> deviceToolKeys) {
        super(transportLayer.link(), serialNumber, sequenceNumber, deviceToolKeys);
        this.transportLayer = transportLayer;
        this.listeners = new EventListeners();
        transportLayer.addTransportListener(this.transportListener);
    }

    SecureManagement(TransportLayer transportLayer, Map<IndividualAddress, byte[]> deviceToolKeys) {
        this((TransportLayerImpl)transportLayer, SerialNumber.Zero, 0L, deviceToolKeys);
    }

    public void addListener(TransportListener l) {
        this.listeners.add(l);
    }

    public void removeListener(TransportListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void close() {
        this.transportLayer.removeTransportListener(this.transportListener);
        super.close();
    }

    @Override
    protected void send(KNXAddress remote, byte[] secureApdu) throws KNXTimeoutException, KNXLinkClosedException {
        Destination destination;
        Destination destination2 = destination = remote instanceof IndividualAddress ? this.transportLayer.getDestination((IndividualAddress)remote) : null;
        if (destination != null && destination.isConnectionOriented()) {
            try {
                this.transportLayer.sendData(destination, Priority.SYSTEM, secureApdu);
            }
            catch (KNXDisconnectException e) {
                throw new KNXTimeoutException("timeout caused by disconnect from " + remote, e);
            }
        } else {
            this.transportLayer.sendData(remote, Priority.SYSTEM, secureApdu);
        }
    }

    @Override
    protected int tpci(KNXAddress dst) {
        Destination.AggregatorProxy proxy = this.transportLayer.proxies().get(dst);
        int seqSend = 0;
        int tlMode = 0;
        if (proxy != null) {
            Destination destination = proxy.getDestination();
            tlMode = destination.isConnectionOriented() ? 64 : 0;
            seqSend = proxy.getSeqSend();
        }
        int tpci = tlMode | seqSend << 2;
        return tpci;
    }

    @Override
    protected Security security() {
        return super.security();
    }
}

