/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.mgmt;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DetachEvent;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.cemi.CemiTData;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.NetworkLinkListener;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.KNXDisconnectException;
import tuwien.auto.calimero.mgmt.TransportLayer;
import tuwien.auto.calimero.mgmt.TransportListener;

public class TransportLayerImpl
implements TransportLayer {
    private static final int CONNECT = 128;
    private static final int DISCONNECT = 129;
    private static final int ACK = 194;
    private static final int NACK = 195;
    private static final int DATA_CONNECTED = 64;
    private static final int ACK_TIMEOUT = 3;
    private static final int MAX_REPEAT = 3;
    private final Destination unknownPartner = new Destination(new Destination.AggregatorProxy(this), new IndividualAddress(0), true);
    private final Logger logger;
    private final boolean serverSide;
    private volatile boolean detached;
    private final KNXNetworkLink lnk;
    private final NetworkLinkListener lnkListener = new NLListener();
    private final Deque<FrameEvent> indications = new ArrayDeque<FrameEvent>();
    private final EventListeners<TransportListener> listeners;
    private final Map<IndividualAddress, Destination.AggregatorProxy> proxies = new HashMap<IndividualAddress, Destination.AggregatorProxy>();
    private final Map<IndividualAddress, Destination.AggregatorProxy> incomingProxies = new HashMap<IndividualAddress, Destination.AggregatorProxy>();
    private Destination.AggregatorProxy active;
    private volatile int repeated;
    private final Object lock = new Object();

    public TransportLayerImpl(KNXNetworkLink link) throws KNXLinkClosedException {
        this(link, false);
    }

    public TransportLayerImpl(KNXNetworkLink link, boolean serverEndpoint) throws KNXLinkClosedException {
        if (!link.isOpen()) {
            throw new KNXLinkClosedException("cannot initialize transport layer using closed link " + link.getName());
        }
        this.lnk = link;
        this.logger = LogService.getLogger("calimero.mgmt." + this.getName());
        this.lnk.addLinkListener(this.lnkListener);
        this.listeners = new EventListeners(this.logger);
        this.serverSide = serverEndpoint;
    }

    @Override
    public Destination createDestination(IndividualAddress remote, boolean connectionOriented) {
        return this.createDestination(remote, connectionOriented, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination createDestination(IndividualAddress remote, boolean connectionOriented, boolean keepAlive, boolean verifyMode) {
        if (this.detached) {
            throw new IllegalStateException("TL detached");
        }
        Map<IndividualAddress, Destination.AggregatorProxy> map = this.proxies;
        synchronized (map) {
            if (this.proxies.containsKey(remote)) {
                throw new KNXIllegalArgumentException("destination already created: " + remote);
            }
            Destination.AggregatorProxy p = new Destination.AggregatorProxy(this);
            Destination d = new Destination(p, remote, connectionOriented, keepAlive, verifyMode);
            this.proxies.put(remote, p);
            this.logger.trace("created {}", (Object)d);
            return d;
        }
    }

    public Destination getDestination(IndividualAddress remote) {
        Destination.AggregatorProxy proxy = this.proxies.get(remote);
        return proxy != null ? proxy.getDestination() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyDestination(Destination d) {
        Map<IndividualAddress, Destination.AggregatorProxy> map = this.proxies;
        synchronized (map) {
            Destination.AggregatorProxy p = this.proxies.get(d.getAddress());
            if (p == null) {
                return;
            }
            if (p.getDestination() == d) {
                d.destroy();
                this.proxies.remove(d.getAddress());
                Deque<FrameEvent> deque = this.indications;
                synchronized (deque) {
                    this.indications.notify();
                }
            } else {
                this.logger.warn("not owner of " + d.getAddress());
            }
        }
    }

    @Override
    public void addTransportListener(TransportListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTransportListener(TransportListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void connect(Destination d) throws KNXTimeoutException, KNXLinkClosedException {
        Destination.AggregatorProxy p = this.getProxy(d);
        if (!d.isConnectionOriented()) {
            this.logger.error("destination not connection-oriented: " + d.getAddress());
            return;
        }
        if (d.getState() != Destination.State.Disconnected) {
            return;
        }
        p.setState(Destination.State.Connecting);
        byte[] tpdu = new byte[]{-128};
        this.lnk.sendRequestWait(d.getAddress(), Priority.SYSTEM, tpdu);
        p.setState(Destination.State.OpenIdle);
        this.logger.trace("connected with {}", (Object)d.getAddress());
    }

    @Override
    public void disconnect(Destination d) throws KNXLinkClosedException {
        if (this.detached) {
            throw new IllegalStateException("TL detached");
        }
        if (d.getState() != Destination.State.Destroyed && d.getState() != Destination.State.Disconnected) {
            this.disconnectIndicate(this.getProxy(d), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendData(Destination d, Priority p, byte[] tsdu) throws KNXDisconnectException, KNXLinkClosedException {
        try {
            this.connect(d);
        }
        catch (KNXTimeoutException e) {
            throw new KNXDisconnectException("no connection opened for " + d.getAddress() + " (timeout)", d);
        }
        Destination.AggregatorProxy ap = this.getProxy(d);
        tsdu[0] = (byte)(tsdu[0] & 3 | 0x40 | ap.getSeqSend() << 2);
        Object object = this.lock;
        synchronized (object) {
            Deque<FrameEvent> deque = this.indications;
            synchronized (deque) {
                try {
                    this.active = ap;
                    this.repeated = 0;
                    while (this.repeated < 4) {
                        block14: {
                            try {
                                this.logger.trace("sending data connected to {}, attempt {}", (Object)d.getAddress(), (Object)(this.repeated + 1));
                                ap.setState(Destination.State.OpenWait);
                                this.lnk.sendRequestWait(d.getAddress(), p, tsdu);
                                if (!this.waitForAck()) break block14;
                            }
                            catch (KNXTimeoutException kNXTimeoutException) {
                                // empty catch block
                                break block14;
                            }
                            return;
                        }
                        if (this.detached || d.getState() == Destination.State.Destroyed) {
                            throw new KNXDisconnectException("send data connected failed", d);
                        }
                        ++this.repeated;
                    }
                }
                finally {
                    this.active = null;
                    this.repeated = 0;
                }
            }
        }
        this.disconnectIndicate(ap, true);
        throw new KNXDisconnectException("send data connected failed", d);
    }

    @Override
    public void sendData(KNXAddress addr, Priority p, byte[] tsdu) throws KNXTimeoutException, KNXLinkClosedException {
        if (this.detached) {
            throw new IllegalStateException("TL detached");
        }
        tsdu[0] = (byte)(tsdu[0] & 3);
        this.lnk.sendRequestWait(addr, p, tsdu);
    }

    @Override
    public void broadcast(boolean system, Priority p, byte[] tsdu) throws KNXTimeoutException, KNXLinkClosedException {
        this.sendData(system ? null : GroupAddress.Broadcast, p, tsdu);
    }

    @Override
    public String getName() {
        return "TL " + (this.detached ? "(detached)" : this.lnk.getName());
    }

    @Override
    public synchronized KNXNetworkLink detach() {
        if (this.detached) {
            return null;
        }
        this.closeDestinations(false);
        this.lnk.removeLinkListener(this.lnkListener);
        this.detached = true;
        this.fireDetached();
        this.logger.debug("detached from {}", (Object)this.lnk);
        return this.lnk;
    }

    Map<IndividualAddress, Destination.AggregatorProxy> proxies() {
        return this.proxies;
    }

    KNXNetworkLink link() {
        return this.lnk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Destination.AggregatorProxy getProxy(Destination d) {
        if (this.detached) {
            throw new IllegalStateException("TL detached");
        }
        Map<IndividualAddress, Destination.AggregatorProxy> map = this.proxies;
        synchronized (map) {
            Destination.AggregatorProxy p = this.proxies.get(d.getAddress());
            if (p == null || p.getDestination() != d) {
                throw new KNXIllegalArgumentException("not the owner of " + d.toString());
            }
            return p;
        }
    }

    private void handleConnected(CEMILData frame, Destination.AggregatorProxy p) throws KNXLinkClosedException, KNXTimeoutException {
        Destination d;
        IndividualAddress sender = frame.getSource();
        byte[] tpdu = frame.getPayload();
        int ctrl = tpdu[0] & 0xFF;
        int seq = (tpdu[0] & 0x3C) >>> 2;
        Destination destination = d = p != null ? p.getDestination() : this.unknownPartner;
        if (ctrl == 128) {
            if (this.serverSide) {
                IndividualAddress device = this.lnk.getKNXMedium().getDeviceAddress();
                if (!frame.getDestination().equals(device)) {
                    return;
                }
                Destination.AggregatorProxy proxy = p;
                if (proxy != null && !d.isConnectionOriented()) {
                    this.logger.warn(d + ": recreate for conn-oriented");
                    d.destroy();
                    proxy = null;
                }
                if (proxy == null) {
                    proxy = new Destination.AggregatorProxy(this);
                    Destination client = new Destination(proxy, sender, true);
                    this.incomingProxies.put(sender, proxy);
                    this.proxies.put(sender, proxy);
                    proxy.setState(Destination.State.OpenIdle);
                } else {
                    proxy.setState(Destination.State.Connecting);
                    proxy.setState(Destination.State.OpenIdle);
                }
            } else if (d.getState() == Destination.State.Disconnected) {
                this.checkSendDisconnect(frame);
            }
        } else if (ctrl == 129) {
            if (d.getState() != Destination.State.Disconnected && sender.equals(d.getAddress())) {
                this.disconnectIndicate(p, false);
            }
        } else if ((ctrl & 0xC0) == 64) {
            if (d.getState() == Destination.State.Disconnected || !sender.equals(d.getAddress())) {
                this.checkSendDisconnect(frame);
            } else {
                Objects.requireNonNull(p);
                p.restartTimeout();
                if (seq == p.getSeqReceive()) {
                    this.lnk.sendRequest(sender, Priority.SYSTEM, new byte[]{(byte)(0xC2 | p.getSeqReceive() << 2)});
                    p.incSeqReceive();
                    this.fireFrameType(frame, 3);
                } else if (seq == (p.getSeqReceive() - 1 & 0xF)) {
                    this.lnk.sendRequest(sender, Priority.SYSTEM, new byte[]{(byte)(0xC2 | seq << 2)});
                } else {
                    this.lnk.sendRequest(sender, Priority.SYSTEM, new byte[]{(byte)(0xC3 | seq << 2)});
                }
            }
        } else if ((ctrl & 0xC3) == 194) {
            if (d.getState() == Destination.State.Disconnected || !sender.equals(d.getAddress())) {
                this.checkSendDisconnect(frame);
            } else if (d.getState() == Destination.State.OpenWait && seq == Objects.requireNonNull(p).getSeqSend()) {
                p.incSeqSend();
                p.setState(Destination.State.OpenIdle);
                this.logger.trace("positive ack by {}", (Object)d.getAddress());
            } else {
                this.disconnectIndicate(p, true);
            }
        } else if ((ctrl & 0xC3) == 195) {
            if (d.getState() == Destination.State.Disconnected || !sender.equals(d.getAddress())) {
                this.checkSendDisconnect(frame);
            } else if (d.getState() != Destination.State.OpenWait || seq != Objects.requireNonNull(p).getSeqSend() || this.repeated >= 3) {
                this.disconnectIndicate(p, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForAck() throws KNXTimeoutException, KNXDisconnectException, KNXLinkClosedException {
        boolean interrupted = false;
        try {
            long remaining = 3000L;
            long end = System.currentTimeMillis() + remaining;
            Destination d = this.active.getDestination();
            while (remaining > 0L) {
                block12: {
                    while (this.indications.size() > 0) {
                        this.handleConnected((CEMILData)this.indications.remove().getFrame(), this.active);
                    }
                    if (d.getState() == Destination.State.Disconnected || d.getState() == Destination.State.Destroyed) {
                        throw new KNXDisconnectException(d.getAddress() + " disconnected while awaiting ACK", d);
                    }
                    if (d.getState() != Destination.State.OpenIdle) break block12;
                    boolean bl = true;
                    return bl;
                }
                try {
                    this.indications.wait(remaining);
                    if (d.getState() == Destination.State.Disconnected || d.getState() == Destination.State.Destroyed) {
                        throw new KNXDisconnectException(d.getAddress() + " disconnected while awaiting ACK", d);
                    }
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                remaining = end - System.currentTimeMillis();
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDestinations(boolean skipSendDisconnect) {
        Destination.AggregatorProxy[] allProxies = new Destination.AggregatorProxy[this.proxies.size()];
        Map<IndividualAddress, Destination.AggregatorProxy> map = this.proxies;
        synchronized (map) {
            allProxies = this.proxies.values().toArray(allProxies);
        }
        for (int i = 0; i < allProxies.length; ++i) {
            Destination.AggregatorProxy p = allProxies[i];
            Destination d = p.getDestination();
            if (skipSendDisconnect && d.getState() != Destination.State.Disconnected) {
                p.setState(Destination.State.Disconnected);
                this.fireDisconnected(d);
            }
            d.destroy();
        }
    }

    private void disconnectIndicate(Destination.AggregatorProxy p, boolean sendDisconnectReq) throws KNXLinkClosedException {
        p.setState(Destination.State.Disconnected);
        p.getDestination().disconnectedBy = sendDisconnectReq ? 2 : 1;
        try {
            if (sendDisconnectReq) {
                this.sendDisconnect(p.getDestination().getAddress());
            }
        }
        finally {
            this.fireDisconnected(p.getDestination());
            this.logger.trace("disconnected from {}", (Object)p.getDestination().getAddress());
        }
    }

    private void checkSendDisconnect(CEMILData frame) throws KNXLinkClosedException {
        IndividualAddress device = this.lnk.getKNXMedium().getDeviceAddress();
        if (device.getRawAddress() == 0 || device.equals(frame.getDestination())) {
            this.sendDisconnect(frame.getSource());
        }
    }

    private void sendDisconnect(IndividualAddress addr) throws KNXLinkClosedException {
        byte[] tpdu = new byte[]{-127};
        try {
            this.logger.trace("send disconnect to {}", (Object)addr);
            this.lnk.sendRequestWait(addr, Priority.SYSTEM, tpdu);
        }
        catch (KNXTimeoutException ignore) {
            this.logger.warn("disconnected not gracefully (timeout)", (Throwable)ignore);
        }
    }

    private void fireDisconnected(Destination d) {
        this.listeners.fire(l -> l.disconnected(d));
    }

    private void fireFrameType(CEMI frame, int type) {
        Consumer<TransportListener> c;
        FrameEvent e = new FrameEvent((Object)this, frame);
        if (type == 0) {
            c = l -> l.broadcast(e);
        } else if (type == 1) {
            c = l -> l.group(e);
        } else if (type == 2) {
            c = l -> l.dataIndividual(e);
        } else if (type == 3) {
            c = l -> l.dataConnected(e);
        } else {
            return;
        }
        this.listeners.fire(c);
    }

    private void fireDetached() {
        DetachEvent e = new DetachEvent(this);
        this.listeners.fire(l -> l.detached(e));
    }

    private void fireLinkClosed(CloseEvent e) {
        this.listeners.fire(l -> l.linkClosed(e));
    }

    private final class NLListener
    implements NetworkLinkListener {
        private NLListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void indication(FrameEvent e) {
            CEMI cemi = e.getFrame();
            if (cemi instanceof CemiTData) {
                int type = cemi.getMessageCode() == 137 ? 3 : 2;
                TransportLayerImpl.this.fireFrameType(cemi, type);
                return;
            }
            CEMILData f = (CEMILData)cemi;
            if (f.getSource().equals(TransportLayerImpl.this.link().getKNXMedium().getDeviceAddress())) {
                return;
            }
            int ctrl = f.getPayload()[0] & 0xFC;
            if (ctrl == 0) {
                KNXAddress dst = f.getDestination();
                if (dst instanceof GroupAddress) {
                    TransportLayerImpl.this.fireFrameType(f, dst.getRawAddress() == 0 ? 0 : 1);
                } else {
                    TransportLayerImpl.this.fireFrameType(f, 2);
                }
            } else {
                IndividualAddress src = f.getSource();
                Deque<FrameEvent> deque = TransportLayerImpl.this.indications;
                synchronized (deque) {
                    if (TransportLayerImpl.this.active != null && TransportLayerImpl.this.active.getDestination().getAddress().equals(src)) {
                        TransportLayerImpl.this.indications.add(e);
                        TransportLayerImpl.this.indications.notify();
                        return;
                    }
                }
                Destination.AggregatorProxy ap = null;
                Map<IndividualAddress, Destination.AggregatorProxy> map = TransportLayerImpl.this.proxies;
                synchronized (map) {
                    ap = TransportLayerImpl.this.proxies.get(src);
                }
                try {
                    TransportLayerImpl.this.handleConnected(f, ap);
                }
                catch (KNXTimeoutException | KNXLinkClosedException kNXException) {
                }
                catch (RuntimeException rte) {
                    TransportLayerImpl.this.logger.error("{}: {}", new Object[]{ap != null ? ap.getDestination() : "destination n/a", f, rte});
                }
            }
        }

        @Override
        public void linkClosed(CloseEvent e) {
            TransportLayerImpl.this.logger.debug("attached link was closed");
            TransportLayerImpl.this.closeDestinations(true);
            TransportLayerImpl.this.fireLinkClosed(e);
        }
    }
}

