/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.process;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DetachEvent;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXInvalidResponseException;
import tuwien.auto.calimero.KNXRemoteException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.ReturnCode;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.datapoint.Datapoint;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.DPTXlator2ByteFloat;
import tuwien.auto.calimero.dptxlator.DPTXlator3BitControlled;
import tuwien.auto.calimero.dptxlator.DPTXlator4ByteFloat;
import tuwien.auto.calimero.dptxlator.DPTXlator8BitUnsigned;
import tuwien.auto.calimero.dptxlator.DPTXlatorBoolean;
import tuwien.auto.calimero.dptxlator.DPTXlatorString;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.NetworkLinkListener;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.process.ProcessCommunicator;
import tuwien.auto.calimero.process.ProcessEvent;
import tuwien.auto.calimero.process.ProcessListener;
import tuwien.auto.calimero.secure.SecureApplicationLayer;
import tuwien.auto.calimero.secure.Security;

public class ProcessCommunicatorImpl
implements ProcessCommunicator {
    private static final int GROUP_READ = 0;
    private static final int GROUP_RESPONSE = 64;
    private static final int GROUP_WRITE = 128;
    private final KNXNetworkLink lnk;
    private final NetworkLinkListener lnkListener = new NLListener();
    private final SecureApplicationLayer sal;
    private final EventListeners<ProcessListener> listeners;
    private final Map<GroupAddress, FrameEvent> indications = new HashMap<GroupAddress, FrameEvent>();
    private static final FrameEvent NoResponse = new FrameEvent(ProcessCommunicatorImpl.class, (CEMI)null);
    private final Map<GroupAddress, AtomicInteger> readers = new HashMap<GroupAddress, AtomicInteger>();
    private volatile Priority priority = Priority.LOW;
    private volatile Duration responseTimeout = Duration.ofSeconds(5L);
    private volatile boolean detached;
    private final Logger logger;

    public ProcessCommunicatorImpl(KNXNetworkLink link) throws KNXLinkClosedException {
        this(link, new SecureApplicationLayer(link, Security.defaultInstallation()));
    }

    public ProcessCommunicatorImpl(KNXNetworkLink link, SecureApplicationLayer sal) throws KNXLinkClosedException {
        if (!link.isOpen()) {
            throw new KNXLinkClosedException("cannot initialize process communication using closed link " + link.getName());
        }
        this.logger = LogService.getLogger("calimero.process.communication " + link.getName());
        this.lnk = link;
        this.sal = sal;
        this.listeners = new EventListeners(this.logger);
        sal.addListener(this.lnkListener);
    }

    @Override
    public Duration responseTimeout() {
        return this.responseTimeout;
    }

    @Override
    public void responseTimeout(Duration timeout) {
        if (timeout.isNegative() || timeout.isZero()) {
            throw new KNXIllegalArgumentException("timeout <= 0");
        }
        this.responseTimeout = timeout;
    }

    @Override
    public void setPriority(Priority p) {
        this.priority = p;
    }

    @Override
    public Priority getPriority() {
        return this.priority;
    }

    @Override
    public void addProcessListener(ProcessListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeProcessListener(ProcessListener l) {
        this.listeners.remove(l);
    }

    @Override
    public boolean readBool(GroupAddress dst) throws KNXTimeoutException, KNXRemoteException, KNXLinkClosedException, KNXFormatException, InterruptedException {
        byte[] apdu = this.readFromGroup(dst, this.priority, 0, 0);
        DPTXlatorBoolean t = new DPTXlatorBoolean(DPTXlatorBoolean.DPT_BOOL);
        ProcessCommunicatorImpl.extractGroupASDU(apdu, t);
        return t.getValueBoolean();
    }

    @Override
    public void write(GroupAddress dst, boolean value) throws KNXTimeoutException, KNXLinkClosedException {
        try {
            DPTXlatorBoolean t = new DPTXlatorBoolean(DPTXlatorBoolean.DPT_BOOL);
            t.setValue(value);
            this.write(dst, this.priority, t);
        }
        catch (KNXFormatException kNXFormatException) {
            // empty catch block
        }
    }

    @Override
    public int readUnsigned(GroupAddress dst, String scale) throws KNXTimeoutException, KNXRemoteException, KNXLinkClosedException, KNXFormatException, InterruptedException {
        byte[] apdu = this.readFromGroup(dst, this.priority, 1, 1);
        DPTXlator8BitUnsigned t = new DPTXlator8BitUnsigned(scale);
        ProcessCommunicatorImpl.extractGroupASDU(apdu, t);
        return t.getValueUnsigned();
    }

    @Override
    public void write(GroupAddress dst, int value, String scale) throws KNXTimeoutException, KNXFormatException, KNXLinkClosedException {
        DPTXlator8BitUnsigned t = new DPTXlator8BitUnsigned(scale);
        t.setValue(value);
        this.write(dst, this.priority, t);
    }

    @Override
    public int readControl(GroupAddress dst) throws KNXTimeoutException, KNXRemoteException, KNXLinkClosedException, KNXFormatException, InterruptedException {
        byte[] apdu = this.readFromGroup(dst, this.priority, 0, 0);
        DPTXlator3BitControlled t = new DPTXlator3BitControlled(DPTXlator3BitControlled.DPT_CONTROL_DIMMING);
        ProcessCommunicatorImpl.extractGroupASDU(apdu, t);
        return t.getValueSigned();
    }

    @Override
    public void write(GroupAddress dst, boolean control, int stepcode) throws KNXTimeoutException, KNXFormatException, KNXLinkClosedException {
        DPTXlator3BitControlled t = new DPTXlator3BitControlled(DPTXlator3BitControlled.DPT_CONTROL_DIMMING);
        t.setValue(control, stepcode);
        this.write(dst, this.priority, t);
    }

    @Override
    public void write(GroupAddress dst, double value, boolean use4ByteFloat) throws KNXTimeoutException, KNXFormatException, KNXLinkClosedException {
        if (use4ByteFloat) {
            DPTXlator4ByteFloat t = new DPTXlator4ByteFloat(DPTXlator4ByteFloat.DPT_TEMPERATURE_DIFFERENCE);
            t.setValue((float)value);
            this.write(dst, this.priority, t);
        } else {
            DPTXlator2ByteFloat t = new DPTXlator2ByteFloat(DPTXlator2ByteFloat.DPT_RAIN_AMOUNT);
            t.setValue(value);
            this.write(dst, this.priority, t);
        }
    }

    @Override
    public double readFloat(GroupAddress dst) throws KNXTimeoutException, KNXRemoteException, KNXLinkClosedException, KNXFormatException, InterruptedException {
        byte[] apdu = this.readFromGroup(dst, this.priority, 2, 4);
        DPTXlator t = apdu.length == 6 ? new DPTXlator4ByteFloat(DPTXlator4ByteFloat.DPT_TEMPERATURE_DIFFERENCE) : new DPTXlator2ByteFloat(DPTXlator2ByteFloat.DPT_RAIN_AMOUNT);
        ProcessCommunicatorImpl.extractGroupASDU(apdu, t);
        return t.getNumericValue();
    }

    @Override
    public String readString(GroupAddress dst) throws KNXTimeoutException, KNXRemoteException, KNXLinkClosedException, KNXFormatException, InterruptedException {
        byte[] apdu = this.readFromGroup(dst, this.priority, 0, 14);
        DPTXlatorString t = new DPTXlatorString(DPTXlatorString.DPT_STRING_8859_1);
        ProcessCommunicatorImpl.extractGroupASDU(apdu, t);
        return t.getValue();
    }

    @Override
    public void write(GroupAddress dst, String value) throws KNXTimeoutException, KNXFormatException, KNXLinkClosedException {
        DPTXlatorString t = new DPTXlatorString(DPTXlatorString.DPT_STRING_8859_1);
        t.setValue(value);
        this.write(dst, this.priority, t);
    }

    @Override
    public void write(GroupAddress dst, DPTXlator value) throws KNXTimeoutException, KNXLinkClosedException {
        this.write(dst, this.priority, value);
    }

    @Override
    public String read(Datapoint dp) throws KNXException, InterruptedException {
        byte[] apdu = this.readFromGroup(dp.getMainAddress(), dp.getPriority(), 0, 14);
        if (dp.getDPT() == null) {
            return DataUnitBuilder.toHex(DataUnitBuilder.extractASDU(apdu), " ");
        }
        DPTXlator t = TranslatorTypes.createTranslator(dp.getMainNumber(), dp.getDPT());
        ProcessCommunicatorImpl.extractGroupASDU(apdu, t);
        return t.getValue();
    }

    @Override
    public void write(Datapoint dp, String value) throws KNXException {
        DPTXlator t = TranslatorTypes.createTranslator(dp.getMainNumber(), dp.getDPT());
        t.setValue(value);
        this.write(dp.getMainAddress(), dp.getPriority(), t);
    }

    @Override
    public double readNumeric(Datapoint dp) throws KNXException, InterruptedException {
        byte[] apdu = this.readFromGroup(dp.getMainAddress(), dp.getPriority(), 0, 8);
        if (dp.getMainNumber() == 0 && dp.getDPT() == null) {
            int offset;
            apdu[1] = (byte)(apdu[1] & 0x3F);
            long l = 0L;
            for (int i = offset = apdu.length == 2 ? 1 : 2; i < apdu.length; ++i) {
                l = (l << 8) + (long)(apdu[i] & 0xFF);
            }
            return l;
        }
        DPTXlator t = TranslatorTypes.createTranslator(dp.getMainNumber(), dp.getDPT());
        ProcessCommunicatorImpl.extractGroupASDU(apdu, t);
        return t.getNumericValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KNXNetworkLink detach() {
        NetworkLinkListener networkLinkListener = this.lnkListener;
        synchronized (networkLinkListener) {
            if (this.detached) {
                return null;
            }
            this.detached = true;
        }
        this.lnk.removeLinkListener(this.lnkListener);
        this.sal.close();
        this.fireDetached();
        this.logger.debug("detached from link {}", (Object)this.lnk.getName());
        return this.lnk;
    }

    private void write(GroupAddress dst, Priority p, DPTXlator t) throws KNXTimeoutException, KNXLinkClosedException {
        if (this.detached) {
            throw new IllegalStateException("process communicator detached");
        }
        try {
            this.send(dst, p, 128, t);
            this.logger.trace("group write to {} succeeded", (Object)dst);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KNXTimeoutException("interrupted", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFromGroup(GroupAddress dst, Priority p, int minASDULen, int maxASDULen) throws KNXTimeoutException, KNXInvalidResponseException, KNXLinkClosedException, InterruptedException {
        Map<GroupAddress, FrameEvent> map;
        Object object;
        if (this.detached) {
            throw new IllegalStateException("process communicator detached");
        }
        try {
            object = this.indications;
            synchronized (object) {
                this.readers.computeIfAbsent(dst, v -> new AtomicInteger()).incrementAndGet();
                this.indications.putIfAbsent(dst, NoResponse);
            }
            this.send(dst, p, 0, null);
            this.logger.trace("sent group read request to {}", (Object)dst);
            object = this.waitForResponse(dst, minASDULen + 2, maxASDULen + 2);
            map = this.indications;
        }
        catch (Throwable throwable) {
            Map<GroupAddress, FrameEvent> map2 = this.indications;
            synchronized (map2) {
                boolean none = this.readers.get(dst).decrementAndGet() == 0;
                this.readers.compute(dst, (k, v) -> none ? null : v);
                this.indications.compute(dst, (k, v) -> none ? null : v);
            }
            throw throwable;
        }
        synchronized (map) {
            boolean none = this.readers.get(dst).decrementAndGet() == 0;
            this.readers.compute(dst, (k, v) -> none ? null : v);
            this.indications.compute(dst, (k, v) -> none ? null : v);
        }
        return object;
    }

    private void send(GroupAddress dst, Priority p, int service, DPTXlator t) throws KNXTimeoutException, KNXLinkClosedException, InterruptedException {
        boolean useGoDiagnostics = Security.defaultInstallation().groupKeys().containsKey(dst);
        if (useGoDiagnostics) {
            try {
                CompletableFuture<ReturnCode> future = this.sal.writeGroupObjectDiagnostics(dst, t == null ? new byte[]{} : t.getData());
                ReturnCode returnCode = future.get();
                if (returnCode != ReturnCode.Success) {
                    this.logger.warn("{} {}", (Object)dst, (Object)returnCode);
                }
            }
            catch (ExecutionException e) {
                this.logger.warn("waiting for GO diagnostics", e.getCause());
            }
        } else {
            IndividualAddress src = this.lnk.getKNXMedium().getDeviceAddress();
            byte[] plainApdu = ProcessCommunicatorImpl.createGroupAPDU(service, t);
            byte[] apdu = this.sal.secureGroupObject(src, dst, plainApdu).orElse(plainApdu);
            this.lnk.sendRequestWait(dst, p, apdu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] waitForResponse(GroupAddress from, int minAPDU, int maxAPDU) throws KNXInvalidResponseException, KNXTimeoutException, InterruptedException {
        long remaining = this.responseTimeout.toMillis();
        long end = System.currentTimeMillis() + remaining;
        Map<GroupAddress, FrameEvent> map = this.indications;
        synchronized (map) {
            while (remaining > 0L) {
                FrameEvent e = this.indications.get(from);
                if (e == NoResponse) {
                    this.indications.wait(remaining);
                    remaining = end - System.currentTimeMillis();
                    continue;
                }
                byte[] d = e.getFrame().getPayload();
                int len = d.length;
                if (len >= minAPDU && len <= maxAPDU) {
                    return d;
                }
                String s = "APDU response length " + len + " bytes, expected " + minAPDU + " to " + maxAPDU;
                this.logger.error("received group read response from {} with {}", (Object)from, (Object)s);
                throw new KNXInvalidResponseException(s);
            }
        }
        this.logger.info("timeout waiting for group read response from {}", (Object)from);
        throw new KNXTimeoutException("timeout waiting for group read response from " + from);
    }

    private void fireDetached() {
        DetachEvent e = new DetachEvent(this);
        this.listeners.fire(l -> l.detached(e));
    }

    private static byte[] createGroupAPDU(int service, DPTXlator t) {
        if (service == 0) {
            return new byte[2];
        }
        if (service != 64 && service != 128) {
            throw new KNXIllegalArgumentException("not an APDU group service");
        }
        int offset = t.getItems() == 1 && t.getTypeSize() == 0 ? 1 : 2;
        byte[] buf = new byte[t.getItems() * Math.max(1, t.getTypeSize()) + offset];
        buf[0] = (byte)(service >> 8);
        buf[1] = (byte)service;
        return t.getData(buf, offset);
    }

    private static void extractGroupASDU(byte[] apdu, DPTXlator t) {
        if (apdu.length < 2) {
            throw new KNXIllegalArgumentException("minimum APDU length is 2 bytes");
        }
        t.setData(apdu, apdu.length == 2 ? 1 : 2);
    }

    private final class NLListener
    implements NetworkLinkListener {
        private NLListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void indication(FrameEvent e) {
            CEMILData f = (CEMILData)e.getFrame();
            byte[] apdu = f.getPayload();
            if (apdu.length < 2) {
                return;
            }
            try {
                int svc = DataUnitBuilder.getAPDUService(apdu);
                if (svc == 64) {
                    Map<GroupAddress, FrameEvent> map = ProcessCommunicatorImpl.this.indications;
                    synchronized (map) {
                        if (ProcessCommunicatorImpl.this.indications.replace((GroupAddress)f.getDestination(), e) != null) {
                            ProcessCommunicatorImpl.this.indications.notifyAll();
                        }
                    }
                }
                if (svc == 0) {
                    this.fireGroupReadWrite(f, new byte[0], svc, false);
                } else if (svc == 64 || svc == 128) {
                    this.fireGroupReadWrite(f, DataUnitBuilder.extractASDU(apdu), svc, apdu.length <= 2);
                }
            }
            catch (RuntimeException rte) {
                ProcessCommunicatorImpl.this.logger.error("on group indication from {}", (Object)f.getSource(), (Object)rte);
            }
        }

        private void fireGroupReadWrite(CEMILData f, byte[] asdu, int svc, boolean optimized) {
            ProcessEvent e = new ProcessEvent(ProcessCommunicatorImpl.this, f.getSource(), (GroupAddress)f.getDestination(), svc, asdu, optimized);
            Consumer<ProcessListener> c = svc == 0 ? l -> l.groupReadRequest(e) : (svc == 64 ? l -> l.groupReadResponse(e) : l -> l.groupWrite(e));
            ProcessCommunicatorImpl.this.listeners.fire(c);
        }

        @Override
        public void linkClosed(CloseEvent e) {
            ProcessCommunicatorImpl.this.logger.info("attached link was closed ({})", (Object)e.getReason());
            ProcessCommunicatorImpl.this.detach();
        }
    }
}

