/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.process;

import java.util.EventObject;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.process.ProcessCommunicator;

public class ProcessEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private final IndividualAddress src;
    private final GroupAddress dst;
    private final int svcCode;
    private final byte[] asdu;
    private final boolean optimized;

    public ProcessEvent(ProcessCommunicator source, IndividualAddress src, GroupAddress dst, int svcCode, byte[] asdu, boolean optimized) {
        super(source);
        this.src = src;
        this.dst = dst;
        this.svcCode = svcCode;
        this.asdu = asdu;
        this.optimized = optimized;
    }

    public final IndividualAddress getSourceAddr() {
        return this.src;
    }

    public final GroupAddress getDestination() {
        return this.dst;
    }

    public final byte[] getASDU() {
        return (byte[])this.asdu.clone();
    }

    public final int getServiceCode() {
        return this.svcCode;
    }

    public final boolean isLengthOptimizedAPDU() {
        return this.optimized;
    }

    @Override
    public String toString() {
        return this.src + "->" + this.dst + " " + DataUnitBuilder.decodeAPCI(this.svcCode) + " " + DataUnitBuilder.toHex(this.asdu, "");
    }
}

