/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.process;

import java.util.EventListener;
import tuwien.auto.calimero.DetachEvent;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.DPTXlator2ByteFloat;
import tuwien.auto.calimero.dptxlator.DPTXlator3BitControlled;
import tuwien.auto.calimero.dptxlator.DPTXlator4ByteFloat;
import tuwien.auto.calimero.dptxlator.DPTXlator8BitUnsigned;
import tuwien.auto.calimero.dptxlator.DPTXlatorBoolean;
import tuwien.auto.calimero.dptxlator.DPTXlatorString;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;
import tuwien.auto.calimero.process.ProcessEvent;

public interface ProcessListener
extends EventListener {
    public static boolean asBool(ProcessEvent e) throws KNXFormatException {
        DPTXlatorBoolean t = new DPTXlatorBoolean(DPTXlatorBoolean.DPT_BOOL);
        t.setData(e.getASDU());
        return t.getValueBoolean();
    }

    public static int asUnsigned(ProcessEvent e, String scale) throws KNXFormatException {
        DPTXlator8BitUnsigned t = new DPTXlator8BitUnsigned(scale);
        t.setData(e.getASDU());
        return t.getValueUnsigned();
    }

    public static int asControl(ProcessEvent e) throws KNXFormatException {
        DPTXlator3BitControlled t = new DPTXlator3BitControlled(DPTXlator3BitControlled.DPT_CONTROL_DIMMING);
        t.setData(e.getASDU());
        return t.getValueSigned();
    }

    public static double asFloat(ProcessEvent e) throws KNXFormatException {
        byte[] asdu = e.getASDU();
        DPTXlator t = asdu.length > 3 ? new DPTXlator4ByteFloat(DPTXlator4ByteFloat.DPT_TEMPERATURE_DIFFERENCE) : new DPTXlator2ByteFloat(DPTXlator2ByteFloat.DPT_RAIN_AMOUNT);
        t.setData(asdu);
        return t.getNumericValue();
    }

    public static String asString(ProcessEvent e) throws KNXFormatException {
        DPTXlatorString t = new DPTXlatorString(DPTXlatorString.DPT_STRING_8859_1);
        t.setData(e.getASDU());
        return t.getValue();
    }

    public static String asString(ProcessEvent e, String dptId) throws KNXException {
        return ProcessListener.asString(e, 0, dptId);
    }

    public static String asString(ProcessEvent e, int dptMainNumber, String dptID) throws KNXException {
        DPTXlator t = TranslatorTypes.createTranslator(dptMainNumber, dptID);
        t.setData(e.getASDU());
        return t.getValue();
    }

    public void groupReadRequest(ProcessEvent var1);

    public void groupReadResponse(ProcessEvent var1);

    public void groupWrite(ProcessEvent var1);

    public void detached(DetachEvent var1);
}

