/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.secure;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.ReturnCode;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMIFactory;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.NetworkLinkListener;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.secure.KnxSecureException;
import tuwien.auto.calimero.secure.Security;
import tuwien.auto.calimero.secure.SecurityControl;

public class SecureApplicationLayer
implements AutoCloseable {
    public static final int SecureService = 1009;
    protected static final int InvalidScf = 1;
    protected static final int SeqNoError = 2;
    protected static final int CryptoError = 3;
    protected static final int AccessAndRoleError = 4;
    static boolean test;
    static final int SecureDataPdu = 0;
    static final int SecureSyncRequest = 2;
    static final int SecureSyncResponse = 3;
    private static final int MacSize = 4;
    private static final int SeqSize = 6;
    private static final String secureSymbol;
    private final KNXNetworkLink link;
    private final SerialNumber serialNumber;
    private final Logger logger;
    private volatile long sequenceNumber;
    private volatile long sequenceNumberToolAccess;
    private final Map<IndividualAddress, Long> lastValidSequence = new ConcurrentHashMap<IndividualAddress, Long>();
    private final Map<IndividualAddress, Long> lastValidSequenceToolAccess = new ConcurrentHashMap<IndividualAddress, Long>();
    private final Security security;
    private volatile Instant lastSyncRes = Instant.EPOCH;
    final Map<IndividualAddress, SyncRequest> pendingSyncRequests = new ConcurrentHashMap<IndividualAddress, SyncRequest>();
    private final Map<SerialNumber, SyncRequest> pendingBcSyncRequests = new ConcurrentHashMap<SerialNumber, SyncRequest>();
    final ThreadLocal<Long> syncChallenge = ThreadLocal.withInitial(() -> 0L);
    private static final int FunctionPropertyExtCommand = 468;
    private static final int FunctionPropertyExtStateResponse = 470;
    private static final int GroupObjectTableType = 9;
    private static final int pidGoDiagnostics = 66;
    private final Map<IndividualAddress, CompletableFuture<ReturnCode>> pendingGoDiagnostics = new ConcurrentHashMap<IndividualAddress, CompletableFuture<ReturnCode>>();
    private static final IntUnaryOperator saturatingIncrement;
    private final AtomicInteger scfErrors = new AtomicInteger();
    private final AtomicInteger seqErrors = new AtomicInteger();
    private final AtomicInteger cryptoErrors = new AtomicInteger();
    private final AtomicInteger accessAndRoleErrors = new AtomicInteger();
    private final EventListeners<NetworkLinkListener> listeners = new EventListeners();
    private final NetworkLinkListener linkListener = new NetworkLinkListener(){

        @Override
        public void indication(FrameEvent e) {
            SecureApplicationLayer.this.extract(e).ifPresent(SecureApplicationLayer.this::dispatchLinkEvent);
        }

        @Override
        public void confirmation(FrameEvent e) {
            SecureApplicationLayer.this.extract(e).ifPresent(SecureApplicationLayer.this::dispatchLinkEvent);
        }

        @Override
        public void linkClosed(CloseEvent e) {
            SecureApplicationLayer.this.listeners.fire(ll -> ll.linkClosed(e));
        }
    };
    private static final SecureRandom rng;

    public static final boolean isSecuredService(CEMILData ldata) {
        byte[] payload = ldata.getPayload();
        if (payload.length < 2) {
            return false;
        }
        int service = DataUnitBuilder.getAPDUService(payload);
        return service == 1009;
    }

    public SecureApplicationLayer(KNXNetworkLink link, Security security) {
        this(link, SerialNumber.Zero, 0L, security);
        link.addLinkListener(this.linkListener);
    }

    public SecureApplicationLayer(KNXNetworkLink link, Map<GroupAddress, byte[]> groupKeys, Map<GroupAddress, Set<IndividualAddress>> groupSenders, Map<IndividualAddress, byte[]> deviceToolKeys) {
        this(link, SerialNumber.Zero, 0L, Security.withKeys(deviceToolKeys, groupKeys, groupSenders));
        link.addLinkListener(this.linkListener);
    }

    protected SecureApplicationLayer(KNXNetworkLink link, SerialNumber serialNumber, long sequenceNumber, Map<IndividualAddress, byte[]> deviceToolKeys) {
        this(link, serialNumber, sequenceNumber, Security.withKeys(deviceToolKeys, Map.of(), Map.of()));
    }

    private SecureApplicationLayer(KNXNetworkLink link, SerialNumber serialNumber, long sequenceNumber, Security security) {
        this.link = link;
        this.serialNumber = serialNumber;
        this.logger = LogService.getLogger("calimero." + secureSymbol + "-AL " + link.getName());
        this.security = security;
        this.sequenceNumber = sequenceNumber;
        this.sequenceNumberToolAccess = 1L;
    }

    public void addListener(NetworkLinkListener l) {
        this.listeners.add(l);
    }

    public void removeListener(NetworkLinkListener l) {
        this.listeners.remove(l);
    }

    public Optional<byte[]> secureGroupObject(IndividualAddress src, GroupAddress dst, byte[] apdu) throws InterruptedException {
        boolean auth;
        int flags = this.groupObjectSecurity(dst);
        boolean conf = (flags & 2) == 2;
        boolean bl = auth = (flags & 1) == 1;
        if (!conf && !auth) {
            return Optional.empty();
        }
        boolean toolAccess = this.sequenceNumber == 0L;
        SecurityControl.DataSecurity security = conf ? SecurityControl.DataSecurity.AuthConf : SecurityControl.DataSecurity.Auth;
        return this.secureData(src, dst, apdu, SecurityControl.of(security, toolAccess));
    }

    public CompletableFuture<ReturnCode> writeGroupObjectDiagnostics(GroupAddress group, byte[] value) throws KNXTimeoutException, KNXLinkClosedException, InterruptedException {
        boolean oinstance = true;
        boolean sendGroupValueWrite = true;
        int sendGroupValueRead = 3;
        int service = value.length == 0 ? 3 : 1;
        SecurityControl.DataSecurity diagSecCtrl = SecurityControl.DataSecurity.AuthConf;
        int secFlags = diagSecCtrl == SecurityControl.DataSecurity.AuthConf ? 3 : (diagSecCtrl == SecurityControl.DataSecurity.Auth ? 1 : 0);
        boolean longApdu = value.length == 1 && value[0] < 64 ? false : false;
        int flags = (longApdu ? 128 : 0) | secFlags;
        ByteBuffer asdu = ByteBuffer.allocate(10 + value.length).putShort((short)9).put((byte)0).put((byte)16).put((byte)66).put((byte)0).put((byte)service).put((byte)flags).put(group.toByteArray()).put(value);
        byte[] apdu = DataUnitBuilder.createAPDU(468, asdu.array());
        IndividualAddress surrogate = this.surrogate(group);
        SecurityControl secCtrl = SecurityControl.of(SecurityControl.DataSecurity.AuthConf, true);
        byte[] secureApdu = this.secureData(this.address(), surrogate, apdu, secCtrl).get();
        this.logger.trace("{}->{} GO diagnostics {} {}", new Object[]{this.address(), surrogate, service, DataUnitBuilder.toHex(value, " ")});
        this.send(surrogate, secureApdu);
        CompletableFuture future = new CompletableFuture().orTimeout(3L, TimeUnit.SECONDS);
        this.pendingGoDiagnostics.put(surrogate, future);
        return future.whenComplete((__, ___) -> this.pendingGoDiagnostics.remove(surrogate));
    }

    private void checkGoDiagnosticsResponse(IndividualAddress src, IndividualAddress dst, int service, byte[] apdu) {
        if (service != 470 || apdu.length < 9) {
            return;
        }
        ByteBuffer data = ByteBuffer.wrap(apdu, 2, apdu.length - 2);
        int ot = data.getShort() & 0xFFFF;
        if (ot != 9) {
            return;
        }
        int i = data.getShort() & 0xFFFF;
        int oinstance = i >> 4 & 0xFFF;
        if (oinstance != 1) {
            return;
        }
        int pid = (i & 0xF) << 8 | data.get() & 0xFF;
        if (pid != 66) {
            return;
        }
        ReturnCode returnCode = ReturnCode.of(data.get() & 0xFF);
        int goService = data.get() & 0xFF;
        this.logger.trace("{}->{} GO diagnostics {} {}", new Object[]{src, dst, goService, returnCode});
        CompletableFuture<ReturnCode> future = this.pendingGoDiagnostics.get(src);
        if (future != null) {
            future.complete(returnCode);
        }
    }

    public Optional<byte[]> secureBroadcastData(IndividualAddress src, SerialNumber serialNumber, IndividualAddress dst, byte[] apdu, SecurityControl securityCtrl) throws InterruptedException {
        if (securityCtrl == SecurityControl.Plain) {
            return Optional.of(apdu);
        }
        boolean toolAccess = securityCtrl.toolAccess();
        byte[] key = this.security.broadcastToolKeys().get(serialNumber);
        if (key == null) {
            key = this.lookupKey(dst, toolAccess);
        }
        if (key == null) {
            return Optional.empty();
        }
        long seqTool = this.nextSequenceNumber(toolAccess);
        if (seqTool <= 1L) {
            try {
                this.broadcastSyncRequest(serialNumber, key, toolAccess, securityCtrl.systemBroadcast()).get();
            }
            catch (KNXTimeoutException | KNXLinkClosedException e) {
                throw new KnxSecureException("sync.req with " + dst, e);
            }
            catch (ExecutionException e) {
                throw new KnxSecureException("sync.req with " + dst, e.getCause());
            }
        }
        Optional<byte[]> sapdu = this.secure(0, src, GroupAddress.Broadcast, apdu, securityCtrl, key);
        this.updateSequenceNumber(toolAccess, this.nextSequenceNumber(toolAccess) + 1L);
        return sapdu;
    }

    public Optional<byte[]> secureData(IndividualAddress src, KNXAddress dst, byte[] apdu, SecurityControl securityCtrl) throws InterruptedException {
        if (securityCtrl == SecurityControl.Plain) {
            return Optional.of(apdu);
        }
        boolean toolAccess = securityCtrl.toolAccess();
        if (dst.equals(GroupAddress.Broadcast) && !toolAccess) {
            throw new KNXIllegalArgumentException("p2p broadcast not supported");
        }
        byte[] key = this.lookupKey(dst, toolAccess);
        if (key == null) {
            return Optional.empty();
        }
        long seqTool = this.nextSequenceNumber(toolAccess);
        if (seqTool <= 1L) {
            this.syncWith(dst, toolAccess);
        }
        Optional<byte[]> sapdu = this.secure(0, src, dst, apdu, securityCtrl, key);
        this.updateSequenceNumber(toolAccess, this.nextSequenceNumber(toolAccess) + 1L);
        return sapdu;
    }

    Optional<byte[]> secure(int service, IndividualAddress src, IndividualAddress dst, byte[] apdu, SecurityControl secCtrl) {
        return this.secure(service, src, dst, apdu, secCtrl, this.lookupKey(dst, secCtrl.toolAccess()));
    }

    private Optional<byte[]> secure(int service, IndividualAddress src, KNXAddress dst, byte[] apdu, SecurityControl secCtrl, byte[] key) {
        return this.secure(service, src, SerialNumber.Zero, dst, apdu, secCtrl, key);
    }

    private Optional<byte[]> secure(int service, IndividualAddress src, SerialNumber dstSno, KNXAddress dst, byte[] apdu, SecurityControl secCtrl, byte[] key) {
        boolean systemBroadcast = secCtrl.systemBroadcast();
        if (systemBroadcast && !dst.equals(GroupAddress.Broadcast)) {
            throw new KNXIllegalArgumentException("system broadcast requires broadcast address");
        }
        boolean toolAccess = secCtrl.toolAccess();
        if (toolAccess) {
            if (secCtrl.security() != SecurityControl.DataSecurity.AuthConf) {
                throw new KNXIllegalArgumentException("tool access requires auth+conf security");
            }
            if (dst instanceof GroupAddress && dst.getRawAddress() != 0) {
                throw new KNXIllegalArgumentException("tool access requires individual address");
            }
        } else if (systemBroadcast) {
            throw new KNXIllegalArgumentException("system broadcast requires tool access");
        }
        boolean syncReq = service == 2;
        boolean syncRes = service == 3;
        int snoLength = syncReq ? 6 : 0;
        ByteBuffer secureApdu = ByteBuffer.allocate(9 + snoLength + apdu.length + 4);
        int tpci = this.tpci(dst) | 3;
        secureApdu.put((byte)tpci);
        secureApdu.put((byte)-15);
        int scf = SecureApplicationLayer.toSecurityCtrlField(service, secCtrl);
        secureApdu.put((byte)scf);
        long seqSend = this.nextSequenceNumber(toolAccess);
        if (seqSend == 0L) {
            throw new KnxSecureException("0 is not a valid sequence number");
        }
        this.logger.trace("use {}sequence {}", (Object)(toolAccess ? "tool access " : ""), (Object)seqSend);
        ByteBuffer seq = SecureApplicationLayer.sixBytes(seqSend);
        if (!syncRes) {
            secureApdu.put(seq);
        }
        ByteBuffer associatedData = ByteBuffer.allocate(syncReq ? 7 : 1).put((byte)scf);
        byte[] seqOrRand = SecureApplicationLayer.seqOrRand(service, seq.array());
        if (syncReq) {
            byte[] sno = dstSno.array();
            secureApdu.put(sno);
            associatedData.put(sno);
        } else if (syncRes) {
            BitSet rndXorChallenge = BitSet.valueOf(seqOrRand);
            ByteBuffer challenge = SecureApplicationLayer.sixBytes(this.syncChallenge.get());
            rndXorChallenge.xor(BitSet.valueOf(challenge));
            secureApdu.put(rndXorChallenge.toByteArray());
        }
        boolean extendedFrameFormat = false;
        byte[] iv = SecureApplicationLayer.block0(seqOrRand, src, dst, 0, tpci, 1009, apdu.length);
        byte[] ctr0 = SecureApplicationLayer.blockCtr0(seqOrRand, src, dst);
        try {
            if (secCtrl.security() == SecurityControl.DataSecurity.AuthConf) {
                byte[] mac = SecureApplicationLayer.confMac(associatedData.array(), apdu, key, iv);
                byte[] input = ByteBuffer.allocate(4 + apdu.length).put(mac).put(apdu).array();
                byte[] encrypted = SecureApplicationLayer.encrypt(input, key, ctr0);
                secureApdu.put(encrypted, 4, apdu.length);
                secureApdu.put(encrypted, 0, 4);
            } else {
                secureApdu.put(apdu);
                byte[] mac = SecureApplicationLayer.mac(apdu, key, iv, ctr0);
                secureApdu.put(mac);
            }
        }
        catch (GeneralSecurityException e) {
            this.securityFailure(3, src, dst, seqSend);
            throw new KnxSecureException(String.format("securing %s->%s", src, dst), e);
        }
        return Optional.of(secureApdu.array());
    }

    public SalService extract(CEMILData ldata) {
        byte[] payload = ldata.getPayload();
        if (payload.length < 2) {
            return new SalService(SecurityControl.Plain, payload);
        }
        int service = DataUnitBuilder.getAPDUService(payload);
        if (service != 1009) {
            return new SalService(SecurityControl.Plain, payload);
        }
        if (payload.length < 14) {
            this.securityFailure(3, ldata.getSource(), ldata.getDestination(), 0L);
            throw new KnxSecureException("frame length " + payload.length + " too short for a secure frame");
        }
        return this.extract(ldata.getSource(), ldata.getDestination(), payload);
    }

    SalService extract(IndividualAddress src, KNXAddress dst, byte[] secureApdu) {
        int service = DataUnitBuilder.getAPDUService(secureApdu);
        if (service != 1009) {
            throw new KNXIllegalArgumentException(String.format("%s is not a secure service", DataUnitBuilder.decodeAPCI(service)));
        }
        int tpci = secureApdu[0] & 0xFF;
        byte[] secureAsdu = DataUnitBuilder.extractASDU(secureApdu);
        return this.decrypt(src, dst, tpci, secureAsdu);
    }

    protected Optional<FrameEvent> extract(FrameEvent e) {
        CEMI cemi = e.getFrame();
        if (cemi instanceof CEMILData) {
            CEMILData ldata = (CEMILData)cemi;
            try {
                SalService salData = this.extract(ldata);
                if (salData.apdu().length == 0) {
                    return Optional.empty();
                }
                if (salData.security() == SecurityControl.Plain) {
                    return Optional.of(e);
                }
                CEMI plain = CEMIFactory.create(cemi.getMessageCode(), salData.apdu(), cemi);
                FrameEvent extracted = new FrameEvent(e.getSource(), plain, e.systemBroadcast(), salData.security());
                return Optional.of(extracted);
            }
            catch (KnxSecureException kse) {
                this.logger.info(kse.toString());
            }
            catch (RuntimeException | KNXFormatException ex) {
                this.logger.warn(ex.toString());
            }
            return Optional.empty();
        }
        return Optional.of(e);
    }

    public SalService decrypt(IndividualAddress src, KNXAddress dst, int tpci, byte[] secureAsdu) {
        byte[] decrypted;
        byte[] plainApdu;
        boolean isGroupDst;
        ByteBuffer asdu = ByteBuffer.wrap(secureAsdu, 0, secureAsdu.length);
        int scf = asdu.get() & 0xFF;
        Object[] flags = this.parseSecurityCtrlField(scf, src, dst, 0L);
        SecurityControl securityCtrl = (SecurityControl)flags[0];
        int service = (Integer)flags[1];
        boolean toolAccess = securityCtrl.toolAccess();
        boolean syncReq = service == 2;
        boolean syncRes = service == 3;
        byte[] key = null;
        SyncRequest request = null;
        if (syncRes) {
            if (dst.equals(GroupAddress.Broadcast)) {
                Iterator<Map.Entry<SerialNumber, SyncRequest>> i = this.pendingBcSyncRequests.entrySet().iterator();
                if (i.hasNext()) {
                    request = i.next().getValue();
                    key = request.key();
                    if (i.hasNext()) {
                        this.logger.warn("multiple sync.req broadcasts, only first is checked");
                    }
                }
            } else {
                request = this.pendingSyncRequests.get(src);
            }
            if (request == null) {
                return new SalService(securityCtrl, new byte[0]);
            }
        }
        boolean broadcast = dst.equals(GroupAddress.Broadcast);
        boolean bl = isGroupDst = dst instanceof GroupAddress && !broadcast;
        if (key == null) {
            byte[] byArray = isGroupDst ? this.securityKey(dst) : (toolAccess ? this.toolKey(src.equals(this.address()) && !broadcast ? (IndividualAddress)dst : src) : (key = this.securityKey(src)));
        }
        if (key == null) {
            return new SalService(securityCtrl, new byte[0]);
        }
        byte[] seq = new byte[6];
        asdu.get(seq);
        long receivedSeq = SecureApplicationLayer.toLong(seq);
        if (isGroupDst && toolAccess) {
            this.securityFailure(4, src, dst, receivedSeq);
            throw new KnxSecureException(String.format("%s->%s group service with tool access", src, dst));
        }
        byte[] sno = new byte[6];
        if (service == 0) {
            long expectedSeq = this.lastValidSequenceNumber(toolAccess, src) + 1L;
            if (receivedSeq < expectedSeq) {
                this.securityFailure(2, src, dst, receivedSeq);
                throw new KnxSecureException(String.format("%s->%s received sequence number %d < %d (expected)", src, dst, receivedSeq, expectedSeq));
            }
        } else if (syncReq) {
            asdu.get(sno);
            if (!(this.serialNumber.equals(SerialNumber.from(sno)) || !securityCtrl.systemBroadcast() && dst.equals(this.address()) && Arrays.equals(sno, new byte[6]))) {
                return new SalService(securityCtrl, new byte[0]);
            }
            if (Instant.now().minusSeconds(1L).isBefore(this.lastSyncRes)) {
                return new SalService(securityCtrl, new byte[0]);
            }
        } else if (syncRes) {
            BitSet challengeXorRandom = BitSet.valueOf(seq);
            BitSet challenge = BitSet.valueOf(SecureApplicationLayer.sixBytes(Objects.requireNonNull(request).challenge));
            challengeXorRandom.xor(challenge);
            seq = challengeXorRandom.toByteArray();
        }
        String s = service == 2 ? "sync.req" : (service == 3 ? "sync.res" : "S-A_Data");
        this.logger.debug("{}->{} decrypt {} ({})", new Object[]{src, dst, s, securityCtrl});
        byte[] apdu = new byte[asdu.remaining() - 4];
        asdu.get(apdu);
        byte[] ctr0 = SecureApplicationLayer.blockCtr0(seq, src, dst);
        byte[] mac = new byte[4];
        asdu.get(mac);
        boolean extendedFrameFormat = false;
        byte[] iv = SecureApplicationLayer.block0(seq, src, dst, 0, tpci, 1009, apdu.length);
        if (securityCtrl.security() == SecurityControl.DataSecurity.Auth) {
            plainApdu = apdu;
            try {
                byte[] calculated = SecureApplicationLayer.mac(plainApdu, key, iv, ctr0);
                this.verifyMac(mac, calculated, src, dst, receivedSeq);
            }
            catch (GeneralSecurityException e) {
                this.securityFailure(3, src, dst, receivedSeq);
                throw new KnxSecureException(String.format("calculating MAC %s->%s", src, dst), e);
            }
        }
        ByteBuffer input = ByteBuffer.allocate(4 + apdu.length).put(mac).put(apdu);
        try {
            decrypted = SecureApplicationLayer.decrypt(input.array(), key, ctr0);
        }
        catch (GeneralSecurityException e) {
            this.securityFailure(3, src, dst, receivedSeq);
            throw new KnxSecureException(String.format("decrypting %s->%s", src, dst), e);
        }
        byte[] decryptedMac = Arrays.copyOfRange(decrypted, 0, 4);
        plainApdu = Arrays.copyOfRange(decrypted, 4, decrypted.length);
        ByteBuffer associatedData = ByteBuffer.allocate(syncReq ? 7 : 1).put((byte)scf);
        if (syncReq) {
            associatedData.put(sno);
        }
        try {
            byte[] calculated = SecureApplicationLayer.confMac(associatedData.array(), plainApdu, key, iv);
            this.verifyMac(decryptedMac, calculated, src, dst, receivedSeq);
        }
        catch (GeneralSecurityException e) {
            this.securityFailure(3, src, dst, receivedSeq);
            throw new KnxSecureException(String.format("calculating MAC %s->%s", src, dst), e);
        }
        if (syncReq && src.equals(this.address())) {
            return new SalService(securityCtrl, new byte[0]);
        }
        if (syncReq) {
            this.receivedSyncRequest(src, dst, toolAccess, securityCtrl.systemBroadcast(), seq, SecureApplicationLayer.toLong(plainApdu));
            return new SalService(securityCtrl, new byte[0]);
        }
        if (syncRes) {
            Objects.requireNonNull(request).complete();
            this.receivedSyncResponse(src, toolAccess, plainApdu);
            return new SalService(securityCtrl, new byte[0]);
        }
        if (src.equals(this.address())) {
            this.logger.trace("update next {}seq -> {}", (Object)(toolAccess ? "tool access " : ""), (Object)receivedSeq);
            this.updateSequenceNumber(toolAccess, receivedSeq + 1L);
        } else {
            this.logger.trace("update last valid {}seq of {} -> {}", new Object[]{toolAccess ? "tool access " : "", src, receivedSeq});
            this.updateLastValidSequence(toolAccess, src, receivedSeq);
        }
        int plainService = DataUnitBuilder.getAPDUService(plainApdu);
        if (dst instanceof IndividualAddress) {
            this.checkGoDiagnosticsResponse(src, (IndividualAddress)dst, plainService, plainApdu);
        }
        if (!this.checkAccess(dst, plainService, securityCtrl)) {
            this.securityFailure(4, src, dst, receivedSeq);
            throw new KnxSecureException(String.format("%s->%s denied access for %s (%s)", src, dst, DataUnitBuilder.decodeAPCI(plainService), securityCtrl));
        }
        return new SalService(securityCtrl, plainApdu);
    }

    private void verifyMac(byte[] mac, byte[] calculated, IndividualAddress src, KNXAddress dst, long receivedSeq) {
        if (!Arrays.equals(calculated, mac)) {
            this.securityFailure(3, src, dst, receivedSeq);
            throw new KnxSecureException(String.format("MAC mismatch %s->%s", src, dst));
        }
    }

    public CompletableFuture<Void> sendSyncRequest(IndividualAddress remote, boolean toolAccess) throws KNXTimeoutException, KNXLinkClosedException {
        long challenge = ThreadLocalRandom.current().nextLong();
        byte[] secureApdu = this.secure(2, this.address(), remote, SecureApplicationLayer.sixBytes(challenge).array(), SecurityControl.of(SecurityControl.DataSecurity.AuthConf, toolAccess)).get();
        this.logger.debug("sync {} seq with {}", (Object)(toolAccess ? "tool access" : "p2p"), (Object)remote);
        SyncRequest request = this.stashSyncRequest(remote, challenge);
        this.send(remote, secureApdu);
        return request.future;
    }

    SyncRequest stashSyncRequest(IndividualAddress remote, long challenge) {
        SyncRequest request = new SyncRequest(challenge, new byte[0]);
        request.future.whenComplete((__, ___) -> this.pendingSyncRequests.remove(remote));
        this.pendingSyncRequests.put(remote, request);
        return request;
    }

    public CompletableFuture<AutoCloseable> broadcastSyncRequest(SerialNumber serialNumber, byte[] key, boolean toolAccess, boolean systemBroadcast) throws KNXTimeoutException, KNXLinkClosedException {
        if (systemBroadcast && !toolAccess) {
            throw new KNXIllegalArgumentException("system broadcast requires tool access");
        }
        long challenge = ThreadLocalRandom.current().nextLong();
        SecurityControl secCtrl = systemBroadcast ? SecurityControl.SystemBroadcast : SecurityControl.of(SecurityControl.DataSecurity.AuthConf, toolAccess);
        byte[] secureApdu = this.secure(2, this.address(), serialNumber, GroupAddress.Broadcast, SecureApplicationLayer.sixBytes(challenge).array(), secCtrl, key).get();
        this.logger.debug("{} sync for S/N {} ({})", new Object[]{systemBroadcast ? "SBC" : "broadcast", serialNumber, toolAccess ? "tool access" : "p2p"});
        SyncRequest request = new SyncRequest(challenge, key);
        this.pendingBcSyncRequests.put(serialNumber, request);
        AutoCloseable removeableBroadcastKey = () -> {
            byte[] broadcastKey = this.security.broadcastToolKeys().remove(serialNumber);
            if (broadcastKey != null) {
                Arrays.fill(broadcastKey, (byte)0);
            }
        };
        CompletionStage future = ((CompletableFuture)request.future.whenComplete((__, ex) -> {
            this.pendingBcSyncRequests.remove(serialNumber);
            if (ex != null) {
                Arrays.fill(request.key(), (byte)0);
            } else {
                this.security.broadcastToolKeys().put(serialNumber, request.key());
            }
        })).thenApply(__ -> removeableBroadcastKey);
        this.send(systemBroadcast ? null : GroupAddress.Broadcast, secureApdu);
        return future;
    }

    @Override
    public void close() {
        this.link.removeLinkListener(this.linkListener);
    }

    protected Security security() {
        return this.security;
    }

    protected void dispatchLinkEvent(FrameEvent e) {
        CEMI cemi = e.getFrame();
        if (cemi.getMessageCode() == 41) {
            this.listeners.fire(ll -> ll.indication(e));
        } else if (cemi.getMessageCode() == 46) {
            this.listeners.fire(ll -> ll.confirmation(e));
        }
    }

    private byte[] lookupKey(KNXAddress dst, boolean toolAccess) {
        return toolAccess ? this.toolKey(dst.getRawAddress() == 0 ? this.address() : (IndividualAddress)dst) : this.securityKey(dst);
    }

    protected byte[] toolKey(IndividualAddress device) {
        return this.security.deviceToolKeys().get(device);
    }

    protected byte[] securityKey(KNXAddress addr) {
        if (addr instanceof GroupAddress) {
            GroupAddress group = (GroupAddress)addr;
            byte[] key = this.security.groupKeys().get(group);
            if (key == null) {
                throw new KnxSecureException("no group key for " + group);
            }
            return key;
        }
        return null;
    }

    long nextSequenceNumber(boolean toolAccess) {
        return toolAccess ? this.sequenceNumberToolAccess : this.sequenceNumber;
    }

    protected void updateSequenceNumber(boolean toolAccess, long seqNo) {
        if (toolAccess) {
            this.sequenceNumberToolAccess = seqNo;
        } else {
            this.sequenceNumber = seqNo;
        }
    }

    protected long lastValidSequenceNumber(boolean toolAccess, IndividualAddress remote) {
        if (toolAccess) {
            return this.lastValidSequenceToolAccess.getOrDefault(remote, 0L);
        }
        return this.lastValidSequence.getOrDefault(remote, 0L);
    }

    protected void updateLastValidSequence(boolean toolAccess, IndividualAddress remote, long seqNo) {
        if (toolAccess) {
            this.lastValidSequenceToolAccess.put(remote, seqNo);
        } else {
            this.lastValidSequence.put(remote, seqNo);
        }
    }

    protected boolean checkAccess(KNXAddress dst, int service, SecurityControl securityCtrl) {
        return true;
    }

    protected int groupObjectSecurity(GroupAddress group) {
        if (this.security.groupKeys().containsKey(group)) {
            return 3;
        }
        return 0;
    }

    protected int tpci(KNXAddress dst) {
        return 0;
    }

    protected void send(KNXAddress remote, byte[] secureApdu) throws KNXTimeoutException, KNXLinkClosedException {
        this.link.sendRequestWait(remote, Priority.SYSTEM, secureApdu);
    }

    protected final int failureCounter(int errorType) {
        switch (errorType) {
            case 1: {
                return this.scfErrors.get();
            }
            case 2: {
                return this.seqErrors.get();
            }
            case 3: {
                return this.cryptoErrors.get();
            }
            case 4: {
                return this.accessAndRoleErrors.get();
            }
        }
        throw new IllegalArgumentException("failure counter error type " + errorType);
    }

    protected void securityFailure(int errorType, IntUnaryOperator updateFunction, IndividualAddress src, KNXAddress dst, int ctrlExtended, long seqNo) {
        AtomicInteger[] counters = new AtomicInteger[]{null, this.scfErrors, this.seqErrors, this.cryptoErrors, this.accessAndRoleErrors};
        if (errorType > 4) {
            throw new IllegalArgumentException("failure counter error type " + errorType);
        }
        counters[errorType].updateAndGet(updateFunction);
    }

    private void securityFailure(int errorType, IndividualAddress src, KNXAddress dst, long seqNo) {
        int ctrlExtended = dst instanceof GroupAddress ? 128 : 0;
        this.securityFailure(errorType, saturatingIncrement, src, dst, ctrlExtended, seqNo);
    }

    void receivedSyncRequest(IndividualAddress src, KNXAddress dst, boolean toolAccess, boolean sysBcast, byte[] seq, long challenge) {
        String tool;
        long nextRemoteSeq = SecureApplicationLayer.toLong(seq);
        long nextSeq = 1L + this.lastValidSequenceNumber(toolAccess, src);
        String string = tool = toolAccess ? "tool " : "";
        if (nextRemoteSeq > nextSeq) {
            this.updateLastValidSequence(toolAccess, src, nextRemoteSeq - 1L);
            nextSeq = nextRemoteSeq;
        }
        this.logger.debug("{}->{} {}sync.req with {}seq {} (next {}), challenge {}", new Object[]{src, dst, sysBcast ? "SBC " : "", tool, nextRemoteSeq, nextSeq, challenge});
        this.syncChallenge.set(challenge);
        SecurityControl secCtrl = sysBcast ? SecurityControl.SystemBroadcast : SecurityControl.of(SecurityControl.DataSecurity.AuthConf, toolAccess);
        this.sendSyncResponse(src, secCtrl, dst.equals(GroupAddress.Broadcast), nextSeq);
    }

    void receivedSyncResponse(IndividualAddress remote, boolean toolAccess, byte[] plainApdu) {
        long next;
        long remoteSeq = SecureApplicationLayer.toLong(Arrays.copyOfRange(plainApdu, 0, 6));
        long localSeq = SecureApplicationLayer.toLong(Arrays.copyOfRange(plainApdu, 6, 12));
        long last = this.lastValidSequenceNumber(toolAccess, remote);
        if (remoteSeq - 1L > last) {
            this.logger.debug("sync.res update {} last valid {} seq -> {}", new Object[]{remote, toolAccess ? "tool access" : "p2p", remoteSeq - 1L});
            this.updateLastValidSequence(toolAccess, remote, remoteSeq - 1L);
        }
        if (localSeq > (next = this.nextSequenceNumber(toolAccess))) {
            this.logger.debug("sync.res update local next {} seq -> {}", (Object)(toolAccess ? "tool access" : "p2p"), (Object)localSeq);
            this.updateSequenceNumber(toolAccess, localSeq);
        }
    }

    private void sendSyncResponse(IndividualAddress dst, SecurityControl secCtrl, boolean broadcast, long remoteNextSeq) {
        boolean toolAccess = secCtrl.toolAccess();
        long ourNextSeq = this.nextSequenceNumber(toolAccess);
        ByteBuffer asdu = ByteBuffer.allocate(12).put(SecureApplicationLayer.sixBytes(ourNextSeq)).put(SecureApplicationLayer.sixBytes(remoteNextSeq));
        KNXAddress sendDst = broadcast ? GroupAddress.Broadcast : dst;
        byte[] key = this.lookupKey(dst, toolAccess);
        byte[] response = this.secure(3, this.address(), sendDst, asdu.array(), secCtrl, key).get();
        this.lastSyncRes = Instant.now();
        ForkJoinPool.commonPool().execute(() -> {
            try {
                this.send(sendDst, response);
            }
            catch (KNXTimeoutException | KNXLinkClosedException e) {
                this.logger.warn("error sending sync.res {}->{}", new Object[]{this.address(), sendDst, e});
            }
        });
    }

    private void syncWith(KNXAddress dst, boolean toolAccess) throws InterruptedException {
        try {
            IndividualAddress device = dst instanceof GroupAddress ? this.surrogate((GroupAddress)dst) : (IndividualAddress)dst;
            CompletableFuture<Void> future = this.sendSyncRequest(device, toolAccess);
            future.get();
        }
        catch (KNXException e) {
            throw new KnxSecureException("sync.req with " + dst, e);
        }
        catch (ExecutionException e) {
            throw new KnxSecureException("sync.req with " + dst, e.getCause());
        }
    }

    private IndividualAddress surrogate(GroupAddress group) {
        IndividualAddress surrogate = (IndividualAddress)this.security.groupSenders().getOrDefault(group, Set.of()).stream().findAny().orElseThrow(() -> new KnxSecureException(group + " does not have a surrogate specified"));
        return surrogate;
    }

    private IndividualAddress address() {
        return this.link.getKNXMedium().getDeviceAddress();
    }

    private Object[] parseSecurityCtrlField(int scf, IndividualAddress src, KNXAddress dst, long receivedSeq) {
        boolean toolAccess = (scf & 0x80) == 128;
        int algorithmId = scf >> 4 & 7;
        if (algorithmId > 1) {
            this.securityFailure(1, src, dst, receivedSeq);
            throw new KnxSecureException("unsupported secure algorithm ID " + algorithmId);
        }
        boolean authOnly = algorithmId == 0;
        boolean systemBroadcast = (scf & 8) == 8;
        int service = scf & 7;
        if (service == 1 || service > 3) {
            this.securityFailure(1, src, dst, receivedSeq);
            throw new KnxSecureException("unsupported secure AL service " + service);
        }
        if (systemBroadcast) {
            if (!toolAccess) {
                throw new KnxSecureException(String.format("%s->%s system broadcast requires tool access", src, dst));
            }
            if (authOnly) {
                this.logger.warn("auth-only system broadcast not supported");
            }
        }
        SecurityControl ctrl = systemBroadcast ? SecurityControl.SystemBroadcast : SecurityControl.of(authOnly ? SecurityControl.DataSecurity.Auth : SecurityControl.DataSecurity.AuthConf, toolAccess);
        return new Object[]{ctrl, service};
    }

    private static int toSecurityCtrlField(int service, SecurityControl secCtrl) {
        int scf = service;
        scf |= secCtrl.toolAccess() ? 128 : 0;
        scf |= secCtrl.security() == SecurityControl.DataSecurity.AuthConf ? 16 : 0;
        return scf |= secCtrl.systemBroadcast() ? 8 : 0;
    }

    private static ByteBuffer sixBytes(long num) {
        return ByteBuffer.allocate(6).putShort((short)(num >> 32)).putInt((int)num).flip();
    }

    private static long toLong(byte[] data) {
        long l = 0L;
        for (byte b : data) {
            l = (l << 8) + (long)(b & 0xFF);
        }
        return l;
    }

    private static byte[] seqOrRand(int service, byte[] seq) {
        if (service == 3) {
            if (test) {
                return new byte[]{-86, -86, -86, -86, -86, -86};
            }
            rng.nextBytes(seq);
        }
        return seq;
    }

    private static byte[] mac(byte[] apdu, byte[] key, byte[] iv, byte[] ctr0) throws GeneralSecurityException {
        ByteBuffer buf = ByteBuffer.allocate(2 + apdu.length);
        buf.putShort((short)apdu.length);
        buf.put(apdu);
        byte[] y = SecureApplicationLayer.aesCbc(buf.array(), key, iv);
        byte[] msbY = Arrays.copyOfRange(y, 0, 4);
        byte[] result = SecureApplicationLayer.encrypt(msbY, key, ctr0);
        return Arrays.copyOfRange(result, 0, 4);
    }

    private static byte[] confMac(byte[] associatedData, byte[] apdu, byte[] key, byte[] iv) throws GeneralSecurityException {
        ByteBuffer buf = ByteBuffer.allocate(2 + associatedData.length + apdu.length);
        buf.putShort((short)associatedData.length);
        buf.put(associatedData);
        buf.put(apdu);
        byte[] y = SecureApplicationLayer.aesCbc(buf.array(), key, iv);
        return Arrays.copyOfRange(y, y.length - 16, y.length - 16 + 4);
    }

    private static byte[] aesCbc(byte[] input, byte[] key, byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        IvParameterSpec params = new IvParameterSpec(new byte[16]);
        cipher.init(1, (Key)secretKey, params);
        cipher.update(iv);
        byte[] padded = Arrays.copyOf(input, (input.length + 15) / 16 * 16);
        return cipher.doFinal(padded);
    }

    private static byte[] block0(byte[] seqOrRand, IndividualAddress src, KNXAddress dst, int extendedFrameFormat, int tpci, int apci, int payloadLength) {
        return SecureApplicationLayer.ccmBlock(true, seqOrRand, src, dst, extendedFrameFormat, tpci, apci, payloadLength);
    }

    private static byte[] blockCtr0(byte[] seqOrRand, IndividualAddress src, KNXAddress dst) {
        return SecureApplicationLayer.ccmBlock(false, seqOrRand, src, dst, 0, 0, 0, 0);
    }

    private static byte[] ccmBlock(boolean b0, byte[] seqOrRand, IndividualAddress src, KNXAddress dst, int extendedFrameFormat, int tpci, int apci, int payloadLength) {
        ByteBuffer block = ByteBuffer.allocate(16);
        block.put(seqOrRand);
        block.put(src.toByteArray());
        block.put(dst.toByteArray());
        if (b0) {
            block.put((byte)0);
            boolean group = dst instanceof GroupAddress;
            int at = (group ? 128 : 0) | extendedFrameFormat & 0xF;
            block.put((byte)at);
            block.put((byte)tpci);
            block.put((byte)apci);
            block.put((byte)0);
            block.put((byte)payloadLength);
        } else {
            block.putInt(0);
            block.put((byte)1);
        }
        return block.array();
    }

    private static byte[] encrypt(byte[] input, byte[] key, byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        IvParameterSpec params = new IvParameterSpec(iv);
        cipher.init(1, (Key)secretKey, params);
        byte[] padded = Arrays.copyOf(input, (input.length + 15) / 16 * 16);
        return cipher.doFinal(padded);
    }

    private static byte[] decrypt(byte[] input, byte[] key, byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        IvParameterSpec params = new IvParameterSpec(iv);
        cipher.init(2, (Key)secretKey, params);
        return cipher.doFinal(input);
    }

    static {
        secureSymbol = new String(Character.toChars(128274));
        saturatingIncrement = i -> Math.min(i + 1, 65535);
        rng = new SecureRandom();
    }

    public final class SalService {
        private final SecurityControl ctrl;
        private final byte[] apdu;

        SalService(SecurityControl ctrl, byte[] apdu) {
            this.apdu = apdu;
            this.ctrl = ctrl;
        }

        public SecurityControl security() {
            return this.ctrl;
        }

        public byte[] apdu() {
            return (byte[])this.apdu.clone();
        }
    }

    private static final class SyncRequest {
        private static final Duration SyncTimeout = Duration.ofSeconds(6L);
        final long challenge;
        final CompletableFuture<Void> future;
        private final byte[] key;

        SyncRequest(long challenge, byte[] key) {
            this.challenge = challenge;
            this.future = new CompletableFuture().orTimeout(SyncTimeout.toSeconds(), TimeUnit.SECONDS);
            this.key = (byte[])key.clone();
        }

        byte[] key() {
            return this.key;
        }

        void complete() {
            this.future.complete(null);
        }
    }
}

