/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.secure;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.secure.Keyring;
import tuwien.auto.calimero.secure.KnxSecureException;

public final class Security {
    private static final Security defInst = new Security();
    private final Map<IndividualAddress, byte[]> deviceToolKeys = new ConcurrentHashMap<IndividualAddress, byte[]>();
    private final Map<GroupAddress, byte[]> groupKeys = new ConcurrentHashMap<GroupAddress, byte[]>();
    private final Map<GroupAddress, Set<IndividualAddress>> groupSenders = new ConcurrentHashMap<GroupAddress, Set<IndividualAddress>>();
    private final Map<SerialNumber, byte[]> broadcastToolKeys = new ConcurrentHashMap<SerialNumber, byte[]>();

    static Security withKeys(Map<IndividualAddress, byte[]> deviceToolKeys, Map<GroupAddress, byte[]> groupKeys, Map<GroupAddress, Set<IndividualAddress>> groupSenders) {
        Security s = new Security();
        s.deviceToolKeys.putAll(deviceToolKeys);
        s.groupKeys.putAll(groupKeys);
        s.groupSenders.putAll(groupSenders);
        return s;
    }

    public static Security defaultInstallation() {
        return defInst;
    }

    public void useKeyring(Keyring keyring, char[] password) {
        if (!keyring.verifySignature(password)) {
            throw new KnxSecureException("keyring signature mismatch (invalid keyring or wrong password)");
        }
        Map<IndividualAddress, Keyring.Device> devices = keyring.devices();
        devices.forEach((addr, device) -> device.toolKey().ifPresent(toolkey -> this.deviceToolKeys.put((IndividualAddress)addr, keyring.decryptKey((byte[])toolkey, password))));
        keyring.groups().forEach((addr, key) -> this.groupKeys.put((GroupAddress)addr, keyring.decryptKey((byte[])key, password)));
        Collection<List<Keyring.Interface>> interfaces = keyring.interfaces().values();
        Stream sendersByGroupStream = interfaces.stream().flatMap(Collection::stream).map(Keyring.Interface::groups).map(Map::entrySet).flatMap(Collection::stream);
        sendersByGroupStream.forEach(entry -> this.groupSenders.merge((GroupAddress)entry.getKey(), Security.concurrentSetOf((Set)entry.getValue()), (a, b) -> {
            a.addAll(b);
            return a;
        }));
    }

    private static <T> Set<T> concurrentSetOf(Set<T> t) {
        ConcurrentHashMap.KeySetView<T, Boolean> set = ConcurrentHashMap.newKeySet();
        set.addAll((Collection<T>)t);
        return set;
    }

    public Map<IndividualAddress, byte[]> deviceToolKeys() {
        return this.deviceToolKeys;
    }

    public Map<GroupAddress, byte[]> groupKeys() {
        return this.groupKeys;
    }

    public Map<GroupAddress, Set<IndividualAddress>> groupSenders() {
        return this.groupSenders;
    }

    Map<SerialNumber, byte[]> broadcastToolKeys() {
        return this.broadcastToolKeys;
    }
}

