/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAckTimeoutException;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXListener;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.serial.KNXPortClosedException;
import tuwien.auto.calimero.serial.LibraryAdapter;

public class FT12Connection
implements AutoCloseable {
    public static final int OK = 0;
    public static final int CLOSED = 1;
    public static final int ACK_PENDING = 2;
    public static final int CON_PENDING = 3;
    private static final int DEFAULT_BAUDRATE = 19200;
    static final int DIR_FROM_BAU = 128;
    static final int INITIATOR = 64;
    private static final int FRAMECOUNT_BIT = 32;
    private static final int FRAMECOUNT_VALID = 16;
    static final int ACK = 229;
    private static final int RESET = 0;
    private static final int USER_DATA = 3;
    private static final int REQ_STATUS = 9;
    private static final int EXCHANGE_TIMEOUT = 512;
    private static final int REPEAT_LIMIT = 3;
    private static final int IDLE_TIMEOUT = 33;
    static final int START = 104;
    static final int START_FIXED = 16;
    private static final int END = 22;
    private final Logger logger;
    private final LibraryAdapter adapter;
    private final String port;
    private final int exchangeTimeout;
    private final boolean cemi;
    private final InputStream is;
    private final OutputStream os;
    private volatile int state = 1;
    private final Receiver receiver;
    private final ReentrantLock sendLock = new ReentrantLock(true);
    private final Condition readyToSend = this.sendLock.newCondition();
    private final Condition ack = this.sendLock.newCondition();
    private final Condition con = this.sendLock.newCondition();
    private volatile KNXAddress keepForCon;
    private static final IndividualAddress NoLDataAddress = new IndividualAddress(65535);
    private int sendFrameCount;
    private int rcvFrameCount;
    private final EventListeners<KNXListener> listeners = new EventListeners();

    public FT12Connection(int portNumber) throws KNXException, InterruptedException {
        this(LibraryAdapter.defaultPortPrefixes()[0] + portNumber, 19200, false);
    }

    public FT12Connection(String portId) throws KNXException, InterruptedException {
        this(portId, 19200, false);
    }

    public FT12Connection(String portId, int baudrate) throws KNXException, InterruptedException {
        this(portId, baudrate, false);
    }

    public FT12Connection(String portId, int baudrate, boolean cemi) throws KNXException, InterruptedException {
        this(LibraryAdapter.open(LogService.getLogger("calimero.serial.ft12:" + portId), portId, baudrate, FT12Connection.idleTimeout(baudrate)), portId, cemi);
    }

    FT12Connection(LibraryAdapter connection, String portId, boolean cemi) throws KNXException, InterruptedException {
        this.logger = LogService.getLogger("calimero.serial.ft12:" + portId);
        this.adapter = connection;
        this.port = portId;
        this.exchangeTimeout = FT12Connection.exchangeTimeout(this.adapter.getBaudRate());
        this.cemi = cemi;
        this.is = this.adapter.getInputStream();
        this.os = this.adapter.getOutputStream();
        this.receiver = new Receiver();
        this.receiver.start();
        this.state = 0;
        this.reset();
    }

    public static String[] getPortIdentifiers() {
        return (String[])LibraryAdapter.getPortIdentifiers().toArray(String[]::new);
    }

    public void addConnectionListener(KNXListener l) {
        this.listeners.add(l);
    }

    public void removeConnectionListener(KNXListener l) {
        this.listeners.remove(l);
    }

    public final String getPortID() {
        return this.state == 1 ? "" : this.port;
    }

    public void setBaudrate(int baud) {
        this.adapter.setBaudRate(baud);
    }

    public final int getBaudRate() {
        return this.adapter.getBaudRate();
    }

    public final int getState() {
        return this.state;
    }

    public void send(byte[] frame, boolean blocking) throws KNXTimeoutException, KNXPortClosedException, InterruptedException {
        this.sendLock.lockInterruptibly();
        try {
            while (this.state != 0) {
                if (this.state == 1) {
                    throw new KNXPortClosedException("waiting to send", this.port);
                }
                this.readyToSend.await();
            }
            boolean ack = false;
            boolean con = false;
            for (int i = 0; i <= 3; ++i) {
                this.logger.trace("sending FT1.2 frame, {}blocking, attempt {}", (Object)(blocking ? "" : "non-"), (Object)(i + 1));
                boolean isLDataReq = (frame[0] & 0xFF) == 17;
                this.keepForCon = isLDataReq ? this.ldataDestination(frame) : NoLDataAddress;
                this.sendData(frame);
                if (!blocking) {
                    ack = true;
                    con = true;
                    break;
                }
                if (!this.waitForAck()) continue;
                ack = true;
                if (isLDataReq && !this.waitForCon()) break;
                con = true;
                break;
            }
            this.sendFrameCount ^= 0x20;
            if (!ack) {
                throw new KNXAckTimeoutException("no acknowledge reply received");
            }
            if (!con) {
                throw new KNXTimeoutException("no confirmation reply received for " + this.keepForCon);
            }
        }
        catch (InterruptedIOException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (IOException e) {
            this.close(false, e.getMessage());
            throw new KNXPortClosedException(e.getMessage(), this.port, e);
        }
        finally {
            if (this.state == 2 || this.state == 3) {
                this.state = 0;
            }
            this.keepForCon = NoLDataAddress;
            this.readyToSend.signal();
            this.sendLock.unlock();
        }
    }

    @Override
    public void close() {
        this.close(true, "client request");
    }

    private void close(boolean user, String reason) {
        if (this.state == 1) {
            return;
        }
        this.logger.info("close serial port " + this.port + " - " + reason);
        this.sendLock.lock();
        try {
            this.state = 1;
            this.ack.signalAll();
            this.con.signalAll();
            this.readyToSend.signalAll();
        }
        finally {
            this.sendLock.unlock();
        }
        if (this.receiver != null) {
            this.receiver.quit();
        }
        try {
            this.is.close();
            this.os.close();
            this.adapter.close();
        }
        catch (Exception e) {
            this.logger.warn("failed to close all serial I/O resources", (Throwable)e);
        }
        this.fireConnectionClosed(user, reason);
    }

    private void reset() throws InterruptedException, KNXPortClosedException, KNXAckTimeoutException {
        this.sendLock.lockInterruptibly();
        try {
            this.sendReset();
        }
        catch (KNXAckTimeoutException e) {
            this.close(false, "acknowledgment timeout on sending reset");
            throw e;
        }
        finally {
            this.sendLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendReset() throws KNXPortClosedException, KNXAckTimeoutException {
        try {
            byte[] reset = new byte[]{16, 64, 64, 22};
            int i = 0;
            while (i <= 3) {
                this.logger.trace("send reset to BCU");
                this.state = 2;
                this.os.write(reset);
                this.os.flush();
                if (this.waitForAck(Duration.ofMillis(150L))) {
                    this.state = 0;
                    return;
                }
                ++i;
            }
            throw new KNXAckTimeoutException("resetting BCU failed (no acknowledge reply received)");
        }
        catch (InterruptedException e) {
            this.close(true, "send reset interruption, " + e.getMessage());
            Thread.currentThread().interrupt();
            throw new KNXPortClosedException("interrupted during send reset", this.port);
        }
        catch (IOException e) {
            this.close(false, e.getMessage());
            throw new KNXPortClosedException("I/O error", this.port, e);
        }
        finally {
            this.sendFrameCount = 32;
            this.rcvFrameCount = 32;
        }
    }

    private void sendData(byte[] data) throws IOException, KNXPortClosedException {
        if (data.length > 255) {
            throw new KNXIllegalArgumentException("data length > 255 bytes");
        }
        if (this.state == 1) {
            throw new KNXPortClosedException("connection closed", this.port);
        }
        byte[] buf = new byte[data.length + 7];
        int i = 0;
        buf[i++] = 104;
        buf[i++] = (byte)(data.length + 1);
        buf[i++] = (byte)(data.length + 1);
        buf[i++] = 104;
        buf[i++] = (byte)(0x40 | this.sendFrameCount | 0x10 | 3);
        for (int k = 0; k < data.length; ++k) {
            buf[i++] = data[k];
        }
        buf[i++] = FT12Connection.checksum(buf, 4, data.length + 1);
        buf[i++] = 22;
        this.state = 2;
        this.os.write(buf);
        this.os.flush();
    }

    private void sendAck() throws IOException {
        this.os.write(229);
        this.os.flush();
    }

    private boolean waitForAck() throws InterruptedException {
        return this.waitForAck(Duration.ofMillis(this.exchangeTimeout));
    }

    private boolean waitForAck(Duration timeout) throws InterruptedException {
        long remaining = timeout.toNanos();
        while (this.state == 2 && remaining > 0L) {
            remaining = this.ack.awaitNanos(remaining);
        }
        return remaining > 0L;
    }

    private boolean waitForCon() throws InterruptedException {
        long remaining = Duration.ofMillis(300L).toNanos();
        while (this.state == 3 && remaining > 0L) {
            remaining = this.con.awaitNanos(remaining);
        }
        return remaining > 0L;
    }

    private void fireConnectionClosed(boolean user, String reason) {
        int initiator = user ? 0 : 3;
        CloseEvent ce = new CloseEvent(this, initiator, reason);
        this.listeners.fire(l -> l.connectionClosed(ce));
    }

    private static int exchangeTimeout(int baudrate) {
        int xTolerance = 5;
        return Math.round(512000.0f / (float)baudrate) + 5;
    }

    private static int idleTimeout(int baudrate) {
        int iTolerance = 15;
        return Math.round(33000.0f / (float)baudrate) + 15;
    }

    private static byte checksum(byte[] data, int offset, int length) {
        byte chk = 0;
        for (int i = 0; i < length; ++i) {
            chk = (byte)(chk + data[offset + i]);
        }
        return chk;
    }

    private KNXAddress ldataDestination(byte[] ldata) {
        if (ldata.length >= 8) {
            int dstOffset = this.cemi ? 6 : 4;
            int addressTypeOffset = this.cemi ? 3 : 6;
            int addr = (ldata[dstOffset] & 0xFF) << 8 | ldata[dstOffset + 1] & 0xFF;
            boolean group = (ldata[addressTypeOffset] & 0x80) == 128;
            return group ? new GroupAddress(addr) : new IndividualAddress(addr);
        }
        return NoLDataAddress;
    }

    private final class Receiver
    extends Thread {
        private volatile boolean quit;
        private int lastChecksum;

        Receiver() {
            super("Calimero FT1.2 receiver");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block6: {
                try {
                    while (!this.quit) {
                        int c = FT12Connection.this.is.read();
                        if (c <= -1) continue;
                        if (c == 229) {
                            this.signalAck();
                            continue;
                        }
                        if (c == 104) {
                            this.readFrame();
                            continue;
                        }
                        if (c == 16) {
                            this.readShortFrame();
                            continue;
                        }
                        FT12Connection.this.logger.trace("received unexpected start byte 0x" + Integer.toHexString(c) + " - ignored");
                    }
                }
                catch (IOException | InterruptedException e) {
                    if (this.quit) break block6;
                    FT12Connection.this.close(false, "receiver communication failure");
                }
            }
        }

        void quit() {
            this.quit = true;
            this.interrupt();
            if (Receiver.currentThread() == this) {
                return;
            }
            try {
                this.join(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private boolean readShortFrame() throws IOException {
            byte[] buf = new byte[3];
            if (FT12Connection.this.is.read(buf) == 3 && buf[0] == buf[1] && (buf[2] & 0xFF) == 22 && (buf[0] & 0x30) == 0) {
                FT12Connection.this.sendAck();
                int fc = buf[0] & 0xF;
                FT12Connection.this.logger.trace("received " + (fc == 0 ? "reset" : (fc == 9 ? "status" : "unknown function code ")));
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean readFrame() throws IOException, InterruptedException {
            int len = FT12Connection.this.is.read();
            byte[] buf = new byte[len + 4];
            int read = FT12Connection.this.is.read(buf);
            if (read == len + 4 && (buf[0] & 0xFF) == len && (buf[1] & 0xFF) == 104 && (buf[len + 3] & 0xFF) == 22) {
                int chk = buf[buf.length - 2];
                if (!this.checkCtrlField(buf[2] & 0xFF, (byte)chk)) {
                    return false;
                }
                if (FT12Connection.checksum(buf, 2, len) != chk) {
                    FT12Connection.this.logger.warn("invalid checksum in frame " + DataUnitBuilder.toHex(buf, " "));
                    return false;
                }
                FT12Connection.this.sendAck();
                this.lastChecksum = chk;
                FT12Connection.this.rcvFrameCount ^= 0x20;
                byte[] ldata = new byte[len - 1];
                int i = 0;
                while (true) {
                    if (i >= ldata.length) {
                        this.fireFrameReceived(ldata);
                        this.checkLDataCon(ldata);
                        return true;
                    }
                    ldata[i] = buf[3 + i];
                    ++i;
                }
            }
            FT12Connection.this.logger.warn("invalid frame, discarded " + read + " bytes: " + DataUnitBuilder.toHex(buf, " "));
            return false;
        }

        private boolean checkCtrlField(int c, byte chk) {
            if ((c & 0xC0) != 192) {
                FT12Connection.this.logger.warn("unexpected ctrl field 0x" + Integer.toHexString(c));
                return false;
            }
            if ((c & 0x10) == 16 && (c & 0x20) != FT12Connection.this.rcvFrameCount) {
                if (chk == this.lastChecksum) {
                    FT12Connection.this.logger.trace("framecount and checksum indicate a repeated frame - ignored");
                    return false;
                }
                FT12Connection.this.logger.warn("toggle frame count bit");
                FT12Connection.this.rcvFrameCount ^= 0x20;
            }
            return (c & 0xF) != 3 || (c & 0x10) != 0;
        }

        private void checkLDataCon(byte[] ldata) throws InterruptedException {
            KNXAddress dst;
            boolean posCon;
            int emi1LDataCon = 78;
            int svc = ldata[0] & 0xFF;
            boolean isLDataCon = svc == 46 || svc == 78;
            int ctrl1Offset = FT12Connection.this.cemi ? 2 : 1;
            boolean bl = posCon = (ldata[ctrl1Offset] & 1) == 0;
            if (isLDataCon && posCon && (dst = FT12Connection.this.ldataDestination(ldata)).equals(FT12Connection.this.keepForCon)) {
                this.signalCon();
            }
        }

        private void signalAck() throws InterruptedException {
            FT12Connection.this.sendLock.lockInterruptibly();
            try {
                if (FT12Connection.this.state == 2) {
                    FT12Connection.this.state = 3;
                    FT12Connection.this.ack.signal();
                }
            }
            finally {
                FT12Connection.this.sendLock.unlock();
            }
        }

        private void signalCon() throws InterruptedException {
            FT12Connection.this.sendLock.lockInterruptibly();
            try {
                if (FT12Connection.this.state == 3) {
                    FT12Connection.this.state = 0;
                    FT12Connection.this.con.signal();
                }
            }
            finally {
                FT12Connection.this.sendLock.unlock();
            }
        }

        private void fireFrameReceived(byte[] frame) {
            FrameEvent fe = new FrameEvent((Object)this, frame);
            FT12Connection.this.listeners.fire(l -> l.frameReceived(fe));
        }
    }
}

