/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.serial;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.serial.SerialComAdapter;

public abstract class LibraryAdapter
implements Closeable {
    protected final Logger logger;

    public static List<String> getPortIdentifiers() {
        if (SerialComAdapter.isAvailable()) {
            ArrayList<String> ports = new ArrayList<String>();
            Arrays.asList(LibraryAdapter.defaultPortPrefixes()).forEach(p -> IntStream.range(0, 20).filter(i -> SerialComAdapter.portExists(p + i)).forEach(i -> ports.add(p + i)));
            return ports;
        }
        try {
            Class<?> c = Class.forName("tuwien.auto.calimero.serial.RxtxAdapter");
            List ports = (List)c.getMethod("getPortIdentifiers", new Class[0]).invoke(null, new Object[0]);
            return ports;
        }
        catch (Exception | NoClassDefFoundError throwable) {
            return Collections.emptyList();
        }
    }

    static String[] defaultPortPrefixes() {
        String[] stringArray;
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "\\\\.\\COM";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "/dev/ttyS";
            stringArray3[1] = "/dev/ttyACM";
            stringArray3[2] = "/dev/ttyUSB";
            stringArray = stringArray3;
            stringArray3[3] = "/dev/ttyAMA";
        }
        return stringArray;
    }

    public static LibraryAdapter open(Logger logger, String portId, int baudrate, int idleTimeout) throws KNXException {
        Throwable t = null;
        if (SerialComAdapter.isAvailable()) {
            logger.debug("open Calimero native serial port connection (serialcom) for {}", (Object)portId);
            SerialComAdapter conn = null;
            try {
                conn = new SerialComAdapter(logger, portId);
                conn.setBaudRate(baudrate);
                conn.setTimeouts(new SerialComAdapter.Timeouts(idleTimeout, 0, 5, 0, 0));
                conn.setParity(2);
                conn.setControl(4, 1);
                conn.setControl(3, 8);
                conn.setControl(5, 0);
                logger.debug("setup serial port: baudrate " + conn.getBaudRate() + ", even parity, " + conn.getControl(3) + " databits, " + conn.getControl(4) + " stopbits, timeouts: " + conn.getTimeouts());
                return conn;
            }
            catch (IOException e) {
                if (conn != null) {
                    conn.close();
                }
                t = e;
            }
        }
        try {
            Class<?> c = Class.forName("tuwien.auto.calimero.serial.RxtxAdapter");
            logger.debug("using rxtx library for serial port access");
            Class<LibraryAdapter> adapter = LibraryAdapter.class;
            return (LibraryAdapter)adapter.cast(c.getConstructors()[0].newInstance(logger, portId, baudrate));
        }
        catch (ClassNotFoundException e) {
            logger.warn("no rxtx library adapter found");
        }
        catch (Exception | NoClassDefFoundError e) {
            Throwable throwable = t = e instanceof InvocationTargetException ? e.getCause() : e;
        }
        if (t instanceof KNXException) {
            throw (KNXException)t;
        }
        if (t != null) {
            throw new KNXException("failed to open serial port " + portId, t);
        }
        throw new KNXException("no serial adapter available to open " + portId);
    }

    protected LibraryAdapter(Logger logService) {
        this.logger = logService;
    }

    public abstract OutputStream getOutputStream();

    public abstract InputStream getInputStream();

    public void setBaudRate(int baudrate) {
        try {
            this.invoke(this, "setBaudRate", new Object[]{baudrate});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getBaudRate() {
        try {
            return (Integer)this.invoke(this, "getBaudRate", new Object[0]);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public abstract void close();

    protected Object invoke(Object obj, String method, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] c = new Class[args.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = args[i].getClass();
            if (c[i] != Integer.class) continue;
            c[i] = Integer.TYPE;
        }
        try {
            if (obj instanceof Class) {
                return ((Class)obj).getMethod(method, c).invoke(null, args);
            }
            return obj.getClass().getMethod(method, c).invoke(obj, args);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("illegal argument on invoking " + obj.getClass().getName() + "." + method + ": " + e.getMessage());
        }
    }
}

