/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.serial.LibraryAdapter;
import tuwien.auto.calimero.serial.PortInputStream;
import tuwien.auto.calimero.serial.PortOutputStream;

class SerialComAdapter
extends LibraryAdapter {
    static final int BAUDRATE = 1;
    static final int PARITY = 2;
    static final int DATABITS = 3;
    static final int STOPBITS = 4;
    static final int FLOWCTRL = 5;
    static final int FLOWCTRL_NONE = 0;
    static final int FLOWCTRL_CTSRTS = 1;
    static final int PARITY_NONE = 0;
    static final int PARITY_ODD = 1;
    static final int PARITY_EVEN = 2;
    static final int PARITY_MARK = 3;
    static final int ONE_STOPBIT = 1;
    static final int TWO_STOPBITS = 2;
    static final int AVAILABLE_INPUT_STATUS = 2;
    private static final int ERROR_STATUS = 1;
    private static final int LINE_STATUS = 3;
    private static final int EVENT_RXCHAR = 1;
    private static final int EVENT_RXFLAG = 2;
    private static final int EVENT_TXEMPTY = 4;
    private static final int EVENT_CTS = 8;
    private static final int EVENT_DSR = 16;
    private static final int EVENT_RLSD = 32;
    private static final int EVENT_BREAK = 64;
    private static final int EVENT_ERR = 128;
    private static final int EVENT_RING = 256;
    private static final boolean loaded;
    private static final int INVALID_HANDLE = -1;
    private long fd = -1L;

    SerialComAdapter(Logger logger, String portId) throws IOException {
        super(logger);
        if (portId == null) {
            throw new NullPointerException("no port id");
        }
        if (!loaded) {
            throw new IOException("no serial I/O communication support");
        }
        this.open(portId);
    }

    static boolean isAvailable() {
        return loaded;
    }

    static native boolean portExists(String var0);

    native int writeBytes(byte[] var1, int var2, int var3) throws IOException;

    native int write(int var1) throws IOException;

    native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    native int read() throws IOException;

    native void setTimeouts(Timeouts var1) throws IOException;

    native Timeouts getTimeouts() throws IOException;

    @Override
    public final void setBaudRate(int baudrate) {
        try {
            this.setControl(1, baudrate);
        }
        catch (IOException e) {
            this.logger.error("set baudrate failed", (Throwable)e);
        }
    }

    @Override
    public final int getBaudRate() {
        try {
            return this.getControl(1);
        }
        catch (IOException e) {
            this.logger.error("get baudrate failed", (Throwable)e);
            return 0;
        }
    }

    final int setParity(int parity) {
        try {
            return this.setControl(2, parity);
        }
        catch (IOException e) {
            this.logger.error("set parity failed", (Throwable)e);
            return 0;
        }
    }

    final int getParity() {
        try {
            return this.getControl(2);
        }
        catch (IOException e) {
            this.logger.error("get parity failed", (Throwable)e);
            return 0;
        }
    }

    native int getStatus(int var1);

    native int setControl(int var1, int var2) throws IOException;

    native int getControl(int var1) throws IOException;

    @Override
    public InputStream getInputStream() {
        if (this.fd == -1L) {
            return null;
        }
        return new PortInputStream(this);
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.fd == -1L) {
            return null;
        }
        return new PortOutputStream(this);
    }

    @Override
    public final void close() {
        try {
            if (this.fd != -1L) {
                this.close0();
            }
        }
        catch (IOException e) {
            this.logger.error("closing serial port", (Throwable)e);
        }
        this.fd = -1L;
    }

    private native void setEvents(int var1, boolean var2) throws IOException;

    private native int waitEvent() throws IOException;

    private native void open(String var1) throws IOException;

    private native void close0() throws IOException;

    static {
        boolean b = false;
        try {
            LoggerFactory.getLogger((String)"calimero.serial").trace("check Java library path {}", (Object)System.getProperty("java.library.path"));
            System.loadLibrary("serialcom");
            b = true;
        }
        catch (SecurityException | UnsatisfiedLinkError e) {
            LoggerFactory.getLogger((String)"calimero.serial").info(e.getMessage());
        }
        loaded = b;
    }

    static final class Timeouts {
        final int readInterval;
        final int readTotalMultiplier;
        final int readTotalConstant;
        final int writeTotalMultiplier;
        final int writeTotalConstant;

        Timeouts(int readInterval, int readTotalMultiplier, int readTotalConstant, int writeTotalMultiplier, int writeTotalConstant) {
            this.readInterval = readInterval;
            this.readTotalMultiplier = readTotalMultiplier;
            this.readTotalConstant = readTotalConstant;
            this.writeTotalMultiplier = writeTotalMultiplier;
            this.writeTotalConstant = writeTotalConstant;
        }

        public String toString() {
            return "read " + this.readInterval + " read total " + this.readTotalMultiplier + " constant " + this.readTotalConstant + " write total " + this.writeTotalMultiplier + " write constant " + this.writeTotalConstant;
        }
    }
}

