/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.serial.usb;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.serial.usb.HidReportHeader;
import tuwien.auto.calimero.serial.usb.TransferProtocolHeader;

public final class HidReport {
    private static final int maxReportSize = 64;
    private static final int maxDataStartPacket = 52;
    private static final int maxDataPartialPacket = 61;
    private static final int noEmiMsgCode = -1;
    private final HidReportHeader rh;
    private final TransferProtocolHeader tph;
    private final int featureId;
    private final byte[] data;

    public static HidReport createFeatureService(TransferProtocolHeader.BusAccessServerService service, BusAccessServerFeature feature, byte[] frame) {
        return new HidReport(service, feature, frame);
    }

    public static List<HidReport> create(TransferProtocolHeader.KnxTunnelEmi emi, byte[] frame) {
        ArrayList<HidReport> l = new ArrayList<HidReport>();
        EnumSet<HidReportHeader.PacketType> packetType = EnumSet.of(HidReportHeader.PacketType.Start);
        int maxData = 52;
        if (frame.length > maxData) {
            packetType.add(HidReportHeader.PacketType.Partial);
        }
        int offset = 0;
        for (int i = 1; i < 6; ++i) {
            int to = Math.min(frame.length, offset + maxData);
            byte[] range = Arrays.copyOfRange(frame, offset, to);
            offset = to;
            if (offset >= frame.length) {
                packetType.add(HidReportHeader.PacketType.End);
            }
            l.add(new HidReport(i, (EnumSet<HidReportHeader.PacketType>)packetType.clone(), TransferProtocolHeader.Protocol.KnxTunnel, emi, -1, range));
            if (offset >= frame.length) break;
            packetType.remove((Object)HidReportHeader.PacketType.Start);
            maxData = 61;
        }
        return l;
    }

    private HidReport(TransferProtocolHeader.ServiceId serviceId, BusAccessServerFeature feature, byte[] frame) {
        this(1, EnumSet.of(HidReportHeader.PacketType.Start, HidReportHeader.PacketType.End), TransferProtocolHeader.Protocol.BusAccessServerFeature, serviceId, feature.id(), frame);
    }

    public HidReport(int sequence, EnumSet<HidReportHeader.PacketType> packetType, TransferProtocolHeader.Protocol protocol, TransferProtocolHeader.ServiceId serviceId, int featureId, byte[] data) {
        int maxData;
        int packetLength = data.length;
        if (protocol == TransferProtocolHeader.Protocol.BusAccessServerFeature) {
            if (featureId < 1 || featureId > 5) {
                throw new KNXIllegalArgumentException("unsupported device service feature ID " + featureId);
            }
            this.featureId = featureId;
            ++packetLength;
        } else {
            this.featureId = -1;
        }
        if (packetType.contains((Object)HidReportHeader.PacketType.Start)) {
            this.tph = new TransferProtocolHeader(packetLength, protocol, serviceId);
            packetLength += this.tph.getStructLength();
            maxData = 52;
        } else {
            this.tph = null;
            maxData = 61;
        }
        if (data.length > maxData) {
            throw new KNXIllegalArgumentException("frame too large: " + data.length + " > " + maxData);
        }
        this.rh = new HidReportHeader(sequence, packetType, packetLength);
        this.data = (byte[])data.clone();
    }

    public HidReport(byte[] frame) throws KNXFormatException {
        if (frame.length > 64) {
            throw new KNXFormatException("unsupported KNX USB frame of length " + frame.length + " > 64");
        }
        this.rh = new HidReportHeader(frame, 0);
        int offset = this.rh.getStructLength();
        if (this.rh.getPacketType().contains((Object)HidReportHeader.PacketType.Start)) {
            this.tph = new TransferProtocolHeader(frame, offset);
            this.featureId = frame[offset += this.tph.getStructLength()] & 0xFF;
            if (this.tph.getProtocol() == TransferProtocolHeader.Protocol.BusAccessServerFeature) {
                if (this.featureId < 1 || this.featureId > 5) {
                    throw new KNXFormatException("unsupported device service feature ID " + this.featureId);
                }
                ++offset;
            }
        } else {
            this.tph = null;
            this.featureId = -1;
        }
        int datalength = this.rh.getDataLength() + this.rh.getStructLength();
        this.data = Arrays.copyOfRange(frame, offset, datalength);
        if (datalength > frame.length) {
            throw new KNXFormatException("HID class report data length " + datalength + " exceeds frame length " + frame.length);
        }
        EnumSet<HidReportHeader.PacketType> type = EnumSet.of(HidReportHeader.PacketType.Start, HidReportHeader.PacketType.End);
        if (this.rh.getPacketType().equals(type)) {
            int idOffset;
            int bodylength = this.tph.getBodyLength();
            int n = idOffset = this.tph.getProtocol() == TransferProtocolHeader.Protocol.BusAccessServerFeature ? 1 : 0;
            if (bodylength != idOffset + this.data.length) {
                throw new KNXFormatException("unexpected KNX USB protocol body length " + this.data.length + ", expected " + bodylength);
            }
        }
    }

    public HidReportHeader getReportHeader() {
        return this.rh;
    }

    public TransferProtocolHeader getTransferProtocolHeader() {
        return this.tph;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    public String toString() {
        Object s;
        String hex = DataUnitBuilder.toHex(this.data, " ");
        Object object = s = hex.isEmpty() ? "" : ": " + hex;
        if (this.tph == null) {
            return this.rh + (String)s;
        }
        Object feat = this.tph.getProtocol() == TransferProtocolHeader.Protocol.BusAccessServerFeature ? this.getFeatureId() : "";
        return this.rh + " " + this.tph + " " + feat + (String)s;
    }

    BusAccessServerFeature getFeatureId() {
        return BusAccessServerFeature.values()[this.featureId - 1];
    }

    byte[] toByteArray() {
        ByteArrayOutputStream os = new ByteArrayOutputStream(64);
        this.rh.toByteArray(os);
        if (this.tph != null) {
            this.tph.toByteArray(os);
            if (this.tph.getProtocol() == TransferProtocolHeader.Protocol.BusAccessServerFeature) {
                os.write(this.featureId);
            }
        }
        os.write(this.data, 0, this.data.length);
        while (os.size() < 64) {
            os.write(0);
        }
        return os.toByteArray();
    }

    static enum BusAccessServerFeature {
        SupportedEmiTypes,
        DeviceDescriptorType0,
        ConnectionStatus,
        Manufacturer,
        ActiveEmiType;


        int id() {
            return this.ordinal() + 1;
        }
    }
}

