/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.serial.usb;

import java.io.ByteArrayOutputStream;
import java.util.EnumSet;
import java.util.Iterator;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;

final class HidReportHeader {
    private static final int maxFrameSize = 64;
    private static final int headerSize = 3;
    private static final int reportId = 1;
    private final int seqNo;
    private final EnumSet<PacketType> type;
    private final int length;

    HidReportHeader(int sequence, EnumSet<PacketType> type, int dataLength) {
        this.seqNo = HidReportHeader.validateSequence(sequence);
        this.type = HidReportHeader.validatePacketType(type);
        this.length = HidReportHeader.validateDataLength(dataLength);
    }

    HidReportHeader(byte[] frame, int offset) throws KNXFormatException {
        if (frame.length - offset < 3) {
            throw new KNXFormatException("frame to short to fit HID report header");
        }
        int id = frame[offset] & 0xFF;
        if (id != 1) {
            throw new KNXFormatException("not a KNX USB report (wrong report ID " + id + ")");
        }
        int info = frame[offset + 1] & 0xFF;
        try {
            this.seqNo = HidReportHeader.validateSequence(info >> 4);
            this.type = HidReportHeader.validatePacketType(HidReportHeader.parseType(info & 0xF));
            this.length = HidReportHeader.validateDataLength(frame[offset + 2] & 0xFF);
        }
        catch (KNXIllegalArgumentException e) {
            throw new KNXFormatException(e.getMessage());
        }
    }

    public int getReportId() {
        return 1;
    }

    public int getSeqNumber() {
        return this.seqNo;
    }

    public EnumSet<PacketType> getPacketType() {
        return this.type;
    }

    public int getDataLength() {
        return this.length;
    }

    public String toString() {
        return "Report ID 1 seq " + this.seqNo + " " + this.type + " data length " + this.length;
    }

    int getStructLength() {
        return 3;
    }

    byte[] toByteArray(ByteArrayOutputStream os) {
        os.write(1);
        int info = this.seqNo << 4;
        for (PacketType t : this.type) {
            info += t.id;
        }
        os.write(info);
        os.write(this.length);
        return os.toByteArray();
    }

    private static int validateSequence(int seq) {
        if (seq < 1 || seq > 5) {
            throw new KNXIllegalArgumentException("sequence number " + seq + " not in [1..5]");
        }
        return seq;
    }

    private static EnumSet<PacketType> validatePacketType(EnumSet<PacketType> t) {
        if (t.size() > 2) {
            throw new KNXIllegalArgumentException("invalid packet type " + t);
        }
        return t;
    }

    private static EnumSet<PacketType> parseType(int t) {
        EnumSet<PacketType> set = EnumSet.allOf(PacketType.class);
        Iterator i = set.iterator();
        while (i.hasNext()) {
            if ((t & ((PacketType)((Object)i.next())).id()) != 0) continue;
            i.remove();
        }
        return set;
    }

    private static int validateDataLength(int l) {
        if (l < 0 || l > 61) {
            throw new KNXIllegalArgumentException("data length " + l + " not in [0..61]");
        }
        return l;
    }

    public static enum PacketType {
        Start(1),
        End(2),
        Partial(4);

        private final int id;

        private PacketType(int id) {
            this.id = id;
        }

        int id() {
            return this.id;
        }
    }
}

