/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.serial.usb;

import java.io.ByteArrayOutputStream;
import java.util.EnumSet;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;

public final class TransferProtocolHeader {
    private static final int version = 0;
    private static final int headerSize = 8;
    private final int length;
    private final Protocol protocol;
    private final ServiceId svc;
    private final int manufacturer;

    public TransferProtocolHeader(int bodyLength, Protocol protocol, ServiceId service) {
        if (bodyLength < 0 || bodyLength > 65535) {
            throw new KNXIllegalArgumentException("body length not in range [0..0xffff]: " + bodyLength);
        }
        this.length = bodyLength;
        this.protocol = protocol;
        this.svc = service;
        this.manufacturer = 0;
    }

    public TransferProtocolHeader(byte[] frame, int offset) throws KNXFormatException {
        EnumSet<Enum> set;
        int size;
        int ver;
        if (frame.length - offset < 8) {
            throw new KNXFormatException("frame to short to fit transfer protocol header");
        }
        int i = offset;
        if ((ver = frame[i++] & 0xFF) != 0) {
            throw new KNXFormatException("invalid transfer protocol header version " + ver + " != 0");
        }
        if ((size = frame[i++] & 0xFF) != 8) {
            throw new KNXFormatException("unsupported transfer protocol header size " + size + " != 8");
        }
        int lhi = (frame[i++] & 0xFF) << 8;
        this.length = lhi | frame[i++] & 0xFF;
        int p = frame[i++] & 0xFF;
        int id = frame[i++] & 0xFF;
        if (p == Protocol.KnxTunnel.id()) {
            this.protocol = Protocol.KnxTunnel;
            set = EnumSet.allOf(KnxTunnelEmi.class);
        } else if (p == Protocol.BusAccessServerFeature.id()) {
            this.protocol = Protocol.BusAccessServerFeature;
            set = EnumSet.allOf(BusAccessServerService.class);
        } else {
            throw new KNXFormatException("unsupported protocol ID", p);
        }
        set.removeIf(s -> ((ServiceId)((Object)s)).id() != id);
        if (set.isEmpty()) {
            throw new KNXFormatException("unsupported service/EMI ID", id);
        }
        this.svc = (ServiceId)set.iterator().next();
        int mhi = (frame[i++] & 0xFF) << 8;
        this.manufacturer = mhi | frame[i++] & 0xFF;
    }

    public int getVersion() {
        return 0;
    }

    public int getBodyLength() {
        return this.length;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public ServiceId getService() {
        return this.svc;
    }

    public String toString() {
        String mf = this.manufacturer != 0 ? "manufacturer=" + this.manufacturer + " " : "";
        return mf + this.protocol + " " + this.svc;
    }

    int getStructLength() {
        return 8;
    }

    byte[] toByteArray(ByteArrayOutputStream os) {
        os.write(0);
        os.write(8);
        os.write(this.length >>> 8);
        os.write(this.length);
        os.write(this.getProtocol().id());
        os.write(this.getService().id());
        os.write(this.manufacturer >>> 8);
        os.write(this.manufacturer);
        return os.toByteArray();
    }

    public static enum Protocol {
        KnxTunnel(1),
        BusAccessServerFeature(15);

        final int id;

        private Protocol(int id) {
            this.id = id;
        }

        int id() {
            return this.id;
        }
    }

    @FunctionalInterface
    static interface ServiceId {
        public int id();
    }

    public static enum KnxTunnelEmi implements ServiceId
    {
        Emi1,
        Emi2,
        CEmi;


        @Override
        public int id() {
            return this.ordinal() + 1;
        }

        public String toString() {
            return this == Emi1 ? "EMI1" : (this == Emi2 ? "EMI2" : "cEMI");
        }
    }

    public static enum BusAccessServerService implements ServiceId
    {
        Get,
        Response,
        Set,
        Info;


        @Override
        public int id() {
            return this.ordinal() + 1;
        }
    }
}

