/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.xml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.References;
import tuwien.auto.calimero.xml.StreamLocation;
import tuwien.auto.calimero.xml.XmlReader;

class DefaultXmlReader
implements XmlReader {
    private final Map<String, Object> config = new HashMap<String, Object>();
    private final Reader r;
    private final boolean close;
    private String elemName;
    private List<String> attributeName;
    private List<String> attributeValue;
    private String elemText;
    private boolean emptyTag;
    private final Stack<String> openElems = new Stack();
    private int event;
    private int line;
    private boolean standalone;
    private String version;
    private String encoding;
    private int textStart;
    private int textLength;

    DefaultXmlReader(Reader r, boolean closeReader) {
        this.r = r;
        this.close = closeReader;
        this.event = 7;
        this.line = 0;
    }

    private void setElement(String name) {
        this.elemName = name;
        this.attributeName = new ArrayList<String>();
        this.attributeValue = new ArrayList<String>();
        this.elemText = null;
        this.emptyTag = false;
    }

    private int read() throws KNXMLException {
        while (this.canRead()) {
            if (this.line == 0) {
                this.line = 1;
            }
            this.read('<');
            String str = this.read('>');
            if (str.length() == 0 || this.skipComment(str) || this.skipInstruction(str)) continue;
            StringBuilder buf = new StringBuilder();
            if (this.readCDATASection(str, buf)) {
                this.setElement(this.openElems.peek());
                this.elemText = buf.toString();
                this.event = 4;
                return this.event;
            }
            String name = DefaultXmlReader.splitOnSpace(str = str.trim());
            if (name.charAt(name.length() - 1) == '/') {
                name = name.substring(0, name.length() - 1);
            }
            if (name.charAt(0) == '/') {
                if (!name.substring(1).equals(this.openElems.peek())) {
                    throw new KNXMLException("element end tag does not match start tag", name.substring(1), this.line);
                }
                this.setElement(this.openElems.pop());
                this.event = 2;
                return this.event;
            }
            this.setElement(name);
            this.extractAttributes(str.substring(name.length()));
            if (!this.emptyTag) {
                this.openElems.push(name);
            }
            this.event = 1;
            return this.event;
        }
        if (!this.openElems.empty()) {
            throw new KNXMLException("end of XML input with elements left open");
        }
        this.event = 8;
        return this.event;
    }

    private void complete(String name) throws KNXMLException {
        if (this.emptyTag) {
            return;
        }
        int index = this.openElems.lastIndexOf(name);
        if (index == -1) {
            throw new KNXMLException("no matching element open tag: " + name, this);
        }
        String end = null;
        StringBuilder content = new StringBuilder(50);
        while (this.canRead()) {
            String tag;
            String s = this.read('<');
            boolean current = this.openElems.peek().equals(name);
            if (current && s.length() > 0) {
                content.append(References.replace(s, false));
            }
            if (this.skipComment(end = this.read('>')) || current && this.readCDATASection(end, content)) continue;
            if (end.length() > 0 && end.charAt(0) == '/') {
                tag = end.substring(1).trim();
                if (!tag.equals(this.openElems.peek())) {
                    throw new KNXMLException("element end tag does not match start tag", tag, this.line);
                }
                this.openElems.pop();
                if (!tag.equals(name)) continue;
                this.elemText = content.toString();
                this.event = 2;
                return;
            }
            if (end.length() <= 0 || end.charAt(end.length() - 1) == '/' || (tag = DefaultXmlReader.splitOnSpace(end)).length() <= 0) continue;
            this.openElems.push(tag);
        }
        throw new KNXMLException("end of XML input with elements left open", end, this.line);
    }

    @Override
    public void close() {
        try {
            if (this.close) {
                this.r.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean canRead() {
        try {
            return this.r.ready();
        }
        catch (IOException e) {
            return false;
        }
    }

    private String read(char delimiter) throws KNXMLException {
        StringBuilder buf = new StringBuilder(50);
        try {
            boolean cr = false;
            int c = this.r.read();
            while (c != -1 && c != delimiter) {
                if (c == 10) {
                    ++this.line;
                } else if (cr) {
                    ++this.line;
                    buf.append('\n');
                }
                boolean bl = cr = c == 13;
                if (!cr) {
                    buf.append((char)c);
                }
                c = this.r.read();
            }
        }
        catch (IOException e) {
            throw new KNXMLException(e.getMessage(), buf.toString(), this.line);
        }
        return buf.toString();
    }

    private void extractAttributes(String attributes) {
        int equal;
        String s = attributes.trim();
        if (s.length() > 0 && s.charAt(s.length() - 1) == '/') {
            this.emptyTag = true;
        }
        while (s.length() != 0 && (equal = s.indexOf(61)) != -1 && equal != s.length() - 1) {
            boolean quote;
            String att = s.substring(0, equal).trim();
            if ((s = s.substring(equal + 1).trim()).length() == 0) break;
            boolean bl = quote = s.charAt(0) == '\'' || s.charAt(0) == '\"';
            if (att.length() > 0 && quote) {
                String value = s.substring(1);
                int end = value.indexOf(s.charAt(0));
                if (end >= 0) {
                    value = value.substring(0, end);
                }
                this.attributeName.add(att);
                this.attributeValue.add(References.replace(value, false));
            }
            int i = s.indexOf(quote ? (int)s.charAt(0) : 32, 1);
            s = i == -1 ? "" : s.substring(i + 1);
        }
    }

    private boolean readCDATASection(String s, StringBuilder buf) throws KNXMLException {
        if (!s.startsWith("![CDATA[")) {
            return false;
        }
        buf.append(s.substring(8));
        String cdata = s;
        while (!cdata.endsWith("]]")) {
            buf.append('>');
            cdata = this.read('>');
            buf.append(cdata);
        }
        buf.delete(buf.length() - 2, buf.length());
        return true;
    }

    private boolean skipComment(String s) throws KNXMLException {
        if (s.startsWith("!--")) {
            String comment = s;
            while (this.canRead() && !comment.endsWith("--")) {
                comment = this.read('>');
            }
            return true;
        }
        return false;
    }

    private boolean skipInstruction(String tag) {
        if (tag.charAt(0) == '?' && tag.charAt(tag.length() - 1) == '?') {
            int idx = tag.indexOf("version");
            if (idx != -1) {
                idx = tag.indexOf("=", idx);
                this.version = tag.substring(idx + 2, tag.indexOf("\"", idx + 2));
            }
            if ((idx = tag.indexOf("encoding")) != -1) {
                idx = tag.indexOf("=", idx);
                this.encoding = tag.substring(idx + 2, tag.indexOf("\"", idx + 2));
            }
            return true;
        }
        return false;
    }

    private static String splitOnSpace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isSpaceChar(s.charAt(i))) continue;
            return s.substring(0, i);
        }
        return s;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.config.get(name);
    }

    @Override
    public int next() {
        return this.read();
    }

    @Override
    public void require(int type, String namespaceURI, String localName) {
    }

    @Override
    public String getElementText() {
        this.complete(this.elemName);
        return this.elemText;
    }

    @Override
    public int nextTag() {
        return this.read();
    }

    @Override
    public boolean hasNext() {
        return this.event != 8;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public boolean isWhiteSpace() {
        return false;
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        this.inStartEvent();
        int i = this.attributeName.indexOf(localName);
        if (i != -1) {
            return this.attributeValue.get(i);
        }
        return null;
    }

    private void inStartEvent() {
        if (this.event != 1) {
            throw new IllegalStateException("not at XML start element");
        }
    }

    @Override
    public int getAttributeCount() {
        this.inStartEvent();
        return this.attributeName.size();
    }

    @Override
    public String getAttributeNamespace(int index) {
        this.inStartEvent();
        return null;
    }

    @Override
    public String getAttributeLocalName(int index) {
        this.inStartEvent();
        return this.attributeName.get(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        this.inStartEvent();
        return null;
    }

    @Override
    public String getAttributeType(int index) {
        this.inStartEvent();
        return "CDATA";
    }

    @Override
    public String getAttributeValue(int index) {
        this.inStartEvent();
        return this.attributeValue.get(index);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        this.inStartEvent();
        return this.attributeName.size() > index;
    }

    @Override
    public int getNamespaceCount() {
        return 0;
    }

    @Override
    public String getNamespacePrefix(int index) {
        return null;
    }

    @Override
    public String getNamespaceURI(int index) {
        return null;
    }

    @Override
    public int getEventType() {
        return this.event;
    }

    @Override
    public String getText() {
        return new String(this.getTextCharacters());
    }

    @Override
    public char[] getTextCharacters() {
        this.complete(this.elemName);
        return this.elemText.toCharArray();
    }

    @Override
    public int getTextStart() {
        return this.textStart;
    }

    @Override
    public int getTextLength() {
        return this.textLength;
    }

    @Override
    public String getEncoding() {
        if (this.r instanceof InputStreamReader) {
            InputStreamReader isr = (InputStreamReader)this.r;
            return isr.getEncoding();
        }
        return this.encoding;
    }

    @Override
    public StreamLocation getLocation() {
        return new StreamLocation(this.line);
    }

    @Override
    public String getLocalName() {
        if (this.event != 1 && this.event != 2 && this.event != 9) {
            throw new IllegalStateException("no XML start/end element or entity reference");
        }
        return this.elemName;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean isStandalone() {
        return this.standalone;
    }

    @Override
    public boolean standaloneSet() {
        return this.config.containsKey("standaloneSet");
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.encoding;
    }

    @Override
    public String getPITarget() {
        return null;
    }

    @Override
    public String getPIData() {
        return null;
    }
}

