/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.xml;

import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.xml.XmlReader;

public class KNXMLException
extends KnxRuntimeException {
    private static final long serialVersionUID = 1L;
    private final String item;
    private final int line;

    public KNXMLException(String s) {
        super(s);
        this.item = null;
        this.line = 0;
    }

    public KNXMLException(String s, Throwable cause) {
        super(s, cause);
        this.item = null;
        this.line = 0;
    }

    public KNXMLException(String s, String badItem, int lineNumber) {
        super(s);
        this.item = badItem;
        this.line = lineNumber;
    }

    public KNXMLException(String s, XmlReader r) {
        super(KNXMLException.createMsg(s, r));
        this.item = r.getLocalName();
        this.line = r.getLocation().getLineNumber();
    }

    private static String createMsg(String s, XmlReader r) {
        StringBuilder sb = new StringBuilder();
        sb.append(s).append(" (line ").append(r.getLocation().getLineNumber());
        sb.append(", element ");
        sb.append(r.getLocalName());
        if (r.getEventType() == 1) {
            for (int i = 0; i < r.getAttributeCount(); ++i) {
                sb.append(" ").append(r.getAttributeLocalName(i)).append("=").append(r.getAttributeValue(i));
            }
        }
        try {
            String t = r.getElementText();
            if (t != null) {
                sb.append(": ").append(t);
            }
        }
        catch (KNXMLException kNXMLException) {
            // empty catch block
        }
        sb.append(")");
        return sb.toString();
    }

    public final String getBadItem() {
        return this.item;
    }

    public final int getLineNumber() {
        return this.line;
    }
}

