/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.xml;

import java.util.HashMap;
import java.util.Map;

final class References {
    private static final String[][] entityTable = new String[][]{{"&amp;", "&#38;", "&#x26;", "&"}, {"&lt;", "&#60;", "&#x3C;", "<"}, {"&gt;", "&#62;", "&#x3E;", ">"}, {"&quot;", "&#34;", "&#x22;", "\""}, {"&apos;", "&#39;", "&#x27;", "'"}};
    private static final Map<String, String> map = new HashMap<String, String>(25);

    private References() {
    }

    static String replaceFromRef(String text) {
        int end;
        StringBuilder mod = new StringBuilder(text.length());
        int pos = 0;
        int oldpos = 0;
        while ((pos = text.indexOf(38, pos)) != -1 && (end = text.indexOf(59, pos + 1)) != -1) {
            String entity = map.get(text.substring(pos, end + 1));
            if (entity != null) {
                mod.append(text.substring(oldpos, pos));
                mod.append(entity);
                oldpos = end + 1;
                pos = end;
            }
            ++pos;
        }
        if (mod.length() != 0) {
            return mod.append(text.substring(oldpos)).toString();
        }
        return text;
    }

    static String replaceWithRef(String text) {
        StringBuilder mod = new StringBuilder((int)(1.5f * (float)text.length()));
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '&') {
                mod.append("&amp;");
                continue;
            }
            if (c == '<') {
                mod.append("&lt;");
                continue;
            }
            if (c == '>') {
                mod.append("&gt;");
                continue;
            }
            if (c == '\"') {
                mod.append("&quot;");
                continue;
            }
            if (c == '\'') {
                mod.append("&apos;");
                continue;
            }
            mod.append(c);
        }
        return mod.toString();
    }

    static String replace(String text, boolean toReference) {
        return toReference ? References.replaceWithRef(text) : References.replaceFromRef(text);
    }

    static {
        for (int i = 0; i < 5; ++i) {
            for (int k = 0; k < 3; ++k) {
                map.put(entityTable[i][k], entityTable[i][3]);
            }
        }
    }
}

