/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.xml;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.StreamLocation;
import tuwien.auto.calimero.xml.XmlReader;

public final class XmlStreamReaderProxy
implements XmlReader {
    final XMLStreamReader r;
    private final Closeable close;

    public static XmlStreamReaderProxy createXmlReader(InputStream is, Closeable onClose) throws XMLStreamException, FactoryConfigurationError {
        return new XmlStreamReaderProxy(XMLInputFactory.newInstance().createXMLStreamReader(is), onClose);
    }

    public static XmlStreamReaderProxy createXmlReader(Reader reader) throws XMLStreamException, FactoryConfigurationError {
        return new XmlStreamReaderProxy(XMLInputFactory.newInstance().createXMLStreamReader(reader), () -> {});
    }

    public XmlStreamReaderProxy(XMLStreamReader reader, Closeable onClose) {
        this.r = reader;
        this.close = onClose;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.r.getProperty(name);
    }

    @Override
    public int next() {
        try {
            return this.r.next();
        }
        catch (XMLStreamException e) {
            throw XmlStreamReaderProxy.wrapped(e);
        }
    }

    @Override
    public void require(int type, String namespaceURI, String localName) {
        try {
            this.r.require(type, namespaceURI, localName);
        }
        catch (XMLStreamException e) {
            throw XmlStreamReaderProxy.wrapped(e);
        }
    }

    @Override
    public String getElementText() {
        try {
            return this.r.getElementText();
        }
        catch (XMLStreamException e) {
            throw XmlStreamReaderProxy.wrapped(e);
        }
    }

    @Override
    public int nextTag() {
        try {
            return this.r.nextTag();
        }
        catch (XMLStreamException e) {
            throw XmlStreamReaderProxy.wrapped(e);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.r.hasNext();
        }
        catch (XMLStreamException e) {
            throw XmlStreamReaderProxy.wrapped(e);
        }
    }

    @Override
    public void close() {
        try {
            this.r.close();
            this.close.close();
        }
        catch (IOException | XMLStreamException exception) {
            // empty catch block
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.r.getNamespaceURI(prefix);
    }

    @Override
    public boolean isWhiteSpace() {
        return this.r.isWhiteSpace();
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this.r.getAttributeValue(namespaceURI, localName);
    }

    @Override
    public int getAttributeCount() {
        return this.r.getAttributeCount();
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.r.getAttributeNamespace(index);
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.r.getAttributeLocalName(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.r.getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        return this.r.getAttributeType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        return this.r.getAttributeValue(index);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return this.r.isAttributeSpecified(index);
    }

    @Override
    public int getNamespaceCount() {
        return this.r.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int index) {
        return this.r.getNamespacePrefix(index);
    }

    @Override
    public String getNamespaceURI(int index) {
        return this.r.getNamespaceURI(index);
    }

    @Override
    public int getEventType() {
        return this.r.getEventType();
    }

    @Override
    public String getText() {
        return this.r.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.r.getTextCharacters();
    }

    @Override
    public int getTextStart() {
        return this.r.getTextStart();
    }

    @Override
    public int getTextLength() {
        return this.r.getTextLength();
    }

    @Override
    public String getEncoding() {
        return this.r.getEncoding();
    }

    @Override
    public StreamLocation getLocation() {
        return new StreamLocation(this.r.getLocation().getLineNumber());
    }

    @Override
    public String getLocalName() {
        return this.r.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return this.r.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.r.getPrefix();
    }

    @Override
    public String getVersion() {
        return this.r.getVersion();
    }

    @Override
    public boolean isStandalone() {
        return this.r.isStandalone();
    }

    @Override
    public boolean standaloneSet() {
        return this.r.standaloneSet();
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.r.getCharacterEncodingScheme();
    }

    @Override
    public String getPITarget() {
        return this.r.getPITarget();
    }

    @Override
    public String getPIData() {
        return this.r.getPIData();
    }

    private static KNXMLException wrapped(XMLStreamException e) {
        return new KNXMLException(e.getMessage(), e);
    }
}

