/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import stormpot.BSlotColdFields;
import stormpot.BlazePool;
import stormpot.PoolException;
import stormpot.Poolable;

final class BSlot<T extends Poolable>
extends BSlotColdFields<T> {
    static final int CLAIMED = 1;
    static final int TLR_CLAIMED = 2;
    static final int LIVING = 3;
    static final int DEAD = 4;

    public BSlot(BlockingQueue<BSlot<T>> live, AtomicInteger poisonedSlots) {
        super(4, live, poisonedSlots);
    }

    @Override
    public void release(Poolable obj) {
        if (this.poison == BlazePool.EXPLICIT_EXPIRE_POISON) {
            this.poisonedSlots.getAndIncrement();
        }
        int slotState = this.getClaimState();
        this.lazySet(3);
        if (slotState == 1) {
            this.live.offer(this);
        }
    }

    private int getClaimState() {
        int slotState = this.get();
        if (slotState > 2) {
            throw this.badStateOnTransitionToLive(slotState);
        }
        return slotState;
    }

    private PoolException badStateOnTransitionToLive(int slotState) {
        String state;
        switch (slotState) {
            case 4: {
                state = "DEAD";
                break;
            }
            case 3: {
                state = "LIVING";
                break;
            }
            default: {
                state = "STATE[" + slotState + "]";
            }
        }
        return new PoolException("Slot release from bad state: " + state + ". " + "You most likely called release() twice on the same object.");
    }

    public void claim2live() {
        this.lazySet(3);
    }

    public void claimTlr2live() {
        this.lazySet(3);
    }

    public void dead2live() {
        this.lazySet(3);
    }

    public void claim2dead() {
        this.lazySet(4);
    }

    public boolean live2claim() {
        return this.compareAndSet(3, 1);
    }

    public boolean live2claimTlr() {
        return this.compareAndSet(3, 2);
    }

    public boolean live2dead() {
        return this.compareAndSet(3, 4);
    }

    @Override
    public long getAgeMillis() {
        return System.currentTimeMillis() - this.created;
    }

    @Override
    public long getClaimCount() {
        return this.claims;
    }

    @Override
    public T getPoolable() {
        return (T)this.obj;
    }

    public boolean isDead() {
        return this.get() == 4;
    }

    public boolean isLive() {
        return this.get() == 3;
    }

    public int getState() {
        return this.get();
    }

    public void incrementClaims() {
        ++this.claims;
    }

    @Override
    public long getStamp() {
        return this.stamp;
    }

    @Override
    public void setStamp(long stamp) {
        this.stamp = stamp;
    }
}

