/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import stormpot.BAllocThread;
import stormpot.BSlot;
import stormpot.Completion;
import stormpot.Config;
import stormpot.DisregardBPile;
import stormpot.Expiration;
import stormpot.LifecycledResizablePool;
import stormpot.ManagedPool;
import stormpot.MetricsRecorder;
import stormpot.PoolException;
import stormpot.Poolable;
import stormpot.QueueFactory;
import stormpot.Timeout;

public class BlazePool<T extends Poolable>
implements LifecycledResizablePool<T>,
ManagedPool {
    private static final Exception SHUTDOWN_POISON = new Exception();
    static final Exception EXPLICIT_EXPIRE_POISON = new Exception();
    private final BlockingQueue<BSlot<T>> live = QueueFactory.createUnboundedBlockingQueue();
    private final DisregardBPile<T> disregardPile = new DisregardBPile<T>(this.live);
    private final BAllocThread<T> allocator;
    private final ThreadLocal<BSlot<T>> tlr = new ThreadLocal();
    private final Thread allocatorThread;
    private final Expiration<? super T> deallocRule;
    private final MetricsRecorder metricsRecorder;
    private final BSlot<T> poisonPill = new BSlot<T>(this.live, null);
    private volatile boolean shutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlazePool(Config<T> config) {
        this.poisonPill.poison = SHUTDOWN_POISON;
        Config<T> config2 = config;
        synchronized (config2) {
            config.validate();
            ThreadFactory factory = config.getThreadFactory();
            this.allocator = new BAllocThread<T>(this.live, this.disregardPile, config, this.poisonPill);
            this.allocatorThread = factory.newThread(this.allocator);
            this.deallocRule = config.getExpiration();
            this.metricsRecorder = config.getMetricsRecorder();
        }
        this.allocatorThread.start();
    }

    @Override
    public T claim(Timeout timeout) throws PoolException, InterruptedException {
        if (timeout == null) {
            throw new IllegalArgumentException("Timeout cannot be null");
        }
        BSlot<T> slot = this.tlr.get();
        if (slot != null && slot.live2claimTlr() && !this.isInvalid(slot, true)) {
            slot.incrementClaims();
            return (T)slot.obj;
        }
        return this.slowClaim(timeout);
    }

    private T slowClaim(Timeout timeout) throws PoolException, InterruptedException {
        BSlot<T> slot;
        long deadline = timeout.getDeadline();
        long timeoutLeft = timeout.getTimeoutInBaseUnit();
        TimeUnit baseUnit = timeout.getBaseUnit();
        long maxWaitQuantum = baseUnit.convert(10L, TimeUnit.MILLISECONDS);
        while (true) {
            if ((slot = this.live.poll(Math.min(timeoutLeft, maxWaitQuantum), baseUnit)) == null) {
                if (timeoutLeft <= 0L) {
                    return null;
                }
                timeoutLeft = timeout.getTimeLeft(deadline);
                this.disregardPile.refillQueue();
                continue;
            }
            if (slot.live2claim()) {
                if (!this.isInvalid(slot, false)) break;
                timeoutLeft = timeout.getTimeLeft(deadline);
                continue;
            }
            this.disregardPile.addSlot(slot);
        }
        slot.incrementClaims();
        this.tlr.set(slot);
        return (T)slot.obj;
    }

    private boolean isInvalid(BSlot<T> slot, boolean isTlr) {
        if (this.isUncommonlyInvalid(slot)) {
            return this.handleUncommonInvalidation(slot, isTlr);
        }
        try {
            return this.deallocRule.hasExpired(slot) && this.handleCommonInvalidation(slot, null);
        }
        catch (Throwable ex) {
            return this.handleCommonInvalidation(slot, ex);
        }
    }

    private boolean isUncommonlyInvalid(BSlot<T> slot) {
        return this.shutdown | slot.poison != null;
    }

    private boolean handleUncommonInvalidation(BSlot<T> slot, boolean isTlr) {
        Exception poison = slot.poison;
        if (poison != null) {
            return this.dealWithSlotPoison(slot, isTlr, poison);
        }
        this.kill(slot);
        throw new IllegalStateException("Pool has been shut down");
    }

    private boolean handleCommonInvalidation(BSlot<T> slot, Throwable exception) {
        this.kill(slot);
        if (exception != null) {
            String msg = "Got exception when checking whether an object had expired";
            throw new PoolException(msg, exception);
        }
        return true;
    }

    private boolean dealWithSlotPoison(BSlot<T> slot, boolean isTlr, Exception poison) {
        if (poison == SHUTDOWN_POISON) {
            slot.claim2live();
            this.live.offer(this.poisonPill);
            throw new IllegalStateException("Pool has been shut down");
        }
        this.kill(slot);
        if (isTlr || poison == EXPLICIT_EXPIRE_POISON) {
            return true;
        }
        throw new PoolException("Allocation failed", poison);
    }

    private void kill(BSlot<T> slot) {
        if (slot.getState() == 1) {
            slot.claim2dead();
            this.allocator.offerDeadSlot(slot);
        } else {
            slot.claimTlr2live();
            this.tlr.set(null);
        }
    }

    @Override
    public Completion shutdown() {
        this.shutdown = true;
        return this.allocator.shutdown(this.allocatorThread);
    }

    @Override
    public void setTargetSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Target pool size must be at least 1");
        }
        if (this.shutdown) {
            return;
        }
        this.allocator.setTargetSize(size);
    }

    @Override
    public int getTargetSize() {
        return this.allocator.getTargetSize();
    }

    @Override
    public long getAllocationCount() {
        return this.allocator.getAllocationCount();
    }

    @Override
    public long getFailedAllocationCount() {
        return this.allocator.getFailedAllocationCount();
    }

    @Override
    public boolean isShutDown() {
        return this.shutdown;
    }

    @Override
    public double getObjectLifetimePercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getObjectLifetimePercentile(percentile);
    }

    @Override
    public double getAllocationLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getAllocationLatencyPercentile(percentile);
    }

    @Override
    public double getAllocationFailureLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getAllocationFailureLatencyPercentile(percentile);
    }

    @Override
    public double getReallocationLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getReallocationLatencyPercentile(percentile);
    }

    @Override
    public double getReallocationFailureLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getReallocationFailurePercentile(percentile);
    }

    @Override
    public double getDeallocationLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getDeallocationLatencyPercentile(percentile);
    }

    @Override
    public long getLeakedObjectsCount() {
        return this.allocator.countLeakedObjects();
    }
}

