/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import stormpot.BSlot;
import stormpot.DisregardedBSlot;
import stormpot.Poolable;

final class DisregardBPile<T extends Poolable>
extends AtomicReference<DisregardedBSlot<T>> {
    private static final DisregardedBSlot<Poolable> STACK_END = new DisregardedBSlot(null);
    private final BlockingQueue<BSlot<T>> refillQueue;

    public DisregardBPile(BlockingQueue<BSlot<T>> refillQueue) {
        this.refillQueue = refillQueue;
        this.set(STACK_END);
    }

    public void addSlot(BSlot<T> slot) {
        DisregardedBSlot<T> element = new DisregardedBSlot<T>(slot);
        element.next = this.getAndSet(element);
    }

    public boolean refillQueue() {
        DisregardedBSlot<Poolable> stack = this.getAndSet(STACK_END);
        int count = 0;
        while (stack != STACK_END) {
            DisregardedBSlot next;
            ++count;
            this.refillQueue.offer(stack.slot);
            while ((next = stack.next) == null) {
            }
            stack = next;
        }
        return count > 0;
    }
}

