/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.lang.reflect.Constructor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

final class QueueFactory {
    private static final Factory factory;
    private static final FactoryChoiceReason reason;
    private static final String QUEUE_IMPL = "stormpot.blocking.queue.impl";
    private static final String QUEUE_IMPL_FIRST_CHOICE = "java.util.concurrent.LinkedTransferQueue";
    private static final String QUEUE_IMPL_SECOND_CHOICE;

    QueueFactory() {
    }

    static <T> BlockingQueue<T> createUnboundedBlockingQueue() {
        return factory.createUnboundedBlockingQueue();
    }

    static FactoryChoiceReason getQueueFactoryChoiceReason() {
        return reason;
    }

    static /* synthetic */ String access$000() {
        return QUEUE_IMPL_SECOND_CHOICE;
    }

    static {
        FactoryChoiceReason theReason;
        Factory theFactory;
        block4: {
            QUEUE_IMPL_SECOND_CHOICE = LinkedBlockingQueue.class.getCanonicalName();
            theFactory = null;
            theReason = FactoryChoiceReason.SPECIFIED_CHOICE;
            String queueType = System.getProperty(QUEUE_IMPL);
            if (queueType == null) {
                queueType = QUEUE_IMPL_FIRST_CHOICE;
                theReason = FactoryChoiceReason.DEFAULT_FIRST_CHOICE;
            }
            try {
                Class<?> queueClass = Class.forName(queueType);
                final Constructor<?> constructor = queueClass.getConstructor(new Class[0]);
                BlockingQueue.class.cast(constructor.newInstance(new Object[0]));
                theFactory = new Factory(){

                    @Override
                    public <T> BlockingQueue<T> createUnboundedBlockingQueue() {
                        try {
                            return (BlockingQueue)constructor.newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            Exception exception = new Exception("WARNING: Expected class to be constructable: " + constructor, e);
                            exception.printStackTrace();
                            return new LinkedBlockingQueue();
                        }
                    }
                };
            }
            catch (Exception e) {
                if (theReason != FactoryChoiceReason.SPECIFIED_CHOICE) break block4;
                Exception exception = new Exception("WARNING: The queue implementation specified by the stormpot.blocking.queue.impl system property, specifically " + queueType + ", was determined to be unusable." + " Falling back to the " + QUEUE_IMPL_SECOND_CHOICE + " implementation.", e);
                exception.printStackTrace();
            }
        }
        if (theFactory == null) {
            theFactory = new Factory(){

                @Override
                public <T> BlockingQueue<T> createUnboundedBlockingQueue() {
                    return new LinkedBlockingQueue();
                }
            };
            theReason = theReason == FactoryChoiceReason.DEFAULT_FIRST_CHOICE ? FactoryChoiceReason.DEFAULT_SECOND_CHOICE : FactoryChoiceReason.DEFAULT_FALLBACK;
        }
        factory = theFactory;
        reason = theReason;
    }

    static enum FactoryChoiceReason {
        DEFAULT_FIRST_CHOICE("The java.util.concurrent.LinkedTransferQueue was available on the classpath, and the stormpot.blocking.queue.impl system property did not specify any alternative implementation to use."),
        SPECIFIED_CHOICE("The stormpot.blocking.queue.impl system property specified the queue implementation to use, specifically " + System.getProperty("stormpot.blocking.queue.impl") + "."),
        DEFAULT_SECOND_CHOICE("The java.util.concurrent.LinkedTransferQueue was not available on the classpath, and the stormpot.blocking.queue.impl system property did not specify any alternative implementation to use, so " + QueueFactory.access$000() + " was used" + " as the default fallback."),
        DEFAULT_FALLBACK("");

        private final String description;

        private FactoryChoiceReason(String description) {
            this.description = description;
        }

        public String toString() {
            return super.toString() + "(" + this.description + ")";
        }
    }

    static interface Factory {
        public <T> BlockingQueue<T> createUnboundedBlockingQueue();
    }
}

