/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import stormpot.Completion;
import stormpot.Config;
import stormpot.Expiration;
import stormpot.LifecycledResizablePool;
import stormpot.ManagedPool;
import stormpot.MetricsRecorder;
import stormpot.PoolException;
import stormpot.Poolable;
import stormpot.QAllocThread;
import stormpot.QSlot;
import stormpot.QueueFactory;
import stormpot.Timeout;

public class QueuePool<T extends Poolable>
implements LifecycledResizablePool<T>,
ManagedPool {
    private final BlockingQueue<QSlot<T>> live;
    private final BlockingQueue<QSlot<T>> dead;
    private final QAllocThread<T> allocator;
    private final Thread allocatorThread;
    private final Expiration<? super T> expiration;
    private final MetricsRecorder metricsRecorder;
    private volatile boolean shutdown = false;
    final QSlot<T> poisonPill = new QSlot(null, null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueuePool(Config<T> config) {
        this.live = QueueFactory.createUnboundedBlockingQueue();
        this.dead = QueueFactory.createUnboundedBlockingQueue();
        Config<T> config2 = config;
        synchronized (config2) {
            config.validate();
            ThreadFactory factory = config.getThreadFactory();
            this.metricsRecorder = config.getMetricsRecorder();
            this.expiration = config.getExpiration();
            this.allocator = new QAllocThread<T>(this.live, this.dead, config, this.poisonPill);
            this.allocatorThread = factory.newThread(this.allocator);
        }
        this.allocatorThread.start();
    }

    private void checkForPoison(QSlot<T> slot) {
        if (slot == this.poisonPill) {
            this.live.offer(this.poisonPill);
            throw new IllegalStateException("Pool has been shut down");
        }
        if (slot.poison != null) {
            Exception poison = slot.poison;
            this.dead.offer(slot);
            throw new PoolException("Allocation failed", poison);
        }
        if (this.shutdown) {
            this.dead.offer(slot);
            throw new IllegalStateException("Pool has been shut down");
        }
    }

    private boolean isInvalid(QSlot<T> slot) {
        boolean invalid = true;
        PoolException exception = null;
        boolean expired = slot.expired;
        try {
            invalid = this.expiration.hasExpired(slot);
        }
        catch (Throwable ex) {
            exception = new PoolException("Got exception when checking whether an object had expired", ex);
        }
        if (invalid |= expired) {
            this.dead.offer(slot);
            if (exception != null) {
                throw exception;
            }
        } else {
            slot.claim();
        }
        return invalid;
    }

    @Override
    public T claim(Timeout timeout) throws PoolException, InterruptedException {
        QSlot<T> slot;
        if (timeout == null) {
            throw new IllegalArgumentException("Timeout cannot be null");
        }
        long deadline = timeout.getDeadline();
        do {
            long timeoutLeft;
            if ((slot = this.live.poll(timeoutLeft = timeout.getTimeLeft(deadline), timeout.getBaseUnit())) == null) {
                return null;
            }
            this.checkForPoison(slot);
        } while (this.isInvalid(slot));
        return slot.obj;
    }

    @Override
    public Completion shutdown() {
        this.shutdown = true;
        return this.allocator.shutdown(this.allocatorThread);
    }

    @Override
    public void setTargetSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Target pool size must be at least 1");
        }
        if (this.shutdown) {
            return;
        }
        this.allocator.setTargetSize(size);
    }

    @Override
    public int getTargetSize() {
        return this.allocator.getTargetSize();
    }

    @Override
    public long getAllocationCount() {
        return this.allocator.getAllocationCount();
    }

    @Override
    public long getFailedAllocationCount() {
        return this.allocator.getFailedAllocationCount();
    }

    @Override
    public boolean isShutDown() {
        return this.shutdown;
    }

    @Override
    public double getObjectLifetimePercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getObjectLifetimePercentile(percentile);
    }

    @Override
    public double getAllocationLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getAllocationLatencyPercentile(percentile);
    }

    @Override
    public double getAllocationFailureLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getAllocationFailureLatencyPercentile(percentile);
    }

    @Override
    public double getReallocationLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getReallocationLatencyPercentile(percentile);
    }

    @Override
    public double getReallocationFailureLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getReallocationFailurePercentile(percentile);
    }

    @Override
    public double getDeallocationLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getDeallocationLatencyPercentile(percentile);
    }

    @Override
    public long getLeakedObjectsCount() {
        return this.allocator.countLeakedObjects();
    }
}

