/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

final class UnsafeUtil {
    private static final Unsafe unsafe = UnsafeUtil.getUnsafe();

    UnsafeUtil() {
    }

    private static Unsafe getUnsafe() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Class<Unsafe> unsafeClass = Unsafe.class;
                    for (Field field : unsafeClass.getDeclaredFields()) {
                        if (!unsafeClass.isAssignableFrom(field.getType())) continue;
                        field.setAccessible(true);
                        Object obj = field.get(null);
                        return (Unsafe)unsafeClass.cast(obj);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            return null;
        }
    }

    static boolean hasUnsafe() {
        return unsafe != null;
    }

    static long objectFieldOffset(Class<?> type, String fieldName) {
        if (UnsafeUtil.hasUnsafe()) {
            try {
                Field field = type.getDeclaredField(fieldName);
                return unsafe.objectFieldOffset(field);
            }
            catch (NoSuchFieldException e) {
                throw new Error("Intrinsic error: objectFieldOffset for " + fieldName, e);
            }
        }
        return 0L;
    }

    static boolean compareAndSwapInt(Object obj, long offset, int expected, int update) {
        return unsafe.compareAndSwapInt(obj, offset, expected, update);
    }

    static void putOrderedInt(Object obj, long offset, int update) {
        unsafe.putOrderedInt(obj, offset, update);
    }
}

