/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0015\u001a\u00020\u0003*\u00020\tH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u001a\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0018\u0010\u0010\u001a\u00020\u0003*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0018\u0010\u0012\u001a\u00020\u0003*\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\"\u0018\u0010\u0012\u001a\u00020\u0003*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0016"}, d2={"HTTP_CONTINUE", "", "containsGzip", "", "Lokhttp3/Headers;", "getContainsGzip", "(Lokhttp3/Headers;)Z", "contentLength", "", "Lokhttp3/Response;", "getContentLength", "(Lokhttp3/Response;)J", "contentType", "", "getContentType", "(Lokhttp3/Response;)Ljava/lang/String;", "isChunked", "(Lokhttp3/Response;)Z", "isGzipped", "Lokhttp3/Request;", "(Lokhttp3/Request;)Z", "hasBody", "com.github.ChuckerTeam.Chucker.library"})
public final class OkHttpUtilsKt {
    private static final int HTTP_CONTINUE = 100;

    public static final boolean hasBody(@NotNull Response $this$hasBody) {
        Intrinsics.checkNotNullParameter((Object)$this$hasBody, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$hasBody.request().method(), (Object)"HEAD")) {
            return false;
        }
        int responseCode = $this$hasBody.code();
        if ((responseCode < 100 || responseCode >= 200) && responseCode != 204 && responseCode != 304) {
            return true;
        }
        return OkHttpUtilsKt.getContentLength($this$hasBody) > 0L || OkHttpUtilsKt.isChunked($this$hasBody);
    }

    private static final long getContentLength(Response $this$contentLength) {
        Long l;
        String string2 = $this$contentLength.header("Content-Length");
        return string2 == null ? -1L : ((l = StringsKt.toLongOrNull((String)string2)) == null ? -1L : l);
    }

    public static final boolean isChunked(@NotNull Response $this$isChunked) {
        Intrinsics.checkNotNullParameter((Object)$this$isChunked, (String)"<this>");
        return StringsKt.equals((String)$this$isChunked.header("Transfer-Encoding"), (String)"chunked", (boolean)true);
    }

    @Nullable
    public static final String getContentType(@NotNull Response $this$contentType) {
        Intrinsics.checkNotNullParameter((Object)$this$contentType, (String)"<this>");
        return $this$contentType.header("Content-Type");
    }

    public static final boolean isGzipped(@NotNull Response $this$isGzipped) {
        Intrinsics.checkNotNullParameter((Object)$this$isGzipped, (String)"<this>");
        Headers headers = $this$isGzipped.headers();
        Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"this.headers()");
        return OkHttpUtilsKt.getContainsGzip(headers);
    }

    public static final boolean isGzipped(@NotNull Request $this$isGzipped) {
        Intrinsics.checkNotNullParameter((Object)$this$isGzipped, (String)"<this>");
        Headers headers = $this$isGzipped.headers();
        Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"this.headers()");
        return OkHttpUtilsKt.getContainsGzip(headers);
    }

    private static final boolean getContainsGzip(Headers $this$containsGzip) {
        return StringsKt.equals((String)$this$containsGzip.get("Content-Encoding"), (String)"gzip", (boolean)true);
    }
}

