/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.chuckerteam.chucker.databinding.ChuckerTransactionItemBodyLineBinding;
import com.chuckerteam.chucker.databinding.ChuckerTransactionItemHeadersBinding;
import com.chuckerteam.chucker.databinding.ChuckerTransactionItemImageBinding;
import com.chuckerteam.chucker.internal.support.SearchHighlightUtilKt;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionPayloadItem;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionPayloadViewHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0016J%\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0012J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0016J\r\u0010\u0019\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001aJ\u0014\u0010\u001b\u001a\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dR\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionBodyAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadViewHolder;", "()V", "items", "Ljava/util/ArrayList;", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadItem;", "Lkotlin/collections/ArrayList;", "getItemCount", "", "getItemViewType", "position", "highlightQueryWithColors", "", "newText", "", "backgroundColor", "foregroundColor", "highlightQueryWithColors$com_github_ChuckerTeam_Chucker_library", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "resetHighlight", "resetHighlight$com_github_ChuckerTeam_Chucker_library", "setItems", "bodyItems", "", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class TransactionBodyAdapter
extends RecyclerView.Adapter<TransactionPayloadViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<TransactionPayloadItem> items;
    private static final int TYPE_HEADERS = 1;
    private static final int TYPE_BODY_LINE = 2;
    private static final int TYPE_IMAGE = 3;

    public TransactionBodyAdapter() {
        boolean bl = false;
        this.items = new ArrayList();
    }

    public final void setItems(@NotNull List<? extends TransactionPayloadItem> bodyItems) {
        Intrinsics.checkNotNullParameter(bodyItems, (String)"bodyItems");
        this.items.clear();
        this.items.addAll((Collection<TransactionPayloadItem>)bodyItems);
        this.notifyDataSetChanged();
    }

    public void onBindViewHolder(@NotNull TransactionPayloadViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        TransactionPayloadItem transactionPayloadItem = this.items.get(position);
        Intrinsics.checkNotNullExpressionValue((Object)transactionPayloadItem, (String)"items[position]");
        holder.bind(transactionPayloadItem);
    }

    @NotNull
    public TransactionPayloadViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        TransactionPayloadViewHolder transactionPayloadViewHolder;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        int n = viewType;
        switch (n) {
            case 1: {
                ChuckerTransactionItemHeadersBinding chuckerTransactionItemHeadersBinding = ChuckerTransactionItemHeadersBinding.inflate(inflater, parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)chuckerTransactionItemHeadersBinding, (String)"inflate(inflater, parent, false)");
                ChuckerTransactionItemHeadersBinding headersItemBinding = chuckerTransactionItemHeadersBinding;
                transactionPayloadViewHolder = new TransactionPayloadViewHolder.HeaderViewHolder(headersItemBinding);
                break;
            }
            case 2: {
                ChuckerTransactionItemBodyLineBinding chuckerTransactionItemBodyLineBinding = ChuckerTransactionItemBodyLineBinding.inflate(inflater, parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)chuckerTransactionItemBodyLineBinding, (String)"inflate(inflater, parent, false)");
                ChuckerTransactionItemBodyLineBinding bodyItemBinding = chuckerTransactionItemBodyLineBinding;
                transactionPayloadViewHolder = new TransactionPayloadViewHolder.BodyLineViewHolder(bodyItemBinding);
                break;
            }
            default: {
                ChuckerTransactionItemImageBinding chuckerTransactionItemImageBinding = ChuckerTransactionItemImageBinding.inflate(inflater, parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)chuckerTransactionItemImageBinding, (String)"inflate(inflater, parent, false)");
                ChuckerTransactionItemImageBinding imageItemBinding = chuckerTransactionItemImageBinding;
                transactionPayloadViewHolder = new TransactionPayloadViewHolder.ImageViewHolder(imageItemBinding);
            }
        }
        return transactionPayloadViewHolder;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int getItemViewType(int position) {
        int n;
        TransactionPayloadItem transactionPayloadItem = this.items.get(position);
        if (transactionPayloadItem instanceof TransactionPayloadItem.HeaderItem) {
            n = 1;
        } else if (transactionPayloadItem instanceof TransactionPayloadItem.BodyLineItem) {
            n = 2;
        } else if (transactionPayloadItem instanceof TransactionPayloadItem.ImageItem) {
            n = 3;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final void highlightQueryWithColors$com_github_ChuckerTeam_Chucker_library(@NotNull String newText, int backgroundColor, int foregroundColor) {
        void $this$forEach$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Iterable $this$filterIsInstance$iv = this.items;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TransactionPayloadItem.BodyLineItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = CollectionsKt.withIndex((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexedValue $dstr$index$item = (IndexedValue)element$iv;
            boolean bl = false;
            int index = $dstr$index$item.component1();
            TransactionPayloadItem.BodyLineItem item = (TransactionPayloadItem.BodyLineItem)$dstr$index$item.component2();
            if (StringsKt.contains((CharSequence)((CharSequence)item.getLine()), (CharSequence)newText, (boolean)true)) {
                item.getLine().clearSpans();
                String string2 = item.getLine().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"item.line.toString()");
                item.setLine(SearchHighlightUtilKt.highlightWithDefinedColors(string2, newText, backgroundColor, foregroundColor));
                this.notifyItemChanged(index + 1);
                continue;
            }
            Object[] spans = item.getLine().getSpans(0, item.getLine().length() - 1, Object.class);
            Intrinsics.checkNotNullExpressionValue((Object)spans, (String)"spans");
            Object[] objectArray = spans;
            boolean bl2 = false;
            Object[] objectArray2 = objectArray;
            boolean bl3 = false;
            if (!(!(objectArray2.length == 0))) continue;
            item.getLine().clearSpans();
            this.notifyItemChanged(index + 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void resetHighlight$com_github_ChuckerTeam_Chucker_library() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.items;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TransactionPayloadItem.BodyLineItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexedValue $dstr$index$item = (IndexedValue)element$iv;
            boolean bl = false;
            int index = $dstr$index$item.component1();
            TransactionPayloadItem.BodyLineItem item = (TransactionPayloadItem.BodyLineItem)$dstr$index$item.component2();
            Object[] spans = item.getLine().getSpans(0, item.getLine().length() - 1, Object.class);
            Intrinsics.checkNotNullExpressionValue((Object)spans, (String)"spans");
            Object[] objectArray = spans;
            boolean bl2 = false;
            Object[] objectArray2 = objectArray;
            boolean bl3 = false;
            if (!(!(objectArray2.length == 0))) continue;
            item.getLine().clearSpans();
            this.notifyItemChanged(index + 1);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionBodyAdapter$Companion;", "", "()V", "TYPE_BODY_LINE", "", "TYPE_HEADERS", "TYPE_IMAGE", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

