/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import redis.embedded.Redis;
import redis.embedded.util.CheckedRunnable;
import redis.embedded.util.IO;

public abstract class RedisInstance
implements Redis {
    private final Pattern readyPattern;
    private final int port;
    private final List<String> args;
    private final boolean forceStop;
    private volatile boolean active = false;
    private Process process;

    protected RedisInstance(int port, List<String> args, Pattern readyPattern, boolean forceStop) {
        this.port = port;
        this.args = args;
        this.readyPattern = readyPattern;
        this.forceStop = forceStop;
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.active) {
            return;
        }
        try {
            this.process = new ProcessBuilder(this.args).directory(new File(this.args.get(0)).getParentFile()).start();
            IO.addShutdownHook("RedisInstanceCleaner", IO.checkedToRuntime(new CheckedRunnable(){

                @Override
                public void run() throws Exception {
                }
            }));
            IO.logStream(this.process.getErrorStream(), System.out::println);
            this.awaitServerReady();
            this.active = true;
        }
        catch (IOException e) {
            throw new IOException("Failed to start Redis service", e);
        }
    }

    private void awaitServerReady() throws IOException {
        StringBuilder log = new StringBuilder();
        if (!IO.findMatchInStream(this.process.getInputStream(), this.readyPattern, log)) {
            throw new IOException("Ready pattern not found in log. Startup log: " + log);
        }
    }

    @Override
    public synchronized void stop() throws IOException {
        if (!this.active) {
            return;
        }
        try {
            if (this.forceStop) {
                this.process.destroyForcibly();
            } else {
                this.process.destroy();
                this.process.waitFor();
            }
            this.active = false;
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to stop redis service", e);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public List<Integer> ports() {
        return Collections.singletonList(this.port);
    }
}

