/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.visitors;

import com.github.curiousoddman.rgxgen.config.RgxGenProperties;
import com.github.curiousoddman.rgxgen.model.SymbolRange;
import com.github.curiousoddman.rgxgen.nodes.Choice;
import com.github.curiousoddman.rgxgen.nodes.FinalSymbol;
import com.github.curiousoddman.rgxgen.nodes.GroupRef;
import com.github.curiousoddman.rgxgen.nodes.Node;
import com.github.curiousoddman.rgxgen.nodes.NotSymbol;
import com.github.curiousoddman.rgxgen.nodes.Repeat;
import com.github.curiousoddman.rgxgen.nodes.SymbolSet;
import com.github.curiousoddman.rgxgen.parsing.dflt.ConstantsProvider;
import com.github.curiousoddman.rgxgen.parsing.dflt.DefaultTreeBuilder;
import com.github.curiousoddman.rgxgen.visitors.GenerationVisitor;
import com.github.curiousoddman.rgxgen.visitors.GenerationVisitorBuilder;
import com.github.curiousoddman.rgxgen.visitors.helpers.SymbolSetIndexer;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.regex.Pattern;

public class NotMatchingGenerationVisitor
extends GenerationVisitor {
    private static final SymbolRange ALL_SYMBOLS = ConstantsProvider.ASCII_SYMBOL_RANGE;

    public static GenerationVisitorBuilder builder() {
        return new GenerationVisitorBuilder(false);
    }

    public NotMatchingGenerationVisitor(Random random, Map<Integer, String> groupValues, RgxGenProperties properties) {
        super(random, groupValues, properties);
    }

    @Override
    public void visit(SymbolSet node) {
        this.visitSymbolSet(node, SymbolSet::getSymbolSetIndexer);
    }

    protected void visitSymbolSet(SymbolSet node, Function<SymbolSet, SymbolSetIndexer> indexerFunction) {
        SymbolSet invertedNode = node.getInvertedNode();
        SymbolSetIndexer indexer = indexerFunction.apply(invertedNode);
        if (indexer.size() != 0) {
            int idx = this.aRandom.nextInt(indexer.size());
            this.aStringBuilder.append(indexer.get(idx));
        }
    }

    @Override
    public void visit(Choice node) {
        StringBuilder groupsBuilder = new StringBuilder();
        StringBuilder valuePrefixBuilder = new StringBuilder();
        this.buildGroupsStringAndValuePrefix(groupsBuilder, valuePrefixBuilder);
        Pattern pattern = Pattern.compile(groupsBuilder + node.getPattern());
        int pos = this.aStringBuilder.length();
        Node[] nodes = node.getNodes();
        do {
            this.aStringBuilder.delete(pos, Integer.MAX_VALUE);
            int i = this.aRandom.nextInt(nodes.length);
            nodes[i].visit(this);
        } while (pattern.matcher(valuePrefixBuilder + this.aStringBuilder.substring(pos)).matches());
    }

    private void buildGroupsStringAndValuePrefix(StringBuilder groupsBuilder, StringBuilder valuePrefixBuilder) {
        int groupValuesUsed = 0;
        int i = 1;
        while (groupValuesUsed < this.aGroupValues.size()) {
            String s = (String)this.aGroupValues.get(i);
            groupsBuilder.append('(');
            if (s != null) {
                groupsBuilder.append(Pattern.quote(s));
                ++groupValuesUsed;
                valuePrefixBuilder.append(s);
            }
            groupsBuilder.append(')');
            ++i;
        }
    }

    @Override
    public void visit(FinalSymbol node) {
        String nodeValue = node.getValue();
        if (nodeValue.isEmpty()) {
            this.aStringBuilder.append(NotMatchingGenerationVisitor.getRandomCharacter(this.aRandom.nextInt(ALL_SYMBOLS.size())));
        } else {
            StringBuilder builder = new StringBuilder(nodeValue.length());
            do {
                builder.delete(0, Integer.MAX_VALUE);
                nodeValue.chars().map(c -> NotMatchingGenerationVisitor.getRandomCharacter(this.aRandom.nextInt(ALL_SYMBOLS.size()))).forEachOrdered(c -> builder.append((char)c));
            } while (this.equalsFinalSymbolRandomString(nodeValue, builder.toString()));
            this.aStringBuilder.append((CharSequence)builder);
        }
    }

    private static char getRandomCharacter(int index) {
        return (char)(ALL_SYMBOLS.getFrom() + index);
    }

    protected boolean equalsFinalSymbolRandomString(String s1, String s2) {
        return s1.equals(s2);
    }

    @Override
    public void visit(Repeat node) {
        if (node.getMin() == 0) {
            super.visit(new Repeat(node.getPattern(), node.getNode(), 1, node.getMax()));
        } else {
            super.visit(node);
        }
    }

    @Override
    public void visit(NotSymbol node) {
        DefaultTreeBuilder builder = new DefaultTreeBuilder(node.getPattern(), this.properties);
        Node subNode = builder.get();
        GenerationVisitor generationVisitor = new GenerationVisitor(this.aRandom, this.aGroupValues, this.properties);
        subNode.visit(generationVisitor);
        this.aStringBuilder.append(generationVisitor.getString());
    }

    @Override
    public void visit(GroupRef node) {
        FinalSymbol finalSymbol = new FinalSymbol((String)this.aGroupValues.get(node.getIndex()));
        this.visit(finalSymbol);
    }
}

