/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog.renderers;

import com.github.danielflower.mavenplugins.gitlog.renderers.FileRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.Formatter;
import com.github.danielflower.mavenplugins.gitlog.renderers.MessageConverter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;

public class SimpleHtmlRenderer
extends FileRenderer {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String title;
    private String template;
    protected StringBuilder tableHtml = new StringBuilder();
    protected final MessageConverter messageConverter;
    private final boolean tableOnly;
    private final boolean fullGitMessage;

    public SimpleHtmlRenderer(Log log, File targetFolder, String filename, boolean fullGitMessage, MessageConverter messageConverter, boolean tableOnly) throws IOException {
        super(log, targetFolder, filename, false);
        this.messageConverter = messageConverter;
        this.tableOnly = tableOnly;
        this.fullGitMessage = fullGitMessage;
        if (!tableOnly) {
            this.template = this.loadResourceToString("/html/SimpleHtmlTemplate.html");
        }
    }

    protected static String htmlEncode(String input) {
        input = StringEscapeUtils.escapeHtml4((String)input);
        return input.replaceAll(System.getProperty("line.separator"), "<br/>");
    }

    @Override
    public void renderHeader(String reportTitle) throws IOException {
        this.title = reportTitle;
        this.tableHtml.append("\t<table class=\"changelog\">").append(Formatter.NEW_LINE).append("\t\t<tbody>").append(Formatter.NEW_LINE);
    }

    @Override
    public void renderTag(RevTag tag) throws IOException {
        this.tableHtml.append("\t\t<tr class=\"tag\"><td colspan=\"3\">").append(SimpleHtmlRenderer.htmlEncode(tag.getTagName())).append("</td></tr>").append(Formatter.NEW_LINE);
    }

    @Override
    public void renderCommit(RevCommit commit) throws IOException {
        String date = Formatter.formatDateTime(commit.getCommitTime());
        String message = null;
        message = this.fullGitMessage ? this.messageConverter.formatCommitMessage(this.formatLongMessage(commit.getFullMessage())) : this.messageConverter.formatCommitMessage(SimpleHtmlRenderer.htmlEncode(commit.getShortMessage()));
        String author = SimpleHtmlRenderer.htmlEncode(commit.getAuthorIdent().getName());
        String committer = SimpleHtmlRenderer.htmlEncode(commit.getCommitterIdent().getName());
        String authorHtml = "<span class=\"committer\">" + Formatter.formatCommiter(commit.getCommitterIdent()) + "</span>";
        if (!this.areSame(author, committer)) {
            authorHtml = "<span class=\"author\">" + author + "</span> by " + authorHtml;
        }
        this.tableHtml.append("\t\t<tr>").append("<td class=\"date\">").append(date).append("</td>").append("<td>").append(authorHtml).append("</td>").append("<td>").append(message).append("</td>").append("</tr>").append(Formatter.NEW_LINE);
    }

    private String formatLongMessage(String gitMessage) {
        String[] lines = StringEscapeUtils.escapeHtml4((String)gitMessage).split(LINE_SEPARATOR);
        if (lines.length <= 1) {
            return gitMessage;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            if (i == 0) {
                builder.append(lines[i]).append("</br><span class='commitDetails'>");
                continue;
            }
            builder.append(lines[i]).append("</br>");
        }
        return builder.append("</span>").toString();
    }

    @Override
    public void renderFooter() throws IOException {
        this.tableHtml.append("\t\t</tbody>").append(Formatter.NEW_LINE).append("\t</table>").append(Formatter.NEW_LINE);
        if (this.tableOnly) {
            this.writer.append(this.tableHtml.toString());
        } else {
            String html = this.template.replace("{title}", SimpleHtmlRenderer.htmlEncode(this.title)).replace("{table}", this.tableHtml.toString());
            this.writer.append(html);
        }
    }

    private boolean areSame(String author, String committer) {
        return ("" + author).toLowerCase().equals("" + committer.toLowerCase());
    }
}

