/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.GitHelper;
import com.github.danielflower.mavenplugins.release.NoChangesAction;
import com.github.danielflower.mavenplugins.release.SshAgentSessionFactory;
import com.github.danielflower.mavenplugins.release.ValidationException;
import com.github.danielflower.mavenplugins.release.VersionNamer;
import java.util.List;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public abstract class BaseMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true, defaultValue="${project}")
    protected MavenProject project;
    @Parameter(property="projects", required=true, readonly=true, defaultValue="${reactorProjects}")
    protected List<MavenProject> projects;
    @Parameter(property="buildNumber")
    protected Long buildNumber;
    @Parameter(property="versionNamer")
    protected VersionNamer versionNamer = new VersionNamer(".");
    @Parameter(alias="modulesToRelease", property="modulesToRelease")
    protected List<String> modulesToRelease;
    @Parameter(alias="forceRelease", property="forceRelease")
    protected List<String> modulesToForceRelease;
    @Parameter(alias="noChangesAction", defaultValue="ReleaseAll", property="noChangesAction")
    protected NoChangesAction noChangesAction;
    @Component
    protected ArtifactFactory factory;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(property="remoteRepositories", required=true, readonly=true, defaultValue="${project.remoteArtifactRepositories}")
    protected List remoteRepositories;
    @Parameter(property="localRepository", required=true, readonly=true, defaultValue="${localRepository}")
    protected ArtifactRepository localRepository;
    @Parameter(property="disableSshAgent")
    private boolean disableSshAgent;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(property="serverId")
    private String serverId;
    @Parameter(property="knownHosts")
    private String knownHosts;
    @Parameter(property="privateKey")
    private String privateKey;
    @Parameter(property="passphrase")
    private String passphrase;
    @Parameter(alias="pullTags", property="pull", defaultValue="true")
    protected boolean pullTags;
    @Parameter(property="arguments")
    public String arguments;

    final void setSettings(Settings settings) {
        this.settings = settings;
    }

    final Settings getSettings() {
        return this.settings;
    }

    final void setServerId(String serverId) {
        this.serverId = serverId;
    }

    final void setKnownHosts(String knownHosts) {
        this.knownHosts = knownHosts;
    }

    final void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    final void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    final void disableSshAgent() {
        this.disableSshAgent = true;
    }

    protected CredentialsProvider getCredentialsProvider(Log log) throws ValidationException {
        if (this.serverId != null) {
            Server server = this.settings.getServer(this.serverId);
            if (server == null) {
                log.warn((CharSequence)String.format("No server configuration in Maven settings found with id %s", this.serverId));
            }
            if (server.getUsername() != null && server.getPassword() != null) {
                return new UsernamePasswordCredentialsProvider(server.getUsername(), server.getPassword());
            }
        }
        return null;
    }

    protected final void configureJsch(Log log) {
        if (!this.disableSshAgent) {
            if (this.serverId != null) {
                Server server = this.settings.getServer(this.serverId);
                if (server != null) {
                    this.privateKey = this.privateKey == null ? server.getPrivateKey() : this.privateKey;
                    this.passphrase = this.passphrase == null ? server.getPassphrase() : this.passphrase;
                } else {
                    log.warn((CharSequence)String.format("No server configuration in Maven settings found with id %s", this.serverId));
                }
            }
            JschConfigSessionFactory.setInstance((SshSessionFactory)new SshAgentSessionFactory(log, this.knownHosts, this.privateKey, this.passphrase));
        }
    }

    static void printBigErrorMessageAndThrow(Log log, String terseMessage, List<String> linesToLog) throws MojoExecutionException {
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        log.error((CharSequence)"************************************");
        log.error((CharSequence)"Could not execute the release plugin");
        log.error((CharSequence)"************************************");
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        for (String line : linesToLog) {
            log.error((CharSequence)line);
        }
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        throw new MojoExecutionException(terseMessage);
    }

    protected static String getRemoteUrlOrNullIfNoneSet(Scm originalScm, Scm actualScm) throws ValidationException {
        if (originalScm == null) {
            return null;
        }
        String remote = actualScm.getDeveloperConnection();
        if (remote == null) {
            remote = actualScm.getConnection();
        }
        if (remote == null) {
            return null;
        }
        return GitHelper.scmUrlToRemote(remote);
    }
}

