/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.Reactor;
import com.github.danielflower.mavenplugins.release.ReleasableModule;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;

class ReleaseInvoker {
    static final String DEPLOY = "deploy";
    static final String SKIP_TESTS = "-DskipTests=true";
    private final Log log;
    private final MavenProject project;
    private final InvocationRequest request;
    private final Invoker invoker;
    private boolean skipTests;
    private List<String> goals;
    private List<String> modulesToRelease;
    private List<String> releaseProfiles;
    private String arguments;

    public ReleaseInvoker(Log log, MavenProject project) {
        this(log, project, (InvocationRequest)new DefaultInvocationRequest(), (Invoker)new DefaultInvoker());
    }

    public ReleaseInvoker(Log log, MavenProject project, InvocationRequest request, Invoker invoker) {
        this.log = log;
        this.project = project;
        this.request = request;
        this.invoker = invoker;
    }

    private List<String> getGoals() {
        if (this.goals == null || this.goals.isEmpty()) {
            this.goals = new ArrayList<String>();
            this.goals.add(DEPLOY);
        }
        return this.goals;
    }

    private List<String> getModulesToRelease() {
        return this.modulesToRelease == null ? Collections.emptyList() : this.modulesToRelease;
    }

    private List<String> getReleaseProfilesOrNull() {
        return this.releaseProfiles;
    }

    final void setGoals(List<String> goalsOrNull) {
        this.goals = goalsOrNull;
    }

    final void setModulesToRelease(List<String> modulesToReleaseOrNull) {
        this.modulesToRelease = modulesToReleaseOrNull;
    }

    final void setReleaseProfiles(List<String> releaseProfilesOrNull) {
        this.releaseProfiles = releaseProfilesOrNull;
    }

    final void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    final void setGlobalSettings(File globalSettings) {
        this.request.setGlobalSettingsFile(globalSettings);
    }

    final void setUserSettings(File userSettings) {
        this.request.setUserSettingsFile(userSettings);
    }

    public final void runMavenBuild(Reactor reactor) throws MojoExecutionException {
        this.request.setBatchMode(true);
        this.request.setShowErrors(true);
        this.request.setDebug(this.log.isDebugEnabled());
        List<String> goals = this.getGoals();
        if (this.arguments != null) {
            goals.add(this.arguments);
        }
        if (this.skipTests) {
            goals.add(SKIP_TESTS);
        }
        this.request.setGoals(this.getGoals());
        List<String> profiles = this.profilesToActivate();
        this.request.setProfiles(profiles);
        this.request.setAlsoMake(true);
        ArrayList<String> changedModules = new ArrayList<String>();
        List<String> modulesToRelease = this.getModulesToRelease();
        for (ReleasableModule releasableModule : reactor.getModulesInBuildOrder()) {
            String modulePath = releasableModule.getRelativePathToModule();
            boolean userExplicitlyWantsThisToBeReleased = modulesToRelease.contains(modulePath);
            boolean userImplicitlyWantsThisToBeReleased = modulesToRelease.isEmpty();
            if (!userExplicitlyWantsThisToBeReleased && (!userImplicitlyWantsThisToBeReleased || !releasableModule.willBeReleased())) continue;
            changedModules.add(modulePath);
        }
        this.request.setProjects(changedModules);
        String profilesInfo = profiles.isEmpty() ? "no profiles activated" : "profiles " + profiles;
        this.log.info((CharSequence)String.format("About to run mvn %s with %s", goals, profilesInfo));
        try {
            InvocationResult result = this.invoker.execute(this.request);
            if (result.getExitCode() != 0) {
                throw new MojoExecutionException("Maven execution returned code " + result.getExitCode());
            }
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException("Failed to build artifact", (Exception)((Object)e));
        }
    }

    private List<String> profilesToActivate() {
        ArrayList<String> profiles = new ArrayList<String>();
        if (this.getReleaseProfilesOrNull() != null) {
            profiles.addAll(this.getReleaseProfilesOrNull());
        }
        for (Object activatedProfile : this.project.getActiveProfiles()) {
            profiles.add(((Profile)activatedProfile).getId());
        }
        return profiles;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }
}

