/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import com.github.danielflower.mavenplugins.release.TagPusher;
import java.util.Collection;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;

class RemoteTagPusher
implements TagPusher {
    private final Git git;
    private final String remoteUrl;
    private final CredentialsProvider credentialsProvider;

    public RemoteTagPusher(Git git, String remoteUrl, CredentialsProvider credentialsProvider) {
        this.git = git;
        this.remoteUrl = remoteUrl;
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public void pushTags(Collection<AnnotatedTag> tags) throws GitAPIException {
        PushCommand pushCommand = (PushCommand)this.git.push().setCredentialsProvider(this.credentialsProvider);
        if (this.remoteUrl != null) {
            pushCommand.setRemote(this.remoteUrl);
        }
        for (AnnotatedTag tag : tags) {
            pushCommand.add(tag.saveAtHEAD(this.git));
        }
        pushCommand.call();
    }
}

