/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.ReleasableModule;
import com.github.danielflower.mavenplugins.release.VersionReportFormat;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class VersionReport {
    @Parameter
    private VersionReportFormat versionsReportFormat;
    @Parameter
    private String versionsReportFilePath;
    @Parameter(alias="releasedModulesOnly", defaultValue="false")
    private boolean releasedModulesOnly;

    public void generateVersionReport(Log log, List<ReleasableModule> releasableModules) throws IOException {
        block13: {
            String res = "";
            switch (this.versionsReportFormat) {
                case FLAT: {
                    for (ReleasableModule module : releasableModules) {
                        if (this.skipModuleInReport(module)) continue;
                        res = res + String.format("%s:%s%n", module.getArtifactId(), module.getVersionToDependOn());
                    }
                    break;
                }
                default: {
                    JSONObject jsonObject = new JSONObject();
                    JSONArray releasedModulesArray = new JSONArray();
                    for (ReleasableModule module : releasableModules) {
                        if (this.skipModuleInReport(module)) continue;
                        JSONObject releasedModuleObject = new JSONObject();
                        releasedModuleObject.put((Object)"name", (Object)module.getArtifactId());
                        releasedModuleObject.put((Object)"version", (Object)module.getVersionToDependOn());
                        releasedModulesArray.add((Object)releasedModuleObject);
                    }
                    jsonObject.put((Object)"modules", (Object)releasedModulesArray);
                    res = jsonObject.toJSONString();
                }
            }
            if (!res.equals("")) {
                try (FileWriter file = new FileWriter(this.versionsReportFilePath, true);){
                    file.write(res);
                    log.info((CharSequence)String.format("Successfully written report file - %s", this.versionsReportFilePath));
                    break block13;
                }
                catch (IOException e) {
                    log.warn((CharSequence)String.format("Failed to write report to file %nversionsReportFilePath=%s%ncontent=%s", this.versionsReportFilePath, res));
                    throw e;
                }
            }
            log.info((CharSequence)String.format("Nothing to write in report, versionsReportFilePath=%s", this.versionsReportFilePath));
        }
    }

    private boolean skipModuleInReport(ReleasableModule module) {
        return this.releasedModulesOnly && !module.willBeReleased();
    }
}

