/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core;

import com.github.database.rider.core.JUnit4RiderTestContext;
import com.github.database.rider.core.RiderRunner;
import com.github.database.rider.core.api.connection.ConnectionHolder;
import com.github.database.rider.core.api.dataset.DataSet;
import com.github.database.rider.core.api.dataset.DataSetExecutor;
import com.github.database.rider.core.api.leak.LeakHunter;
import com.github.database.rider.core.configuration.DBUnitConfig;
import com.github.database.rider.core.connection.ConnectionHolderImpl;
import com.github.database.rider.core.dataset.DataSetExecutorImpl;
import com.github.database.rider.core.leak.LeakHunterFactory;
import java.sql.Connection;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DBUnitRule
implements TestRule {
    private DataSetExecutor executor;

    private DBUnitRule() {
    }

    public static DBUnitRule instance() {
        DBUnitRule instance = new DBUnitRule();
        instance.executor = DataSetExecutorImpl.instance("default", null);
        return instance;
    }

    public static DBUnitRule instance(Connection connection) {
        return DBUnitRule.instance(new ConnectionHolderImpl(connection));
    }

    public static DBUnitRule instance(String executorName, Connection connection) {
        return DBUnitRule.instance(executorName, new ConnectionHolderImpl(connection));
    }

    public static DBUnitRule instance(ConnectionHolder connectionHolder) {
        return DBUnitRule.instance("default", connectionHolder);
    }

    public static DBUnitRule instance(String executorName, ConnectionHolder connectionHolder) {
        DBUnitRule instance = new DBUnitRule();
        instance.executor = DataSetExecutorImpl.instance(executorName, connectionHolder);
        return instance;
    }

    public Statement apply(final Statement statement, final Description description) {
        DataSet dataSet = (DataSet)description.getAnnotation(DataSet.class);
        if (dataSet == null) {
            dataSet = description.getTestClass().getAnnotation(DataSet.class);
        }
        if (dataSet != null && !"".equals(dataSet.executorId().trim())) {
            this.executor = DataSetExecutorImpl.getExecutorById(dataSet.executorId());
        }
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                JUnit4RiderTestContext riderTestContext = new JUnit4RiderTestContext(DBUnitRule.this.executor, description);
                RiderRunner riderRunner = new RiderRunner();
                riderRunner.setup(riderTestContext);
                DBUnitConfig dbUnitConfig = riderTestContext.getDataSetExecutor().getDBUnitConfig();
                try {
                    riderRunner.runBeforeTest(riderTestContext);
                    LeakHunter leakHunter = null;
                    if (dbUnitConfig.isLeakHunter().booleanValue()) {
                        leakHunter = LeakHunterFactory.from(riderTestContext.getDataSetExecutor().getRiderDataSource(), riderTestContext.getMethodName());
                        leakHunter.measureConnectionsBeforeExecution();
                    }
                    statement.evaluate();
                    if (dbUnitConfig.isLeakHunter().booleanValue() && leakHunter != null) {
                        leakHunter.checkConnectionsAfterExecution();
                    }
                    riderRunner.runAfterTest(riderTestContext);
                }
                finally {
                    riderRunner.teardown(riderTestContext);
                }
            }
        };
    }

    public DataSetExecutor getDataSetExecutor() {
        return this.executor;
    }
}

