/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.api.dataset;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;

public class ScriptableTable
implements ITable {
    private static final Pattern scriptEnginePattern = Pattern.compile("^(?!regex)[a-zA-Z]+:.+");
    static Logger log = Logger.getLogger(ScriptableTable.class.getName());
    ScriptEngineManager manager;
    private Map<String, ScriptEngine> engines;
    private ITable delegate;

    public ScriptableTable(ITable delegate) {
        this.delegate = delegate;
        this.engines = new HashMap<String, ScriptEngine>();
        this.manager = new ScriptEngineManager();
    }

    public ITableMetaData getTableMetaData() {
        return this.delegate.getTableMetaData();
    }

    public int getRowCount() {
        return this.delegate.getRowCount();
    }

    public Object getValue(int row, String column) throws DataSetException {
        ScriptEngine engine;
        Object value = this.delegate.getValue(row, column);
        if (value != null && scriptEnginePattern.matcher(value.toString()).matches() && (engine = this.getScriptEngine(value.toString().trim())) != null) {
            try {
                return this.getScriptResult(value.toString(), engine);
            }
            catch (Exception e) {
                log.log(Level.WARNING, String.format("Could not evaluate script expression for table '%s', column '%s'. The original value will be used.", this.getTableMetaData().getTableName(), column), e);
            }
        }
        return value;
    }

    private ScriptEngine getScriptEngine(String value) {
        String engineName = value.substring(0, value.indexOf(":"));
        if (this.engines.containsKey(engineName)) {
            return this.engines.get(engineName);
        }
        ScriptEngine engine = this.manager.getEngineByName(engineName);
        if (engine != null) {
            this.engines.put(engineName, engine);
        } else {
            log.warning(String.format("Could not find script engine by name '%s'", engineName));
        }
        return engine;
    }

    private Object getScriptResult(String script, ScriptEngine engine) throws ScriptException {
        String scriptToExecute = script.substring(script.indexOf(":") + 1);
        return engine.eval(scriptToExecute);
    }
}

