/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.api.dataset;

import com.github.database.rider.core.api.configuration.Orthography;
import com.github.database.rider.core.configuration.DBUnitConfig;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.dbunit.dataset.datatype.DataType;
import org.yaml.snakeyaml.Yaml;

public class YamlDataSet
implements IDataSet {
    private Map<String, MyTable> tables = new HashMap<String, MyTable>();
    private DBUnitConfig dbUnitConfig;

    public YamlDataSet(InputStream source) {
        this(source, null);
    }

    public YamlDataSet(InputStream source, DBUnitConfig dbUnitConfig) {
        Map data;
        if (dbUnitConfig != null) {
            this.dbUnitConfig = dbUnitConfig;
        }
        if ((data = (Map)new Yaml().load(source)) != null) {
            for (Map.Entry ent : data.entrySet()) {
                String tableName = (String)ent.getKey();
                List rows = (List)ent.getValue();
                this.createTable(tableName, rows);
            }
        }
    }

    MyTable createTable(String name, List<Map<String, Object>> rows) {
        MyTable table = new MyTable(this.applyCaseInsensitivity(name), this.applyCase(this.getColumns(rows)));
        if (rows != null) {
            for (Map<String, Object> values : rows) {
                table.addRow(values);
            }
        }
        this.tables.put(name.toUpperCase(), table);
        return table;
    }

    public List<String> getColumns(List<Map<String, Object>> rows) {
        if (rows != null) {
            HashSet<String> columns = new HashSet<String>();
            for (Map<String, Object> row : rows) {
                columns.addAll(this.applyCase(new ArrayList<String>(row.keySet())));
            }
            return new ArrayList<String>(columns);
        }
        return null;
    }

    public ITable getTable(String tableName) throws DataSetException {
        return this.tables.get(tableName.toUpperCase());
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        MyTable myTable = this.tables.get(tableName.toUpperCase());
        if (myTable != null) {
            return myTable.getTableMetaData();
        }
        return null;
    }

    public String[] getTableNames() throws DataSetException {
        ITable[] tables = this.getTables();
        String[] tableNames = new String[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            tableNames[i] = tables[i].getTableMetaData().getTableName();
        }
        return tableNames;
    }

    public ITable[] getTables() throws DataSetException {
        return this.tables.values().toArray(new ITable[this.tables.size()]);
    }

    public ITableIterator iterator() throws DataSetException {
        return new DefaultTableIterator(this.getTables());
    }

    public ITableIterator reverseIterator() throws DataSetException {
        return new DefaultTableIterator(this.getTables(), true);
    }

    public boolean isCaseSensitiveTableNames() {
        Boolean result = (Boolean)this.dbUnitConfig.getProperties().get("caseSensitiveTableNames");
        return Boolean.TRUE.equals(result);
    }

    public boolean isCaseInsensitiveStrategyLowerCase() {
        return Orthography.LOWERCASE.equals((Object)this.dbUnitConfig.getCaseInsensitiveStrategy());
    }

    String applyCaseInsensitivity(String name) {
        return name != null ? (this.isCaseSensitiveTableNames() ? name : (this.isCaseInsensitiveStrategyLowerCase() ? name.toLowerCase(Locale.ENGLISH) : name.toUpperCase(Locale.ENGLISH))) : null;
    }

    private List<String> applyCase(List<String> names) {
        if (names != null) {
            for (int i = 0; i < names.size(); ++i) {
                names.set(i, this.applyCaseInsensitivity(names.get(i)));
            }
        }
        return names;
    }

    class MyTable
    implements ITable {
        String name;
        List<Map<String, Object>> data;
        ITableMetaData meta;

        MyTable(String name, List<String> columnNames) {
            this.name = name;
            this.data = new ArrayList<Map<String, Object>>();
            this.meta = this.createMeta(name, columnNames);
        }

        ITableMetaData createMeta(String name, List<String> columnNames) {
            Column[] columns = null;
            if (columnNames != null) {
                columns = new Column[columnNames.size()];
                for (int i = 0; i < columnNames.size(); ++i) {
                    columns[i] = new Column(columnNames.get(i), DataType.UNKNOWN);
                }
            } else {
                columns = new Column[]{};
            }
            return new DefaultTableMetaData(name, columns);
        }

        public int getRowCount() {
            return this.data.size();
        }

        public ITableMetaData getTableMetaData() {
            return this.meta;
        }

        public Object getValue(int row, String column) throws DataSetException {
            if (this.data.size() <= row) {
                throw new RowOutOfBoundsException("" + row);
            }
            return this.data.get(row).get(YamlDataSet.this.applyCaseInsensitivity(column));
        }

        public void addRow(Map<String, Object> values) {
            this.data.add(this.convertMap(values));
        }

        Map<String, Object> convertMap(Map<String, Object> values) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (Map.Entry<String, Object> ent : values.entrySet()) {
                row.put(YamlDataSet.this.applyCaseInsensitivity(ent.getKey()), ent.getValue());
            }
            return row;
        }
    }
}

