/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.assertion;

import java.util.regex.Pattern;
import org.dbunit.assertion.DbUnitAssert;
import org.dbunit.assertion.Difference;
import org.dbunit.assertion.FailureHandler;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetAssert
extends DbUnitAssert {
    private static final Logger logger = LoggerFactory.getLogger(DbUnitAssert.class);

    protected void compareData(ITable expectedTable, ITable actualTable, DbUnitAssert.ComparisonColumn[] comparisonCols, FailureHandler failureHandler) throws DataSetException {
        logger.debug("compareData(expectedTable={}, actualTable={}, comparisonCols={}, failureHandler={}) - start", new Object[]{expectedTable, actualTable, comparisonCols, failureHandler});
        if (expectedTable == null) {
            throw new NullPointerException("The parameter 'expectedTable' must not be null");
        }
        if (actualTable == null) {
            throw new NullPointerException("The parameter 'actualTable' must not be null");
        }
        if (comparisonCols == null) {
            throw new NullPointerException("The parameter 'comparisonCols' must not be null");
        }
        if (failureHandler == null) {
            throw new NullPointerException("The parameter 'failureHandler' must not be null");
        }
        for (int i = 0; i < expectedTable.getRowCount(); ++i) {
            for (int j = 0; j < comparisonCols.length; ++j) {
                Difference diff;
                Object actualValue;
                DbUnitAssert.ComparisonColumn compareColumn = comparisonCols[j];
                String columnName = compareColumn.getColumnName();
                DataType dataType = compareColumn.getDataType();
                Object expectedValue = expectedTable.getValue(i, columnName);
                if (this.skipCompare(columnName, expectedValue, actualValue = actualTable.getValue(i, columnName))) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("ignoring comparison " + expectedValue + "=" + actualValue + " on column " + columnName);
                    continue;
                }
                if (expectedValue != null && expectedValue.toString().startsWith("regex:")) {
                    if (this.regexMatches(expectedValue.toString(), actualValue.toString())) continue;
                    diff = new Difference(expectedTable, actualTable, i, columnName, expectedValue, actualValue);
                    failureHandler.handle(diff);
                    continue;
                }
                if (dataType.compare(expectedValue, actualValue) == 0) continue;
                diff = new Difference(expectedTable, actualTable, i, columnName, expectedValue, actualValue);
                failureHandler.handle(diff);
            }
        }
    }

    private boolean regexMatches(String expectedValue, String actualValue) {
        Pattern pattern = Pattern.compile(expectedValue.substring(expectedValue.indexOf(":") + 1).trim());
        return pattern.matcher(actualValue).matches();
    }
}

