/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.configuration;

import com.github.database.rider.core.api.configuration.DBUnit;
import com.github.database.rider.core.api.configuration.Orthography;
import com.github.database.rider.core.configuration.ConnectionConfig;
import com.github.database.rider.core.configuration.GlobalConfig;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class DBUnitConfig {
    private String executorId;
    private Boolean cacheConnection;
    private Boolean cacheTableNames;
    private Boolean leakHunter;
    private Orthography caseInsensitiveStrategy;
    private Map<String, Object> properties;
    private ConnectionConfig connectionConfig;

    public DBUnitConfig() {
        this("default");
    }

    public DBUnitConfig(String executor) {
        this.executorId = executor;
        this.initDefault();
    }

    private void initDefault() {
        if ("".equals(this.executorId)) {
            this.executorId = "default";
        }
        this.cacheConnection = true;
        this.cacheTableNames = true;
        this.leakHunter = false;
        this.caseInsensitiveStrategy = Orthography.UPPERCASE;
        this.initDefaultProperties();
        this.initDefaultConnectionConfig();
    }

    private void initDefaultProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.putIfAbsent(this.properties, "batchedStatements", false);
        this.putIfAbsent(this.properties, "qualifiedTableNames", false);
        this.putIfAbsent(this.properties, "caseSensitiveTableNames", false);
        this.putIfAbsent(this.properties, "batchSize", 100);
        this.putIfAbsent(this.properties, "fetchSize", 100);
        this.putIfAbsent(this.properties, "allowEmptyFields", false);
    }

    private <K, V> void putIfAbsent(Map<K, V> map, K key, V value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }

    private void initDefaultConnectionConfig() {
        if (this.connectionConfig == null) {
            this.connectionConfig = new ConnectionConfig();
        }
        if (this.connectionConfig.getDriver() == null) {
            this.connectionConfig.setDriver("");
        }
        if (this.connectionConfig.getUrl() == null) {
            this.connectionConfig.setUrl("");
        }
        if (this.connectionConfig.getUser() == null) {
            this.connectionConfig.setUser("");
        }
        if (this.connectionConfig.getPassword() == null) {
            this.connectionConfig.setPassword("");
        }
    }

    public static DBUnitConfig fromCustomGlobalFile() {
        InputStream customConfiguration = Thread.currentThread().getContextClassLoader().getResourceAsStream("dbunit.yml");
        if (customConfiguration != null) {
            DBUnitConfig configFromFile = (DBUnitConfig)new Yaml().loadAs(customConfiguration, DBUnitConfig.class);
            configFromFile.initDefaultProperties();
            configFromFile.initDefaultConnectionConfig();
            return configFromFile;
        }
        return new DBUnitConfig();
    }

    public static DBUnitConfig from(DBUnit dbUnit) {
        DBUnitConfig dbUnitConfig = new DBUnitConfig(dbUnit.executor());
        dbUnitConfig.cacheConnection(dbUnit.cacheConnection()).cacheTableNames(dbUnit.cacheTableNames()).leakHunter(dbUnit.leakHunter()).addDBUnitProperty("batchedStatements", dbUnit.batchedStatements()).addDBUnitProperty("batchSize", dbUnit.batchSize()).addDBUnitProperty("allowEmptyFields", dbUnit.allowEmptyFields()).addDBUnitProperty("fetchSize", dbUnit.fetchSize()).addDBUnitProperty("qualifiedTableNames", dbUnit.qualifiedTableNames()).addDBUnitProperty("caseSensitiveTableNames", dbUnit.caseSensitiveTableNames()).caseInsensitiveStrategy(dbUnit.caseInsensitiveStrategy());
        if (!"".equals(dbUnit.escapePattern())) {
            dbUnitConfig.addDBUnitProperty("escapePattern", dbUnit.escapePattern());
        }
        dbUnitConfig.driver(dbUnit.driver()).url(dbUnit.url()).user(dbUnit.user()).password(dbUnit.password());
        return dbUnitConfig;
    }

    public static DBUnitConfig fromGlobalConfig() {
        return GlobalConfig.instance().getDbUnitConfig();
    }

    public static DBUnitConfig from(Method method) {
        DBUnit dbUnitConfig = method.getAnnotation(DBUnit.class);
        if (dbUnitConfig == null) {
            dbUnitConfig = method.getDeclaringClass().getAnnotation(DBUnit.class);
        }
        if (dbUnitConfig != null) {
            return DBUnitConfig.from(dbUnitConfig);
        }
        return DBUnitConfig.fromGlobalConfig();
    }

    public DBUnitConfig cacheConnection(boolean cacheConnection) {
        this.cacheConnection = cacheConnection;
        return this;
    }

    public DBUnitConfig executorId(String executorId) {
        this.executorId = executorId;
        return this;
    }

    public DBUnitConfig leakHunter(boolean leakHunter) {
        this.leakHunter = leakHunter;
        return this;
    }

    public DBUnitConfig cacheTableNames(boolean cacheTables) {
        this.cacheTableNames = cacheTables;
        return this;
    }

    public DBUnitConfig caseInsensitiveStrategy(Orthography orthography) {
        this.caseInsensitiveStrategy = orthography;
        return this;
    }

    public DBUnitConfig addDBUnitProperty(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    public DBUnitConfig driver(String driverClass) {
        this.connectionConfig.setDriver(driverClass);
        return this;
    }

    public DBUnitConfig url(String url) {
        this.connectionConfig.setUrl(url);
        return this;
    }

    public DBUnitConfig user(String user) {
        this.connectionConfig.setUser(user);
        return this;
    }

    public DBUnitConfig password(String password) {
        this.connectionConfig.setPassword(password);
        return this;
    }

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public void setCacheConnection(boolean cacheConnection) {
        this.cacheConnection = cacheConnection;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setCacheTableNames(boolean cacheTableNames) {
        this.cacheTableNames = cacheTableNames;
    }

    public Boolean isCacheConnection() {
        return this.cacheConnection;
    }

    public Boolean isCacheTableNames() {
        return this.cacheTableNames;
    }

    public Boolean isLeakHunter() {
        return this.leakHunter;
    }

    public void setLeakHunter(boolean activateLeakHunter) {
        this.leakHunter = activateLeakHunter;
    }

    public Orthography getCaseInsensitiveStrategy() {
        return this.caseInsensitiveStrategy;
    }

    public void setCaseInsensitiveStrategy(Orthography caseInsensitiveStrategy) {
        this.caseInsensitiveStrategy = caseInsensitiveStrategy;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getExecutorId() {
        return this.executorId;
    }

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }
}

