/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.configuration;

import com.github.database.rider.core.api.dataset.DataSet;
import com.github.database.rider.core.api.dataset.SeedStrategy;

public class DataSetConfig {
    private String[] datasets;
    private String executorId = "default";
    private SeedStrategy strategy = SeedStrategy.CLEAN_INSERT;
    private boolean useSequenceFiltering = true;
    private boolean disableConstraints = false;
    private boolean cleanBefore = false;
    private boolean cleanAfter = false;
    private boolean transactional = false;
    private String[] tableOrdering = new String[0];
    private String[] executeStatementsBefore = new String[0];
    private String[] executeStatementsAfter = new String[0];
    private String[] executeScriptsBefore = new String[0];
    private String[] executeScriptsAfter = new String[0];

    public DataSetConfig() {
    }

    public DataSetConfig(String dataset) {
        this.datasets = new String[]{dataset};
    }

    public DataSetConfig(String[] datasets) {
        this.datasets = datasets;
    }

    public DataSetConfig name(String[] datasets) {
        this.datasets = datasets;
        return this;
    }

    public DataSetConfig strategy(SeedStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public DataSetConfig useSequenceFiltering(boolean useSequenceFiltering) {
        this.useSequenceFiltering = useSequenceFiltering;
        return this;
    }

    public DataSetConfig disableConstraints(boolean disableConstraints) {
        this.disableConstraints = disableConstraints;
        return this;
    }

    public DataSetConfig tableOrdering(String[] tableOrdering) {
        this.tableOrdering = tableOrdering;
        return this;
    }

    public DataSetConfig cleanBefore(boolean cleanBefore) {
        this.cleanBefore = cleanBefore;
        return this;
    }

    public DataSetConfig cleanAfter(boolean cleanAfter) {
        this.cleanAfter = cleanAfter;
        return this;
    }

    public DataSetConfig executeStatementsBefore(String[] executeStatementsBefore) {
        this.executeStatementsBefore = executeStatementsBefore;
        return this;
    }

    public DataSetConfig executeStatementsAfter(String[] executeStatementsAfter) {
        this.executeStatementsAfter = executeStatementsAfter;
        return this;
    }

    public DataSetConfig executeScripsBefore(String[] executeScriptsBefore) {
        this.executeScriptsBefore = executeScriptsBefore;
        return this;
    }

    public DataSetConfig executeScriptsAfter(String[] executeScriptsAfter) {
        this.executeScriptsAfter = executeScriptsAfter;
        return this;
    }

    public DataSetConfig executorId(String executorId) {
        this.executorId = executorId;
        return this;
    }

    public DataSetConfig transactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    public DataSetConfig from(DataSet dataSet) {
        if (dataSet != null) {
            return this.name(dataSet.value()).strategy(dataSet.strategy()).useSequenceFiltering(dataSet.useSequenceFiltering()).tableOrdering(dataSet.tableOrdering()).disableConstraints(dataSet.disableConstraints()).executorId(dataSet.executorId()).executeStatementsBefore(dataSet.executeStatementsBefore()).executeScripsBefore(dataSet.executeScriptsBefore()).cleanBefore(dataSet.cleanBefore()).cleanAfter(dataSet.cleanAfter()).transactional(dataSet.transactional()).executeStatementsAfter(dataSet.executeStatementsAfter()).executeScriptsAfter(dataSet.executeScriptsAfter());
        }
        throw new RuntimeException("Cannot create DataSetConfig from Null DataSet");
    }

    public String[] getDatasets() {
        return this.datasets;
    }

    public SeedStrategy getstrategy() {
        return this.strategy;
    }

    public boolean isUseSequenceFiltering() {
        return this.useSequenceFiltering;
    }

    public boolean isDisableConstraints() {
        return this.disableConstraints;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public String[] getTableOrdering() {
        return this.tableOrdering;
    }

    public String[] getExecuteStatementsBefore() {
        return this.executeStatementsBefore;
    }

    public String[] getExecuteStatementsAfter() {
        return this.executeStatementsAfter;
    }

    public String[] getExecuteScriptsBefore() {
        return this.executeScriptsBefore;
    }

    public String[] getExecuteScriptsAfter() {
        return this.executeScriptsAfter;
    }

    public String getExecutorId() {
        return this.executorId;
    }

    public boolean isCleanBefore() {
        return this.cleanBefore;
    }

    public boolean isCleanAfter() {
        return this.cleanAfter;
    }

    public void setstrategy(SeedStrategy strategy) {
        this.strategy = strategy;
    }

    public void setUseSequenceFiltering(boolean useSequenceFiltering) {
        this.useSequenceFiltering = useSequenceFiltering;
    }

    public void setDisableConstraints(boolean disableConstraints) {
        this.disableConstraints = disableConstraints;
    }

    public void setCleanBefore(boolean cleanBefore) {
        this.cleanBefore = cleanBefore;
    }

    public void setCleanAfter(boolean cleanAfter) {
        this.cleanAfter = cleanAfter;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String dataset : this.datasets) {
            sb.append(dataset).append(",");
        }
        if (sb.toString().contains(",")) {
            sb.deleteCharAt(sb.lastIndexOf(","));
        }
        return sb.toString().trim();
    }

    public boolean hasDatasets() {
        if (this.datasets == null || this.datasets.length == 0) {
            return false;
        }
        for (String dataset : this.datasets) {
            if (dataset == null || "".equals(dataset.trim())) continue;
            return true;
        }
        return false;
    }
}

