/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.connection;

import com.github.database.rider.core.api.connection.ConnectionHolder;
import com.github.database.rider.core.configuration.DBUnitConfig;
import com.github.database.rider.core.util.DriverUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.ext.h2.H2DataTypeFactory;
import org.dbunit.ext.hsqldb.HsqldbDataTypeFactory;
import org.dbunit.ext.mysql.MySqlDataTypeFactory;
import org.dbunit.ext.oracle.Oracle10DataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;

public class RiderDataSource {
    private final ConnectionHolder connectionHolder;
    private final DBUnitConfig dbUnitConfig;
    private Connection connection;
    private DatabaseConnection dbUnitConnection;
    private DBType dbType;

    public RiderDataSource(ConnectionHolder connectionHolder, DBUnitConfig dbUnitConfig) throws SQLException {
        this.connectionHolder = connectionHolder;
        this.dbUnitConfig = dbUnitConfig;
        this.init();
    }

    public Connection getConnection() throws SQLException {
        if (!this.dbUnitConfig.isCacheConnection().booleanValue() || this.connection == null || this.connection.isClosed()) {
            this.connection = this.connectionHolder.getConnection();
        }
        return this.connection;
    }

    public DatabaseConnection getDBUnitConnection() throws SQLException {
        if (!this.dbUnitConfig.isCacheConnection().booleanValue()) {
            this.initDBUnitConnection();
        }
        return this.dbUnitConnection;
    }

    public DBType getDBType() {
        return this.dbType;
    }

    private void init() throws SQLException {
        Connection conn = this.getConnection();
        if (conn != null) {
            this.dbType = this.resolveDBType(DriverUtils.getDriverName(conn));
            this.initDBUnitConnection();
        }
    }

    private void initDBUnitConnection() throws SQLException {
        try {
            this.dbUnitConnection = new DatabaseConnection(this.getConnection());
            this.configDatabaseProperties();
        }
        catch (DatabaseUnitException e) {
            throw new SQLException(e);
        }
    }

    private void configDatabaseProperties() {
        DatabaseConfig config = this.dbUnitConnection.getConfig();
        for (Map.Entry<String, Object> p : this.dbUnitConfig.getProperties().entrySet()) {
            DatabaseConfig.ConfigProperty byShortName = DatabaseConfig.findByShortName((String)p.getKey());
            if (byShortName == null) continue;
            config.setProperty(byShortName.getProperty(), p.getValue());
        }
        switch (this.dbType) {
            case HSQLDB: {
                config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new HsqldbDataTypeFactory());
                break;
            }
            case H2: {
                config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new H2DataTypeFactory());
                break;
            }
            case MYSQL: {
                config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new MySqlDataTypeFactory());
                break;
            }
            case POSTGRESQL: {
                config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new PostgresqlDataTypeFactory());
                break;
            }
            case ORACLE: {
                config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new Oracle10DataTypeFactory());
            }
        }
    }

    private DBType resolveDBType(String driverName) {
        if (DriverUtils.isHsql(driverName)) {
            return DBType.HSQLDB;
        }
        if (DriverUtils.isH2(driverName)) {
            return DBType.H2;
        }
        if (DriverUtils.isMysql(driverName)) {
            return DBType.MYSQL;
        }
        if (DriverUtils.isPostgre(driverName)) {
            return DBType.POSTGRESQL;
        }
        if (DriverUtils.isOracle(driverName)) {
            return DBType.ORACLE;
        }
        return DBType.UNKNOWN;
    }

    public static enum DBType {
        HSQLDB,
        H2,
        MYSQL,
        ORACLE,
        POSTGRESQL,
        UNKNOWN;

    }
}

