/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.dataset;

import com.github.database.rider.core.api.connection.ConnectionHolder;
import com.github.database.rider.core.api.dataset.DataSetExecutor;
import com.github.database.rider.core.api.dataset.JSONDataSet;
import com.github.database.rider.core.api.dataset.ScriptableDataSet;
import com.github.database.rider.core.api.dataset.YamlDataSet;
import com.github.database.rider.core.assertion.DataSetAssertion;
import com.github.database.rider.core.configuration.ConnectionConfig;
import com.github.database.rider.core.configuration.DBUnitConfig;
import com.github.database.rider.core.configuration.DataSetConfig;
import com.github.database.rider.core.connection.RiderDataSource;
import com.github.database.rider.core.exception.DataBaseSeedingException;
import com.github.database.rider.core.replacer.DateTimeReplacer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.JarURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.csv.CsvDataSet;
import org.dbunit.dataset.excel.XlsDataSet;
import org.dbunit.dataset.filter.DefaultColumnFilter;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.SequenceTableFilter;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.operation.DatabaseOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetExecutorImpl
implements DataSetExecutor {
    public static final String DEFAULT_EXECUTOR_ID = "default";
    private static final Logger log = LoggerFactory.getLogger(DataSetExecutorImpl.class);
    private static Map<String, DataSetExecutorImpl> executors = new ConcurrentHashMap<String, DataSetExecutorImpl>();
    private AtomicBoolean printDBUnitConfig = new AtomicBoolean(true);
    private DBUnitConfig dbUnitConfig;
    private static String SEQUENCE_TABLE_NAME = System.getProperty("SEQUENCE_TABLE_NAME") == null ? "SEQ" : System.getProperty("SEQUENCE_TABLE_NAME");
    private RiderDataSource riderDataSource;
    private ConnectionHolder connectionHolder;
    private String executorId;
    private List<String> tableNames;
    private String schemaName;
    private boolean isContraintsDisabled = false;

    public static DataSetExecutorImpl instance(ConnectionHolder connectionHolder) {
        return DataSetExecutorImpl.instance(DEFAULT_EXECUTOR_ID, connectionHolder);
    }

    public static DataSetExecutorImpl instance(String executorId, ConnectionHolder connectionHolder) {
        DataSetExecutorImpl instance = executors.get(executorId);
        if (instance == null) {
            instance = new DataSetExecutorImpl(executorId, connectionHolder, DBUnitConfig.fromGlobalConfig().executorId(executorId));
            log.debug("creating executor instance " + executorId);
            executors.put(executorId, instance);
        } else if (!instance.dbUnitConfig.isCacheConnection().booleanValue()) {
            instance.setConnectionHolder(connectionHolder);
        }
        return instance;
    }

    private DataSetExecutorImpl(String executorId, ConnectionHolder connectionHolder, DBUnitConfig dbUnitConfig) {
        this.connectionHolder = connectionHolder;
        this.executorId = executorId;
        this.dbUnitConfig = dbUnitConfig;
    }

    @Override
    public void createDataSet(DataSetConfig dataSetConfig) {
        if (this.printDBUnitConfig.compareAndSet(true, false)) {
            StringBuilder sb = new StringBuilder(150);
            sb.append("cacheConnection: ").append("" + this.dbUnitConfig.isCacheConnection()).append("\n").append("cacheTableNames: ").append(this.dbUnitConfig.isCacheTableNames()).append("\n").append("leakHunter: ").append("" + this.dbUnitConfig.isLeakHunter()).append("\n");
            for (Map.Entry<String, Object> entry : this.dbUnitConfig.getProperties().entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
            log.info(String.format("DBUnit configuration for dataset executor '%s':\n" + sb.toString(), this.executorId));
        }
        if (dataSetConfig != null) {
            try {
                if (dataSetConfig.isDisableConstraints()) {
                    this.disableConstraints();
                }
                if (dataSetConfig.isCleanBefore()) {
                    try {
                        this.clearDatabase(dataSetConfig);
                    }
                    catch (SQLException e) {
                        LoggerFactory.getLogger((String)DataSetExecutorImpl.class.getName()).warn("Could not clean database before test.", (Throwable)e);
                    }
                }
                if (dataSetConfig.getExecuteStatementsBefore() != null && dataSetConfig.getExecuteStatementsBefore().length > 0) {
                    this.executeStatements(dataSetConfig.getExecuteStatementsBefore());
                }
                if (dataSetConfig.getExecuteScriptsBefore() != null && dataSetConfig.getExecuteScriptsBefore().length > 0) {
                    for (int i = 0; i < dataSetConfig.getExecuteScriptsBefore().length; ++i) {
                        this.executeScript(dataSetConfig.getExecuteScriptsBefore()[i]);
                    }
                }
                if (dataSetConfig.hasDatasets()) {
                    IDataSet resultingDataSet = this.loadDataSets(dataSetConfig.getDatasets());
                    resultingDataSet = this.performSequenceFiltering(dataSetConfig, resultingDataSet);
                    resultingDataSet = this.performTableOrdering(dataSetConfig, resultingDataSet);
                    resultingDataSet = this.performReplacements(resultingDataSet);
                    DatabaseOperation operation = dataSetConfig.getstrategy().getOperation();
                    operation.execute((IDatabaseConnection)this.getRiderDataSource().getDBUnitConnection(), resultingDataSet);
                }
            }
            catch (Exception e) {
                throw new DataBaseSeedingException("Could not initialize dataset: " + dataSetConfig, e);
            }
        }
    }

    @Override
    public IDataSet loadDataSet(String name) throws DataSetException, IOException {
        String[] dataSetNames = name.trim().split(",");
        ArrayList<ScriptableDataSet> dataSets = new ArrayList<ScriptableDataSet>();
        for (String dataSet : dataSetNames) {
            String extension;
            ScriptableDataSet target = null;
            String dataSetName = dataSet.trim();
            switch (extension = dataSetName.substring(dataSetName.lastIndexOf(46) + 1).toLowerCase()) {
                case "yml": {
                    target = new ScriptableDataSet(new YamlDataSet(this.getDataSetStream(dataSetName), this.dbUnitConfig));
                    break;
                }
                case "xml": {
                    try {
                        target = new ScriptableDataSet((IDataSet)new FlatXmlDataSetBuilder().build(this.getDataSetUrl(dataSetName)));
                    }
                    catch (Exception e) {
                        target = new ScriptableDataSet((IDataSet)new FlatXmlDataSetBuilder().build(this.getDataSetStream(dataSetName)));
                    }
                    break;
                }
                case "csv": {
                    target = new ScriptableDataSet((IDataSet)new CsvDataSet(new File(this.getClass().getClassLoader().getResource(dataSetName).getFile()).getParentFile()));
                    break;
                }
                case "xls": {
                    target = new ScriptableDataSet((IDataSet)new XlsDataSet(this.getDataSetStream(dataSetName)));
                    break;
                }
                case "json": {
                    target = new ScriptableDataSet((IDataSet)new JSONDataSet(this.getDataSetStream(dataSetName)));
                    break;
                }
                default: {
                    log.error("Unsupported dataset extension");
                }
            }
            if (target == null) continue;
            dataSets.add(target);
        }
        if (dataSets.isEmpty()) {
            throw new RuntimeException("No dataset loaded for name " + name);
        }
        return new CompositeDataSet(dataSets.toArray(new IDataSet[dataSets.size()]));
    }

    private URL getDataSetUrl(String dataSet) {
        URL resource;
        if (!dataSet.startsWith("/")) {
            dataSet = "/" + dataSet;
        }
        if ((resource = this.getClass().getResource(dataSet)) == null) {
            resource = this.getClass().getResource("/datasets" + dataSet);
        }
        if (resource == null) {
            throw new RuntimeException(String.format("Could not find dataset '%s' under 'resources' or 'resources/datasets' directory.", dataSet.substring(1)));
        }
        return resource;
    }

    @Override
    public IDataSet loadDataSets(String[] datasets) throws DataSetException, IOException {
        ArrayList<IDataSet> dataSetList = new ArrayList<IDataSet>();
        for (String name : datasets) {
            dataSetList.add(this.loadDataSet(name));
        }
        return new CompositeDataSet(dataSetList.toArray(new IDataSet[dataSetList.size()]));
    }

    private IDataSet performTableOrdering(DataSetConfig dataSet, IDataSet target) throws AmbiguousTableNameException {
        if (dataSet.getTableOrdering().length > 0) {
            target = new FilteredDataSet((ITableFilter)new SequenceTableFilter(dataSet.getTableOrdering()), target);
        }
        return target;
    }

    private IDataSet performSequenceFiltering(DataSetConfig dataSet, IDataSet target) throws DatabaseUnitException, SQLException {
        if (dataSet.isUseSequenceFiltering()) {
            DatabaseSequenceFilter filteredTable = new DatabaseSequenceFilter((IDatabaseConnection)this.getRiderDataSource().getDBUnitConnection(), target.getTableNames());
            target = new FilteredDataSet((ITableFilter)filteredTable, target);
        }
        return target;
    }

    private void disableConstraints() throws SQLException {
        switch (this.getRiderDataSource().getDBType()) {
            case HSQLDB: {
                this.getRiderDataSource().getConnection().createStatement().execute("SET DATABASE REFERENTIAL INTEGRITY FALSE;");
                break;
            }
            case H2: {
                this.getRiderDataSource().getConnection().createStatement().execute("SET foreign_key_checks = 0;");
                break;
            }
            case MYSQL: {
                this.getRiderDataSource().getConnection().createStatement().execute(" SET FOREIGN_KEY_CHECKS=0;");
                break;
            }
            case POSTGRESQL: {
                this.getRiderDataSource().getConnection().createStatement().execute("SET CONSTRAINTS ALL DEFERRED;");
                break;
            }
            case ORACLE: {
                Connection connection = null;
                Statement queryStatement = null;
                ResultSet resultSet = null;
                String schemaName = "";
                String tableName = "";
                try {
                    connection = this.getRiderDataSource().getConnection();
                    queryStatement = connection.createStatement();
                    schemaName = this.resolveSchema();
                    resultSet = queryStatement.executeQuery("select TABLE_NAME, CONSTRAINT_NAME from ALL_CONSTRAINTS where CONSTRAINT_TYPE = 'R' " + (schemaName != null ? "and OWNER = '" + schemaName + "'" : "") + " and CONSTRAINT_NAME not like 'BIN$%' and STATUS <> 'DISABLED'");
                    while (resultSet.next()) {
                        schemaName = this.resolveSchema(resultSet);
                        tableName = resultSet.getString("TABLE_NAME");
                        boolean hasSchema = schemaName != null && !"".equals(schemaName.trim());
                        String constraintName = resultSet.getString("CONSTRAINT_NAME");
                        String qualifiedTableName = hasSchema ? "'" + schemaName + "'.'" + tableName + "'" : "'" + tableName + "'";
                        this.executeStatements("alter table " + qualifiedTableName + " disable constraint '" + constraintName + "'");
                    }
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while disabling referential constraints on schema " + schemaName, e);
                }
            }
        }
        this.isContraintsDisabled = true;
    }

    @Override
    public void enableConstraints() throws SQLException {
        if (this.isContraintsDisabled) {
            switch (this.getRiderDataSource().getDBType()) {
                case HSQLDB: {
                    this.getRiderDataSource().getConnection().createStatement().execute("SET DATABASE REFERENTIAL INTEGRITY TRUE;");
                    break;
                }
                case H2: {
                    this.getRiderDataSource().getConnection().createStatement().execute("SET foreign_key_checks = 1;");
                    break;
                }
                case MYSQL: {
                    this.getRiderDataSource().getConnection().createStatement().execute(" SET FOREIGN_KEY_CHECKS=1;");
                    break;
                }
                case ORACLE: {
                    Connection connection = null;
                    Statement queryStatement = null;
                    ResultSet resultSet = null;
                    String schemaName = "";
                    String tableName = "";
                    try {
                        connection = this.getRiderDataSource().getConnection();
                        queryStatement = connection.createStatement();
                        schemaName = this.resolveSchema();
                        resultSet = queryStatement.executeQuery("select TABLE_NAME, CONSTRAINT_NAME from ALL_CONSTRAINTS where CONSTRAINT_TYPE = 'R' " + (schemaName != null ? "and OWNER = '" + schemaName + "'" : "") + " and CONSTRAINT_NAME not like 'BIN$%' and STATUS = 'DISABLED'");
                        while (resultSet.next()) {
                            tableName = resultSet.getString("TABLE_NAME");
                            boolean hasSchema = schemaName != null && !"".equals(schemaName.trim());
                            String constraintName = resultSet.getString("CONSTRAINT_NAME");
                            String qualifiedTableName = hasSchema ? "'" + schemaName + "'.'" + tableName + "'" : "'" + tableName + "'";
                            this.executeStatements("alter table " + qualifiedTableName + " enable constraint '" + constraintName + "'");
                        }
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error while enabling referential constraints on schema " + schemaName, e);
                    }
                }
            }
            this.isContraintsDisabled = false;
        }
    }

    @Override
    public void executeStatements(String ... statements) {
        if (statements != null && statements.length > 0 && !"".equals(statements[0].trim())) {
            try {
                boolean autoCommit = this.getRiderDataSource().getConnection().getAutoCommit();
                this.getRiderDataSource().getConnection().setAutoCommit(false);
                Statement statement = this.getRiderDataSource().getConnection().createStatement(1005, 1008);
                for (String stm : statements) {
                    statement.addBatch(stm);
                }
                statement.executeBatch();
                this.getRiderDataSource().getConnection().commit();
                this.getRiderDataSource().getConnection().setAutoCommit(autoCommit);
            }
            catch (Exception e) {
                log.error("Could execute statements:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private IDataSet performReplacements(IDataSet dataSet) {
        IDataSet replace = DateTimeReplacer.replace(dataSet);
        return replace;
    }

    private void setConnectionHolder(ConnectionHolder connectionHolder) {
        this.connectionHolder = connectionHolder;
        this.riderDataSource = null;
    }

    @Override
    public void initConnectionFromConfig(final ConnectionConfig connectionConfig) {
        this.setConnectionHolder(new ConnectionHolder(){
            Connection connection;

            @Override
            public Connection getConnection() throws SQLException {
                if (this.connection == null) {
                    this.connection = DataSetExecutorImpl.this.getConnectionFromConfig(connectionConfig);
                }
                return this.connection;
            }
        });
    }

    private Connection getConnectionFromConfig(ConnectionConfig connectionConfig) throws SQLException {
        if ("".equals(connectionConfig.getUrl()) || "".equals(connectionConfig.getUser())) {
            throw new RuntimeException("Could not create JDBC connection, provide a connection at test level or via configuration, see documentation here: https://github.com/database-rider/database-rider#jdbc-connection");
        }
        if (!"".equals(connectionConfig.getDriver())) {
            try {
                Class.forName(connectionConfig.getDriver());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return DriverManager.getConnection(connectionConfig.getUrl(), connectionConfig.getUser(), connectionConfig.getPassword());
    }

    public Connection getConnection() {
        try {
            return this.getRiderDataSource().getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof DataSetExecutorImpl)) {
            return false;
        }
        DataSetExecutorImpl otherExecutor = (DataSetExecutorImpl)other;
        if (this.riderDataSource == null || otherExecutor.riderDataSource == null) {
            return false;
        }
        try {
            if (this.riderDataSource.getDBUnitConnection().getConnection() == null || otherExecutor.riderDataSource.getDBUnitConnection().getConnection() == null) {
                return false;
            }
            if (!this.riderDataSource.getDBUnitConnection().getConnection().getMetaData().getURL().equals(otherExecutor.riderDataSource.getDBUnitConnection().getConnection().getMetaData().getURL())) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public String getExecutorId() {
        return this.executorId;
    }

    public static DataSetExecutorImpl getExecutorById(String id) {
        return executors.get(id);
    }

    private InputStream getDataSetStream(String dataSet) {
        InputStream is;
        if (!dataSet.startsWith("/")) {
            dataSet = "/" + dataSet;
        }
        if ((is = this.getClass().getResourceAsStream(dataSet)) == null) {
            is = this.getClass().getResourceAsStream("/datasets" + dataSet);
        }
        if (is == null) {
            throw new RuntimeException(String.format("Could not find dataset '%s' under 'resources' or 'resources/datasets' directory.", dataSet.substring(1)));
        }
        return is;
    }

    @Override
    public void clearDatabase(DataSetConfig dataset) throws SQLException {
        Connection connection = this.getRiderDataSource().getConnection();
        if (dataset != null && dataset.getTableOrdering() != null && dataset.getTableOrdering().length > 0) {
            for (String table : dataset.getTableOrdering()) {
                if (table.toUpperCase().contains(SEQUENCE_TABLE_NAME)) continue;
                connection.createStatement().executeUpdate("DELETE FROM " + table + " where 1=1");
                connection.commit();
            }
        }
        List<String> tables = this.getTableNames(connection);
        for (String tableName : tables) {
            if (tableName.toUpperCase().contains(SEQUENCE_TABLE_NAME)) continue;
            try {
                connection.createStatement().executeUpdate("DELETE FROM " + tableName + " where 1=1");
                connection.commit();
            }
            catch (Exception e) {
                log.warn("Could not clear table " + tableName + ", message:" + e.getMessage() + ", cause: " + e.getCause());
            }
        }
    }

    private List<String> getTableNames(Connection con) {
        ArrayList<String> tables = new ArrayList<String>();
        if (this.tableNames != null && this.dbUnitConfig.isCacheTableNames().booleanValue()) {
            return this.tableNames;
        }
        ResultSet result = null;
        try {
            DatabaseMetaData metaData = con.getMetaData();
            result = metaData.getTables(null, null, "%", new String[]{"TABLE"});
            while (result.next()) {
                String schema = this.resolveSchema(result);
                String name = result.getString("TABLE_NAME");
                tables.add(schema != null ? schema + "." + name : name);
            }
            if (this.tableNames == null) {
                this.tableNames = new ArrayList<String>();
                this.tableNames.addAll(tables);
            }
            return tables;
        }
        catch (SQLException ex) {
            log.warn("An exception occured while trying toanalyse the database.", (Throwable)ex);
            return new ArrayList<String>();
        }
    }

    private String resolveSchema(ResultSet result) {
        try {
            if (this.schemaName == null) {
                this.schemaName = result.getString("TABLE_SCHEMA");
            }
            return this.schemaName;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String resolveSchema() {
        try {
            if (this.schemaName == null) {
                DatabaseMetaData metaData = this.getRiderDataSource().getConnection().getMetaData();
                ResultSet result = metaData.getTables(null, null, "%", new String[]{"TABLE"});
                this.schemaName = this.resolveSchema(result);
            }
            return this.schemaName;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void executeScript(String scriptPath) {
        if (scriptPath != null && !"".equals(scriptPath)) {
            URL resource;
            if (!scriptPath.startsWith("/")) {
                scriptPath = "/" + scriptPath;
            }
            if ((resource = this.getClass().getResource(scriptPath.trim())) == null) {
                resource = this.getClass().getResource("/scripts" + scriptPath.trim());
            }
            if (resource == null) {
                throw new RuntimeException(String.format("Could not find script %s in classpath", scriptPath));
            }
            String[] scriptsStatements = this.readScriptStatements(resource);
            if (scriptsStatements != null && scriptsStatements.length > 0) {
                this.executeStatements(scriptsStatements);
            }
        }
    }

    String[] readScriptStatements(URL resource) {
        String[] result = null;
        String absolutePath = resource.getFile();
        result = resource.getProtocol().equals("jar") ? this.readScriptStatementsFromJar(absolutePath) : this.readScriptStatementsFromFile(new File(absolutePath));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readScriptStatementsFromJar(String absolutePath) {
        String jarEntry = "jar:" + absolutePath;
        InputStreamReader r = null;
        try {
            JarURLConnection conn = (JarURLConnection)new URL(jarEntry).openConnection();
            r = new InputStreamReader(conn.getInputStream(), "UTF-8");
            StringBuilder sb = new StringBuilder();
            int data = r.read();
            while (data != -1) {
                sb.append((char)data);
                data = r.read();
            }
            List<String> statements = Arrays.asList(sb.toString().split(";"));
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < statements.size(); ++i) {
                String trimmedStmt = statements.get(i).trim();
                if ("".equals(trimmedStmt)) continue;
                result.add(trimmedStmt);
            }
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        catch (IOException e) {
            log.warn(String.format("Could not read script file %s.", jarEntry), (Throwable)e);
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException e) {
                log.warn("Could not close script file " + jarEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readScriptStatementsFromFile(File scriptFile) {
        RandomAccessFile rad = null;
        int lineNum = 0;
        try {
            String[] lineScripts;
            String line;
            rad = new RandomAccessFile(scriptFile, "r");
            ArrayList<String> scripts = new ArrayList<String>();
            while ((line = rad.readLine()) != null) {
                lineScripts = line.split(";");
                for (int i = 0; i < lineScripts.length; ++i) {
                    scripts.add(lineScripts[i]);
                }
                ++lineNum;
            }
            lineScripts = scripts.toArray(new String[scripts.size()]);
            return lineScripts;
        }
        catch (Exception e) {
            log.warn(String.format("Could not read script file %s. Error in line %d.", scriptFile.getAbsolutePath(), lineNum), (Throwable)e);
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (rad != null) {
                try {
                    rad.close();
                }
                catch (IOException e) {
                    log.warn("Could not close script file " + scriptFile.getAbsolutePath());
                }
            }
        }
    }

    @Override
    public void compareCurrentDataSetWith(DataSetConfig expectedDataSetConfig, String[] excludeCols) throws DatabaseUnitException {
        IDataSet current = null;
        IDataSet expected = null;
        try {
            current = this.getRiderDataSource().getDBUnitConnection().createDataSet();
            expected = this.loadDataSets(expectedDataSetConfig.getDatasets());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create dataset to compare.", e);
        }
        String[] tableNames = null;
        try {
            tableNames = expected.getTableNames();
        }
        catch (DataSetException e) {
            throw new RuntimeException("Could not extract dataset table names.", e);
        }
        for (String tableName : tableNames) {
            ITable expectedTable = null;
            ITable actualTable = null;
            try {
                expectedTable = expected.getTable(tableName);
                actualTable = current.getTable(tableName);
            }
            catch (DataSetException e) {
                throw new RuntimeException("DataSet comparison failed due to following exception: ", e);
            }
            ITable filteredActualTable = DefaultColumnFilter.includedColumnsTable((ITable)actualTable, (Column[])expectedTable.getTableMetaData().getColumns());
            DataSetAssertion.assertEqualsIgnoreCols(expectedTable, filteredActualTable, excludeCols);
        }
    }

    @Override
    public void setDBUnitConfig(DBUnitConfig dbUnitConfig) {
        if (this.dbUnitConfig != dbUnitConfig) {
            this.dbUnitConfig = dbUnitConfig;
            this.riderDataSource = null;
        }
    }

    @Override
    public DBUnitConfig getDBUnitConfig() {
        return this.dbUnitConfig;
    }

    @Override
    public RiderDataSource getRiderDataSource() throws SQLException {
        if (this.riderDataSource == null) {
            if (this.connectionHolder == null) {
                this.initConnectionFromConfig(this.dbUnitConfig.getConnectionConfig());
            }
            this.riderDataSource = new RiderDataSource(this.connectionHolder, this.dbUnitConfig);
        }
        return this.riderDataSource;
    }

    public void clearRiderDataSource() {
        this.riderDataSource = null;
    }
}

