/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.util;

import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.hibernate.Session;
import org.hibernate.internal.SessionImpl;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerProvider
implements TestRule {
    private static Map<String, EntityManagerProvider> providers = new ConcurrentHashMap<String, EntityManagerProvider>();
    private EntityManagerFactory emf;
    private EntityManager em;
    private EntityTransaction tx;
    private Connection conn;
    private static EntityManagerProvider instance;
    private static Logger log;

    private EntityManagerProvider() {
    }

    public static synchronized EntityManagerProvider instance(String unitName) {
        instance = providers.get(unitName);
        if (instance == null) {
            instance = new EntityManagerProvider();
            providers.put(unitName, instance);
        }
        try {
            instance.init(unitName);
        }
        catch (Exception e) {
            log.error("Could not initialize persistence unit " + unitName, (Throwable)e);
        }
        return instance;
    }

    public static synchronized EntityManagerProvider newInstance(String unitName) {
        instance = new EntityManagerProvider();
        providers.put(unitName, instance);
        try {
            instance.init(unitName);
        }
        catch (Exception e) {
            log.error("Could not initialize persistence unit " + unitName, (Throwable)e);
        }
        return instance;
    }

    private void init(String unitName) {
        if (this.emf == null) {
            log.debug("creating emf for unit " + unitName);
            this.emf = Persistence.createEntityManagerFactory((String)unitName);
            this.em = this.emf.createEntityManager();
            this.tx = this.em.getTransaction();
            if (this.isHibernateOnClasspath() && this.em.getDelegate() instanceof Session) {
                this.conn = ((SessionImpl)this.em.unwrap(Session.class)).connection();
            } else {
                this.tx.begin();
                this.conn = (Connection)this.em.unwrap(Connection.class);
                this.tx.commit();
            }
        }
        this.emf.getCache().evictAll();
    }

    public Connection connection(String puName) {
        return EntityManagerProvider.instance((String)puName).conn;
    }

    public Connection connection() {
        EntityManagerProvider.checkInstance();
        return EntityManagerProvider.instance.conn;
    }

    public static EntityManager em(String puName) {
        return EntityManagerProvider.instance((String)puName).em;
    }

    public static EntityManagerFactory emf(String puName) {
        return EntityManagerProvider.instance((String)puName).emf;
    }

    public static EntityManager em() {
        EntityManagerProvider.checkInstance();
        return EntityManagerProvider.instance.em;
    }

    public EntityManager getEm() {
        return EntityManagerProvider.em();
    }

    public static EntityManagerFactory emf() {
        return EntityManagerProvider.instance.emf;
    }

    public EntityManagerFactory getEmf() {
        return EntityManagerProvider.instance.emf;
    }

    public EntityManager getEm(String puName) {
        return EntityManagerProvider.em(puName);
    }

    public static EntityManagerProvider clear(String puName) {
        EntityManagerProvider.em(puName).clear();
        EntityManagerProvider.emf(puName).getCache().evictAll();
        return providers.get(puName);
    }

    public static EntityManagerProvider clear() {
        EntityManagerProvider.em().clear();
        EntityManagerProvider.emf().getCache().evictAll();
        return instance;
    }

    public static EntityTransaction tx(String puName) {
        return EntityManagerProvider.em(puName).getTransaction();
    }

    public static EntityTransaction tx() {
        EntityManagerProvider.checkInstance();
        return EntityManagerProvider.instance.tx;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                base.evaluate();
                instance.em.clear();
            }
        };
    }

    private boolean isHibernateOnClasspath() {
        try {
            Class.forName("org.hibernate.Session");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void checkInstance() {
        if (instance == null) {
            throw new IllegalStateException("Call instance('PU_NAME') before calling em()");
        }
    }

    public static boolean isEntityManagerActive() {
        return instance != null && EntityManagerProvider.em().isOpen();
    }

    static {
        log = LoggerFactory.getLogger(EntityManagerProvider.class);
    }
}

