/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.api.dataset;

import com.github.database.rider.core.api.configuration.Orthography;
import com.github.database.rider.core.configuration.DBUnitConfig;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.dbunit.database.CyclicTablesDependencyException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.search.TablesDependencyHelper;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.filter.SequenceTableFilter;
import org.dbunit.util.search.SearchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiderSequenceFilter
extends SequenceTableFilter {
    private static final Logger logger = LoggerFactory.getLogger(RiderSequenceFilter.class);
    private static final Map<String, DependencyInfo> DEPENDENCY_INFO_CACHE = new ConcurrentHashMap<String, DependencyInfo>();

    public RiderSequenceFilter(IDatabaseConnection connection, String[] tableNames, DBUnitConfig dbUnitConfig) throws DataSetException, SQLException {
        super(RiderSequenceFilter.sortTableNames(connection, tableNames, dbUnitConfig));
    }

    public RiderSequenceFilter(IDatabaseConnection connection, DBUnitConfig dbUnitConfig) throws DataSetException, SQLException {
        this(connection, connection.createDataSet().getTableNames(), dbUnitConfig);
    }

    static String[] sortTableNames(IDatabaseConnection connection, String[] tableNames, DBUnitConfig dbUnitConfig) throws DataSetException, SQLException {
        logger.debug("sortTableNames(connection={}, tableNames={}) - start", (Object)connection, (Object)tableNames);
        HashMap<String, DependencyInfo> dependencies = new HashMap<String, DependencyInfo>();
        try {
            for (int i = 0; i < tableNames.length; ++i) {
                String tableName = tableNames[i];
                DependencyInfo info = RiderSequenceFilter.getDependencyInfo(connection, tableName, dbUnitConfig);
                dependencies.put(tableName, info);
            }
        }
        catch (SearchException e) {
            throw new DataSetException("Exception while searching the dependent tables.", (Throwable)e);
        }
        for (DependencyInfo info : dependencies.values()) {
            info.checkCycles();
        }
        return RiderSequenceFilter.sort(tableNames, dependencies);
    }

    private static String[] sort(String[] tableNames, Map dependencies) {
        logger.debug("sort(tableNames={}, dependencies={}) - start", (Object)tableNames, (Object)dependencies);
        boolean reprocess = true;
        List tmpTableNames = Arrays.asList(tableNames);
        LinkedList<String> sortedTableNames = null;
        while (reprocess) {
            sortedTableNames = new LinkedList<String>();
            Iterator<String> i = tmpTableNames.iterator();
            while (i.hasNext()) {
                boolean foundDependentInSortedTableNames = false;
                String tmpTable = i.next();
                DependencyInfo tmpTableDependents = (DependencyInfo)dependencies.get(tmpTable);
                int sortedTableIndex = -1;
                for (String sortedTable : sortedTableNames) {
                    if (!tmpTableDependents.containsDirectDependsOn(sortedTable)) continue;
                    sortedTableIndex = sortedTableNames.indexOf(sortedTable);
                    foundDependentInSortedTableNames = true;
                    break;
                }
                if (foundDependentInSortedTableNames) {
                    if (sortedTableIndex < 0) {
                        throw new IllegalStateException("sortedTableIndex should be 0 or greater, but is " + sortedTableIndex);
                    }
                    sortedTableNames.add(sortedTableIndex, tmpTable);
                    continue;
                }
                sortedTableNames.add(tmpTable);
            }
            if (tmpTableNames.equals(sortedTableNames)) {
                reprocess = false;
                continue;
            }
            tmpTableNames = null;
            tmpTableNames = (List)sortedTableNames.clone();
        }
        return sortedTableNames.toArray(new String[0]);
    }

    private static DependencyInfo getDependencyInfo(IDatabaseConnection connection, String tableName, DBUnitConfig dbUnitConfig) throws SearchException {
        logger.debug("getDependencyInfo(connection={}, tableName={}) - start", (Object)connection, (Object)tableName);
        if (!dbUnitConfig.isCaseSensitiveTableNames() && tableName != null) {
            tableName = RiderSequenceFilter.applyCaseInSensitiveStrategy(tableName, dbUnitConfig);
        }
        if (DEPENDENCY_INFO_CACHE.containsKey(tableName)) {
            return DEPENDENCY_INFO_CACHE.get(tableName);
        }
        String[] allDependentTables = TablesDependencyHelper.getDependentTables((IDatabaseConnection)connection, (String)tableName);
        String[] allDependsOnTables = TablesDependencyHelper.getDependsOnTables((IDatabaseConnection)connection, (String)tableName);
        HashSet<String> allDependentTablesSet = new HashSet<String>(Arrays.asList(allDependentTables));
        HashSet<String> allDependsOnTablesSet = new HashSet<String>(Arrays.asList(allDependsOnTables));
        allDependentTablesSet.remove(tableName);
        allDependsOnTablesSet.remove(tableName);
        Set directDependsOnTablesSet = TablesDependencyHelper.getDirectDependsOnTables((IDatabaseConnection)connection, (String)tableName);
        Set directDependentTablesSet = TablesDependencyHelper.getDirectDependentTables((IDatabaseConnection)connection, (String)tableName);
        directDependsOnTablesSet.remove(tableName);
        directDependentTablesSet.remove(tableName);
        DependencyInfo info = new DependencyInfo(tableName, directDependsOnTablesSet, directDependentTablesSet, allDependsOnTablesSet, allDependentTablesSet);
        DEPENDENCY_INFO_CACHE.put(tableName, info);
        logger.debug("New DependencyInfo for {} created}", (Object)tableName);
        return info;
    }

    private static String applyCaseInSensitiveStrategy(String tableName, DBUnitConfig dbUnitConfig) {
        if (tableName == null) {
            return tableName;
        }
        return Orthography.UPPERCASE.equals((Object)dbUnitConfig.getCaseInsensitiveStrategy()) ? tableName.toUpperCase() : tableName.toLowerCase();
    }

    static class DependencyInfo {
        private static final Logger logger = LoggerFactory.getLogger(RiderSequenceFilter.class);
        private String tableName;
        private Set allTableDependsOn;
        private Set allTableDependent;
        private Set directDependsOnTablesSet;
        private Set directDependentTablesSet;

        public DependencyInfo(String tableName, Set directDependsOnTablesSet, Set directDependentTablesSet, Set allTableDependsOn, Set allTableDependent) {
            this.directDependsOnTablesSet = directDependsOnTablesSet;
            this.directDependentTablesSet = directDependentTablesSet;
            this.allTableDependsOn = allTableDependsOn;
            this.allTableDependent = allTableDependent;
            this.tableName = tableName;
        }

        public boolean containsDirectDependent(String tableName) {
            return this.directDependentTablesSet.contains(tableName);
        }

        public boolean containsDirectDependsOn(String tableName) {
            return this.directDependsOnTablesSet.contains(tableName);
        }

        public String getTableName() {
            return this.tableName;
        }

        public Set getAllTableDependsOn() {
            return this.allTableDependsOn;
        }

        public Set getAllTableDependent() {
            return this.allTableDependent;
        }

        public Set getDirectDependsOnTablesSet() {
            return this.directDependsOnTablesSet;
        }

        public Set getDirectDependentTablesSet() {
            return this.directDependentTablesSet;
        }

        public void checkCycles() throws CyclicTablesDependencyException {
            logger.debug("checkCycles() - start");
            HashSet intersect = new HashSet(this.allTableDependsOn);
            intersect.retainAll(this.allTableDependent);
            if (!intersect.isEmpty()) {
                throw new CyclicTablesDependencyException(this.tableName, intersect);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("DependencyInfo[");
            sb.append("table=").append(this.tableName);
            sb.append(", directDependsOn=").append(this.directDependsOnTablesSet);
            sb.append(", directDependent=").append(this.directDependentTablesSet);
            sb.append(", allDependsOn=").append(this.allTableDependsOn);
            sb.append(", allDependent=").append(this.allTableDependent);
            sb.append("]");
            return sb.toString();
        }
    }
}

