/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.configuration;

import com.github.database.rider.core.api.dataset.DataSet;
import com.github.database.rider.core.api.dataset.DataSetProvider;
import com.github.database.rider.core.api.dataset.SeedStrategy;
import com.github.database.rider.core.replacers.Replacer;

public class DataSetConfig {
    private String[] datasets;
    private String executorId = "default";
    private SeedStrategy strategy = SeedStrategy.CLEAN_INSERT;
    private boolean useSequenceFiltering = true;
    private boolean disableConstraints = false;
    private boolean fillIdentityColumns = false;
    private boolean cleanBefore = false;
    private boolean cleanAfter = false;
    private boolean transactional = false;
    private String[] tableOrdering = new String[0];
    private String[] executeStatementsBefore = new String[0];
    private String[] executeStatementsAfter = new String[0];
    private String[] executeScriptsBefore = new String[0];
    private String[] executeScriptsAfter = new String[0];
    private Class<? extends DataSetProvider> provider;
    private String[] skipCleaningFor;
    private Class<? extends Replacer>[] replacers;

    public DataSetConfig() {
    }

    public DataSetConfig(String ... datasets) {
        this.datasets = datasets;
    }

    public DataSetConfig name(String ... datasets) {
        this.datasets = datasets;
        return this;
    }

    public DataSetConfig strategy(SeedStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public DataSetConfig useSequenceFiltering(boolean useSequenceFiltering) {
        this.useSequenceFiltering = useSequenceFiltering;
        return this;
    }

    public DataSetConfig disableConstraints(boolean disableConstraints) {
        this.disableConstraints = disableConstraints;
        return this;
    }

    public DataSetConfig fillIdentityColumns(boolean fillIdentityColumns) {
        this.fillIdentityColumns = fillIdentityColumns;
        return this;
    }

    public DataSetConfig tableOrdering(String ... tableOrdering) {
        this.tableOrdering = tableOrdering;
        return this;
    }

    public DataSetConfig cleanBefore(boolean cleanBefore) {
        this.cleanBefore = cleanBefore;
        return this;
    }

    public DataSetConfig cleanAfter(boolean cleanAfter) {
        this.cleanAfter = cleanAfter;
        return this;
    }

    public DataSetConfig executeStatementsBefore(String ... executeStatementsBefore) {
        this.executeStatementsBefore = executeStatementsBefore;
        return this;
    }

    public DataSetConfig executeStatementsAfter(String ... executeStatementsAfter) {
        this.executeStatementsAfter = executeStatementsAfter;
        return this;
    }

    public DataSetConfig executeScripsBefore(String ... executeScriptsBefore) {
        this.executeScriptsBefore = executeScriptsBefore;
        return this;
    }

    public DataSetConfig executeScriptsAfter(String ... executeScriptsAfter) {
        this.executeScriptsAfter = executeScriptsAfter;
        return this;
    }

    public DataSetConfig replacers(Class<? extends Replacer> ... replacers) {
        this.replacers = replacers;
        return this;
    }

    public DataSetConfig executorId(String executorId) {
        this.executorId = executorId;
        return this;
    }

    public DataSetConfig transactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    public DataSetConfig skipCleaningFor(String ... skipCleaningFor) {
        this.skipCleaningFor = skipCleaningFor;
        return this;
    }

    public DataSetConfig from(DataSet dataSet) {
        if (dataSet != null) {
            return this.name(dataSet.value()).strategy(dataSet.strategy()).useSequenceFiltering(dataSet.useSequenceFiltering()).tableOrdering(dataSet.tableOrdering()).disableConstraints(dataSet.disableConstraints()).fillIdentityColumns(dataSet.fillIdentityColumns()).executorId(dataSet.executorId()).executeStatementsBefore(dataSet.executeStatementsBefore()).executeScripsBefore(dataSet.executeScriptsBefore()).cleanBefore(dataSet.cleanBefore()).cleanAfter(dataSet.cleanAfter()).transactional(dataSet.transactional()).executeStatementsAfter(dataSet.executeStatementsAfter()).executeScriptsAfter(dataSet.executeScriptsAfter()).skipCleaningFor(dataSet.skipCleaningFor()).replacers(dataSet.replacers()).datasetProvider(dataSet.provider());
        }
        throw new RuntimeException("Cannot create DataSetConfig from Null DataSet");
    }

    public DataSetConfig datasetProvider(Class<? extends DataSetProvider> provider) {
        this.provider = provider;
        return this;
    }

    public String[] getDatasets() {
        return this.datasets;
    }

    public SeedStrategy getstrategy() {
        return this.strategy;
    }

    public boolean isUseSequenceFiltering() {
        return this.useSequenceFiltering;
    }

    public boolean isDisableConstraints() {
        return this.disableConstraints;
    }

    public boolean isFillIdentityColumns() {
        return this.fillIdentityColumns;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public String[] getTableOrdering() {
        return this.tableOrdering;
    }

    public String[] getExecuteStatementsBefore() {
        return this.executeStatementsBefore;
    }

    public String[] getExecuteStatementsAfter() {
        return this.executeStatementsAfter;
    }

    public String[] getExecuteScriptsBefore() {
        return this.executeScriptsBefore;
    }

    public String[] getExecuteScriptsAfter() {
        return this.executeScriptsAfter;
    }

    public String getExecutorId() {
        return this.executorId;
    }

    public Class<? extends DataSetProvider> getProvider() {
        return this.provider;
    }

    public boolean isCleanBefore() {
        return this.cleanBefore;
    }

    public boolean isCleanAfter() {
        return this.cleanAfter;
    }

    public Class<? extends Replacer>[] getReplacers() {
        return this.replacers;
    }

    public void setStrategy(SeedStrategy strategy) {
        this.strategy = strategy;
    }

    public void setUseSequenceFiltering(boolean useSequenceFiltering) {
        this.useSequenceFiltering = useSequenceFiltering;
    }

    public void setDisableConstraints(boolean disableConstraints) {
        this.disableConstraints = disableConstraints;
    }

    public void setCleanBefore(boolean cleanBefore) {
        this.cleanBefore = cleanBefore;
    }

    public void setCleanAfter(boolean cleanAfter) {
        this.cleanAfter = cleanAfter;
    }

    public String[] getSkipCleaningFor() {
        return this.skipCleaningFor;
    }

    public void setTableOrdering(String[] tableOrdering) {
        this.tableOrdering = tableOrdering;
    }

    public void setSkipCleaningFor(String[] skipCleaningFor) {
        this.skipCleaningFor = skipCleaningFor;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public void setReplacers(Class<? extends Replacer>[] replacers) {
        this.replacers = replacers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasDataSets()) {
            for (String dataset : this.datasets) {
                sb.append(dataset).append(", ");
            }
        }
        if (this.hasDataSetProvider()) {
            sb.append("dataset provider: " + this.provider.getName()).append(", ");
        }
        if (sb.toString().contains(",")) {
            sb.deleteCharAt(sb.lastIndexOf(","));
        }
        return sb.toString().trim();
    }

    public boolean hasDataSetProvider() {
        return this.provider != null && !this.provider.isInterface();
    }

    public boolean hasDataSets() {
        if (this.datasets == null || this.datasets.length == 0) {
            return false;
        }
        for (String dataset : this.datasets) {
            if (dataset == null || "".equals(dataset.trim())) continue;
            return true;
        }
        return false;
    }
}

