/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.dataset.builder;

import com.github.database.rider.core.configuration.DBUnitConfig;
import com.github.database.rider.core.dataset.builder.BasicRowBuilder;
import com.github.database.rider.core.dataset.builder.BuilderUtil;
import com.github.database.rider.core.dataset.builder.TableBuilder;
import java.util.Calendar;
import java.util.Date;
import org.dbunit.dataset.IDataSet;

public class ColumnBuilder
extends BasicRowBuilder {
    private final String[] columns;
    private final TableBuilder tableBuilder;

    public ColumnBuilder(TableBuilder tableBuilder, String tableName, DBUnitConfig config, String ... columns) {
        super(tableName, config);
        this.columns = columns;
        this.tableBuilder = tableBuilder;
    }

    public ColumnBuilder values(Object ... values) {
        if (values.length != this.columns.length) {
            throw new RuntimeException(String.format("Number of columns (%s) for table %s is different than the number of provided values (%s)", this.columns.length, this.getTableName(), values.length));
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (values[i] == null) continue;
            Object columnValue = values[i];
            if (columnValue instanceof Date || columnValue instanceof Calendar) {
                columnValue = this.formatDateValue(columnValue);
            }
            this.columnNameToValue.put(BuilderUtil.convertCase(this.columns[i], this.config), columnValue);
        }
        this.saveCurrentRow();
        return this;
    }

    private void saveCurrentRow() {
        this.tableBuilder.saveCurrentRow(this);
        this.columnNameToValue.clear();
    }

    public TableBuilder table(String tableName) {
        return this.tableBuilder.getDataSetBuilder().table(tableName);
    }

    public IDataSet build() {
        this.tableBuilder.getCurrentRowBuilder().setAdded(true);
        return this.tableBuilder.getDataSetBuilder().build();
    }
}

