/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.core.dataset.builder;

import com.github.database.rider.core.configuration.DBUnitConfig;
import com.github.database.rider.core.dataset.builder.BasicRowBuilder;
import com.github.database.rider.core.dataset.builder.BuilderUtil;
import com.github.database.rider.core.dataset.builder.TableBuilder;
import com.github.database.rider.core.dataset.builder.TableMetaDataBuilder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dbunit.dataset.CachedDataSet;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.stream.BufferedConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetBuilder {
    private CachedDataSet dataSet;
    private IDataSetConsumer consumer;
    private final Map<String, TableMetaDataBuilder> tableNameToMetaData = new HashMap<String, TableMetaDataBuilder>();
    private final Logger LOGGER = LoggerFactory.getLogger((String)this.getClass().getName());
    private final DBUnitConfig config;
    private TableBuilder tableBuilder;
    private final Map<String, Object> defaultValues = new LinkedHashMap<String, Object>();
    private String currentTableName;
    private final Map<String, Map<String, Object>> tableDefaultValues = new HashMap<String, Map<String, Object>>();

    public DataSetBuilder() {
        try {
            this.dataSet = new CachedDataSet();
            this.consumer = new BufferedConsumer((IDataSetConsumer)this.dataSet);
            this.consumer.startDataSet();
            this.config = DBUnitConfig.fromGlobalConfig();
        }
        catch (DataSetException e) {
            this.LOGGER.error("Could not create DataSetBuilder.", (Throwable)e);
            throw new RuntimeException("Could not create DataSetBuilder.", e);
        }
    }

    public DataSetBuilder(DBUnitConfig config) {
        try {
            this.dataSet = new CachedDataSet();
            this.consumer = new BufferedConsumer((IDataSetConsumer)this.dataSet);
            this.config = config;
            this.consumer.startDataSet();
        }
        catch (DataSetException e) {
            this.LOGGER.error("Could not create DataSetBuilder.", (Throwable)e);
            throw new RuntimeException("Could not create DataSetBuilder.", e);
        }
    }

    public TableBuilder table(String tableName) {
        this.tableBuilder = new TableBuilder(this, tableName, this.config);
        return this.tableBuilder;
    }

    public IDataSet build() {
        try {
            if (this.tableBuilder != null && !this.tableBuilder.getCurrentRowBuilder().isAdded() && this.tableBuilder.getCurrentRowBuilder().hasColumns()) {
                this.add(this.tableBuilder.getCurrentRowBuilder());
                this.tableBuilder.getCurrentRowBuilder().setAdded(true);
            }
            this.endTableIfNecessary();
            this.consumer.endDataSet();
            return this.dataSet;
        }
        catch (DataSetException e) {
            this.LOGGER.error("Could not create dataset.", (Throwable)e);
            throw new RuntimeException("Could not create DataSet.", e);
        }
    }

    public DataSetBuilder addDataSet(IDataSet iDataSet) {
        try {
            IDataSet[] dataSets = new IDataSet[]{this.build(), iDataSet};
            CompositeDataSet composite = new CompositeDataSet(dataSets);
            this.dataSet = new CachedDataSet((IDataSet)composite);
            this.consumer = new BufferedConsumer((IDataSetConsumer)this.dataSet);
            return this;
        }
        catch (DataSetException e) {
            this.LOGGER.error("Could not add dataset.", (Throwable)e);
            throw new RuntimeException("Could not add dataset.", e);
        }
    }

    public DataSetBuilder add(BasicRowBuilder row) {
        try {
            this.fillUndefinedColumns(row);
            ITableMetaData metaData = this.updateTableMetaData(row);
            Object[] values = this.extractValues(row, metaData);
            this.notifyConsumer(values);
            return this;
        }
        catch (DataSetException e) {
            this.LOGGER.error("Could not add dataset row.", (Throwable)e);
            throw new RuntimeException("Could not add dataset row.", e);
        }
    }

    public DataSetBuilder defaultValue(String columnName, Object value) {
        this.defaultValues.put(BuilderUtil.convertCase(columnName, this.config), value);
        return this;
    }

    private Object[] extractValues(BasicRowBuilder row, ITableMetaData metaData) throws DataSetException {
        return row.values(metaData.getColumns());
    }

    private void notifyConsumer(Object[] values) throws DataSetException {
        this.consumer.row(values);
    }

    private ITableMetaData updateTableMetaData(BasicRowBuilder row) throws DataSetException {
        TableMetaDataBuilder builder = this.metaDataBuilderFor(row.getTableName());
        int previousNumberOfColumns = builder.numberOfColumns();
        ITableMetaData metaData = builder.with(row.toMetaData()).build();
        int newNumberOfColumns = metaData.getColumns().length;
        boolean addedNewColumn = newNumberOfColumns > previousNumberOfColumns;
        this.handleTable(metaData, addedNewColumn);
        return metaData;
    }

    private void handleTable(ITableMetaData metaData, boolean addedNewColumn) throws DataSetException {
        if (this.isNewTable(metaData.getTableName())) {
            this.endTableIfNecessary();
            this.startTable(metaData);
        } else if (addedNewColumn) {
            this.startTable(metaData);
        }
    }

    private void startTable(ITableMetaData metaData) throws DataSetException {
        this.currentTableName = metaData.getTableName();
        this.consumer.startTable(metaData);
    }

    private void endTable() throws DataSetException {
        this.consumer.endTable();
        this.currentTableName = null;
    }

    private void endTableIfNecessary() throws DataSetException {
        if (this.hasCurrentTable()) {
            this.endTable();
        }
    }

    private boolean hasCurrentTable() {
        return this.currentTableName != null;
    }

    private boolean isNewTable(String tableName) {
        return this.currentTableName == null || !BuilderUtil.convertCase(this.currentTableName, this.config).equals(BuilderUtil.convertCase(tableName, this.config));
    }

    private TableMetaDataBuilder metaDataBuilderFor(String tableName) {
        String key = BuilderUtil.convertCase(tableName, this.config);
        if (this.containsKey(key)) {
            return this.tableNameToMetaData.get(key);
        }
        TableMetaDataBuilder builder = this.createNewTableMetaDataBuilder(tableName);
        this.tableNameToMetaData.put(key, builder);
        return builder;
    }

    protected TableMetaDataBuilder createNewTableMetaDataBuilder(String tableName) {
        return new TableMetaDataBuilder(tableName);
    }

    private boolean containsKey(String key) {
        return this.tableNameToMetaData.containsKey(key);
    }

    protected void fillUndefinedColumns(BasicRowBuilder row) {
        if (!this.defaultValues.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.defaultValues.entrySet()) {
                if (row.getColumnsValues().containsKey(entry.getKey())) continue;
                row.getColumnsValues().put(entry.getKey(), entry.getValue());
            }
        }
        if (this.hasDefaulValuesForTable(row.getTableName())) {
            for (Map.Entry<String, Object> column : this.getDefaultValuesForTable(row.getTableName()).entrySet()) {
                if (row.getColumnsValues().containsKey(column.getKey())) continue;
                row.getColumnsValues().put(column.getKey(), column.getValue());
            }
        }
    }

    protected boolean hasDefaulValuesForTable(String tableName) {
        String key = tableName.toLowerCase();
        return this.tableDefaultValues.containsKey(key);
    }

    protected Map<String, Object> getDefaultValuesForTable(String tableName) {
        String key = tableName.toLowerCase();
        if (!this.hasDefaulValuesForTable(key)) {
            return new HashMap<String, Object>();
        }
        return this.tableDefaultValues.get(key);
    }

    protected void addTableDefaultValue(String tableName, String columnName, Object value) {
        String key = tableName.toLowerCase();
        if (!this.hasDefaulValuesForTable(key)) {
            this.tableDefaultValues.put(key, new LinkedHashMap());
        }
        this.tableDefaultValues.get(key).put(BuilderUtil.convertCase(columnName, this.config), value);
    }
}

